/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.OS;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MAction
extends AbstractAction
implements MIcon.Name {
    public static final String ALTERNATE_ACCELERATOR_KEY = "org.makagiga.commons.MAction.ALTERNATE_ACCELERATOR_KEY";
    public static final String MOUSE_GESTURE_KEY = "org.makagiga.commons.MAction.MOUSE_GESTURE_KEY";
    public static final String VISIBLE_KEY = "org.makagiga.commons.MAction.VISIBLE_KEY";
    public static final Object NO_SOURCE = new Object();
    public ScriptEvent onAction;
    private ActionEvent actionEvent;
    private static int menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private PropertyAccess<Boolean> authProperty;
    private static final String HIGHLIGHTED_COMPONENT_KEY = "org.makagiga.commons.MAction.HIGHLIGHTED_COMPONENT_KEY";

    public MAction() {
        this(null, (Icon)null, 0, 0);
    }

    public MAction(MActionInfo mActionInfo) {
        this(mActionInfo.getText(), mActionInfo.getIconName(), mActionInfo.getKeyCode(), mActionInfo.getModifiers());
    }

    public MAction(String string) {
        this(string, (Icon)null, 0, 0);
    }

    public MAction(String string, Icon icon) {
        this(string, icon, 0, 0);
    }

    public MAction(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public MAction(String string, String string2, int n) {
        this(string, string2, n, 0);
    }

    public MAction(String string, String string2, KeyStroke keyStroke) {
        this(string, string2, keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    public MAction(String string, int n, int n2) {
        this(string, (Icon)null, n, n2);
    }

    public MAction(String string, int n) {
        this(string, (Icon)null, n, 0);
    }

    public MAction(String string, Icon icon, int n, int n2) {
        this.setName(string);
        if (n != 0) {
            this.setAcceleratorKey(n, n2);
        }
        if (icon != null) {
            this.setSmallIcon(icon);
        }
    }

    public MAction(String string, String string2, int n, int n2) {
        this(string, (Icon)null, n, n2);
        this.setIcon(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (!this.isAuthorized()) {
            TK.beep();
            return;
        }
        try {
            this.actionEvent = actionEvent;
            if (this.onAction != null && "true".equals(this.onAction.event())) {
                return;
            }
            this.onAction();
        }
        finally {
            this.actionEvent = null;
        }
    }

    public void connect(JComponent jComponent, int n) {
        MAction.connect(jComponent, n, (Action)this);
    }

    public void connect(JComponent jComponent, int n, int n2) {
        MAction.connect(jComponent, n, n2, this);
    }

    public void connect(JComponent jComponent, int n, int n2, int n3) {
        MAction.connect(jComponent, n, n2, n3, this);
    }

    public void connect(JComponent jComponent, String string) {
        MAction.connect(jComponent, string, (Action)this);
    }

    public static void connect(JComponent jComponent, int n, Action action) {
        KeyStroke keyStroke = MAction.getValue(action, "AcceleratorKey", null);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Action has no accelerator key");
        }
        MAction.connect(jComponent, n, keyStroke.getKeyCode(), keyStroke.getModifiers(), action);
        KeyStroke keyStroke2 = MAction.getValue(action, ALTERNATE_ACCELERATOR_KEY, null);
        if (keyStroke2 != null && !keyStroke2.equals(keyStroke)) {
            MAction.connect(jComponent, n, keyStroke2.getKeyCode(), keyStroke2.getModifiers(), action);
        }
    }

    public static void connect(JComponent jComponent, int n, int n2, Action action) {
        MAction.connect(jComponent, n, n2, 0, action);
    }

    public static void connect(JComponent jComponent, int n, int n2, int n3, Action action) {
        String string = MAction.getValue(action, "Name", null);
        if (TK.isEmpty(string)) {
            throw new IllegalArgumentException("Cannot connect action without name");
        }
        jComponent.getActionMap().put(string, action);
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(n2, n3), string);
    }

    public static void connect(JComponent jComponent, String string, Action action) {
        ActionMap actionMap = jComponent.getActionMap().getParent();
        actionMap.put(string, action);
    }

    public void disconnect(JComponent jComponent, int n) {
        String string = this.getName();
        if (TK.isEmpty(string)) {
            throw new IllegalArgumentException("Cannot disconnect action without name");
        }
        jComponent.getActionMap().remove(string);
        jComponent.getInputMap(n).remove(this.getAcceleratorKey());
        KeyStroke keyStroke = this.getAlternateAcceleratorKey();
        if (keyStroke != null) {
            jComponent.getInputMap(n).remove(keyStroke);
        }
    }

    public void fire() {
        this.fire(NO_SOURCE);
    }

    public void fire(Object object) {
        MAction.fire(this, object);
    }

    public static void fire(Action action, Object object) {
        if (action == null) {
            return;
        }
        if (!action.isEnabled()) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(object, 1001, "");
        action.actionPerformed(actionEvent);
    }

    public static void fire(MouseWheelEvent mouseWheelEvent, String string, String string2, JComponent jComponent) {
        MAction.fire(mouseWheelEvent.getWheelRotation() < 0 ? string : string2, jComponent);
        mouseWheelEvent.consume();
    }

    public static void fire(String string, JComponent jComponent) {
        if (string != null && jComponent != null) {
            MAction.fire(jComponent.getActionMap().get(string), (Object)jComponent);
        }
    }

    public KeyStroke getAcceleratorKey() {
        return this.getValue("AcceleratorKey", null);
    }

    public void setAcceleratorKey(int n, int n2) {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(n, n2));
    }

    public void setAcceleratorKey(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public ActionEvent getActionEvent() {
        return this.actionEvent;
    }

    public KeyStroke getAlternateAcceleratorKey() {
        return this.getValue(ALTERNATE_ACCELERATOR_KEY, null);
    }

    public void setAlternateAcceleratorKey(int n, int n2) {
        this.putValue(ALTERNATE_ACCELERATOR_KEY, KeyStroke.getKeyStroke(n, n2));
    }

    public void setAlternateAcceleratorKey(KeyStroke keyStroke) {
        this.putValue(ALTERNATE_ACCELERATOR_KEY, keyStroke);
    }

    public static KeyStroke getFindNextKeyStroke() {
        if (OS.isMac()) {
            return KeyStroke.getKeyStroke(71, MAction.getMenuMask());
        }
        return KeyStroke.getKeyStroke(114, 0);
    }

    public static KeyStroke getFullScreenKeyStroke() {
        if (OS.isKDE()) {
            return KeyStroke.getKeyStroke(70, MAction.getMenuMask() | 1);
        }
        return KeyStroke.getKeyStroke(122, 0);
    }

    public String getHelp() {
        return this.getValue("LongDescription", null);
    }

    public void setHelp(String string) {
        this.putValue("LongDescription", string);
    }

    public Component getHighlightedComponent() {
        WeakReference weakReference = this.getValue(HIGHLIGHTED_COMPONENT_KEY, null);
        return weakReference == null ? null : (Component)weakReference.get();
    }

    public void setHighlightedComponent(Component component) {
        WeakReference weakReference = this.getValue(HIGHLIGHTED_COMPONENT_KEY, null);
        if (weakReference != null) {
            weakReference.clear();
        }
        this.putValue(HIGHLIGHTED_COMPONENT_KEY, component == null ? null : new WeakReference<Component>(component));
    }

    public Icon getIcon() {
        Icon icon = this.getLargeIcon();
        return icon == null ? this.getSmallIcon() : icon;
    }

    @Deprecated
    public void setIcon(String string) {
        this.setLargeIcon(string);
        this.setSmallIcon(string);
    }

    public static Icon getIcon(Action action, MIcon.Size size) {
        switch (size) {
            case SMALL: {
                return MAction.getValue(action, "SmallIcon", null);
            }
            case MEDIUM: {
                String string;
                Icon icon = MAction.getValue(action, "SwingLargeIconKey", null);
                if (icon == null) {
                    icon = MAction.getValue(action, "SmallIcon", null);
                }
                if (icon instanceof MIcon && (string = ((MIcon)MIcon.class.cast(icon)).getName()) != null) {
                    icon = MIcon.medium(string);
                }
                return icon;
            }
        }
        Icon icon = MAction.getValue(action, "SwingLargeIconKey", null);
        if (icon == null) {
            icon = MAction.getValue(action, "SmallIcon", null);
        }
        return icon;
    }

    public Icon getLargeIcon() {
        return this.getValue("SwingLargeIconKey", null);
    }

    public void setLargeIcon(Icon icon) {
        this.putValue("SwingLargeIconKey", icon);
    }

    public void setLargeIcon(String string) {
        this.setLargeIcon(MIcon.stock(string));
    }

    public String getLongDescription() {
        return this.getValue("LongDescription", null);
    }

    public void setLongDescription(String string) {
        this.putValue("LongDescription", string);
    }

    public static int getMenuMask() {
        return menuMask;
    }

    public String getMouseGesture() {
        return this.getValue(MOUSE_GESTURE_KEY, null);
    }

    public void setMouseGesture(String string) {
        this.putValue(MOUSE_GESTURE_KEY, string);
    }

    public String getName() {
        return this.getValue("Name", null);
    }

    public void setName(String string) {
        this.putValue("Name", TK.isEmpty(string) ? null : string);
    }

    public static KeyStroke getRedoKeyStroke() {
        if (OS.isKDE() || OS.isMac()) {
            return KeyStroke.getKeyStroke(90, MAction.getMenuMask() | 1);
        }
        return KeyStroke.getKeyStroke(89, MAction.getMenuMask());
    }

    public String getShortDescription() {
        return this.getValue("ShortDescription", null);
    }

    public void setShortDescription(String string) {
        this.putValue("ShortDescription", string);
    }

    public Icon getSmallIcon() {
        return this.getValue("SmallIcon", null);
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setSmallIcon(String string) {
        this.setSmallIcon(MIcon.small(string));
    }

    public Window getSourceWindow() {
        Object object = this.actionEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            Window window = UI.windowFor(component);
            if (window != null) {
                return window;
            }
            if ((component = component.getParent()) instanceof JPopupMenu) {
                if ((component = ((JPopupMenu)JPopupMenu.class.cast(component)).getInvoker()) instanceof MMenu && (component = component.getParent()) instanceof JPopupMenu) {
                    component = ((JPopupMenu)JPopupMenu.class.cast(component)).getInvoker();
                }
                if (component != null) {
                    return UI.windowFor(component);
                }
            }
        }
        return null;
    }

    public String getToolTipText() {
        return MAction.getToolTipText(this);
    }

    public static String getToolTipText(Action action) {
        return MAction.getValue(action, "ShortDescription", null);
    }

    public void setToolTipText(String string) {
        this.putValue("ShortDescription", string);
    }

    public <T> T getValue(String string, T t) {
        Object object = this.getValue(string);
        return (T)(object == null ? t : object);
    }

    public static <T> T getValue(Action action, String string, T t) {
        Object object = action.getValue(string);
        return (T)(object == null ? t : object);
    }

    public boolean isSelected() {
        return this.getValue("SwingSelectedKey", false);
    }

    public void setSelected(boolean bl) {
        this.putValue("SwingSelectedKey", bl);
    }

    public boolean isVisible() {
        return this.getValue(VISIBLE_KEY, true);
    }

    public void setVisible(boolean bl) {
        this.putValue(VISIBLE_KEY, bl);
    }

    public static boolean isTrigger(InputEvent inputEvent) {
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            return TK.isKeyStroke(keyEvent, 10) || TK.isKeyStroke(keyEvent, 32);
        }
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            return MMouseAdapter.isLeft(mouseEvent) && MMouseAdapter.isSingleClick(mouseEvent);
        }
        return false;
    }

    public void onAction() {
    }

    public void setHTMLHelp(String string) {
        this.setLongDescription(TK.isEmpty(string) ? null : UI.makeHTML(string));
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.getIcon());
    }

    @Override
    public void setIconName(String string) {
        this.setLargeIcon(string);
        this.setSmallIcon(string);
    }

    public void setActionInfo(MActionInfo mActionInfo) {
        this.setAcceleratorKey(mActionInfo.getKeyStroke());
        this.setIconName(mActionInfo.getIconName());
        this.setName(mActionInfo.getText());
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isAuthorized()) {
            super.setEnabled(bl);
        } else {
            super.setEnabled(false);
        }
    }

    public MActionInfo toActionInfo() {
        KeyStroke keyStroke = this.getAcceleratorKey();
        if (keyStroke == null) {
            return new MActionInfo(this.getName(), this.getIconName());
        }
        return new MActionInfo(this.getName(), this.getIconName(), keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    protected void setAuthorizationProperty(PropertyAccess<Boolean> propertyAccess) {
        this.authProperty = propertyAccess;
        super.setEnabled(this.isAuthorized());
    }

    private boolean isAuthorized() {
        return this.authProperty == null || Boolean.TRUE.equals(this.authProperty.get());
    }

    public static interface ScriptEvent {
        public String event();
    }
}

