/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.FS;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;

public final class MDataTransfer {
    public static final DataFlavor URL_DATA_FLAVOR = new DataFlavor(URL.class, "URL");
    public static final String IMAGE_PNG_MIME_TYPE = "image/png";
    private static final String UTF_8_CHARSET = "UTF-8";

    public static void debug(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            MLogger.debug("data", "[%s] %s, %s", dataFlavor.getHumanPresentableName(), dataFlavor.getMimeType(), dataFlavor.getRepresentationClass());
        }
    }

    public static DataFlavor findBestHTMLFlavor(DataFlavor[] dataFlavorArray, boolean bl) {
        boolean bl2 = false;
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        DataFlavor dataFlavor3 = null;
        DataFlavor dataFlavor4 = null;
        for (DataFlavor dataFlavor5 : dataFlavorArray) {
            String string = MDataTransfer.getSimpleMimeType(dataFlavor5);
            String string2 = dataFlavor5.getSubType();
            if ("text/html".equals(string)) {
                String string3 = dataFlavor5.getParameter("charset");
                if ("[B".equals(dataFlavor5.getRepresentationClass().getName())) {
                    if (dataFlavor4 != null || !UTF_8_CHARSET.equalsIgnoreCase(string3)) continue;
                    dataFlavor4 = dataFlavor5;
                    continue;
                }
                if (!InputStream.class.equals(dataFlavor5.getRepresentationClass())) continue;
                if (dataFlavor2 == null && "unicode".equalsIgnoreCase(string3)) {
                    dataFlavor2 = dataFlavor5;
                    continue;
                }
                if (dataFlavor3 == null && UTF_8_CHARSET.equalsIgnoreCase(string3)) {
                    dataFlavor3 = dataFlavor5;
                    continue;
                }
                if (dataFlavor != null || !TK.isEmpty(string3)) continue;
                dataFlavor = dataFlavor5;
                continue;
            }
            if (string2 == null || bl2 || !string2.contains("_moz_") && !string2.contains("-moz-")) continue;
            bl2 = true;
        }
        if (bl2 && bl && OS.isLinux()) {
            return null;
        }
        if (dataFlavor4 != null) {
            return dataFlavor4;
        }
        if (dataFlavor3 != null) {
            return dataFlavor3;
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        if (dataFlavor != null) {
            return dataFlavor;
        }
        return null;
    }

    public static DataFlavor findBestImageFlavor(DataFlavor[] dataFlavorArray, String string) {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        for (DataFlavor dataFlavor3 : dataFlavorArray) {
            if (dataFlavor3.equals(DataFlavor.imageFlavor)) {
                dataFlavor = dataFlavor3;
                continue;
            }
            if (string == null || !MDataTransfer.getSimpleMimeType(dataFlavor3).equals(string)) continue;
            dataFlavor2 = dataFlavor3;
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        return dataFlavor;
    }

    public static DataFlavor[] getAvailableDataFlavors(Object object) {
        if (object instanceof Clipboard) {
            try {
                return ((Clipboard)Clipboard.class.cast(object)).getAvailableDataFlavors();
            }
            catch (NullPointerException nullPointerException) {
                MLogger.exception(nullPointerException);
                return new DataFlavor[0];
            }
        }
        if (object instanceof Transferable) {
            return ((Transferable)Transferable.class.cast(object)).getTransferDataFlavors();
        }
        throw new IllegalArgumentException("Unsupported data source: " + object);
    }

    public static Object getData(Object object, DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        if (object instanceof Clipboard) {
            try {
                return MClipboard.getContents((Clipboard)object, dataFlavor);
            }
            catch (ClipboardException clipboardException) {
                throw new IOException(clipboardException);
            }
        }
        if (object instanceof Transferable) {
            return ((Transferable)Transferable.class.cast(object)).getTransferData(dataFlavor);
        }
        throw new IllegalArgumentException("Unsupported data source: " + object);
    }

    public static <T> T getData(Transferable transferable, DataFlavor dataFlavor, Class<T> clazz) throws IOException, UnsupportedFlavorException {
        Object object = transferable.getTransferData(dataFlavor);
        if (object != null && clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return null;
    }

    public static String getHTML(Object object, DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        byte[] byArray;
        Object object2;
        Object object3 = MDataTransfer.getData(object, dataFlavor);
        if (object3 instanceof InputStream) {
            object2 = (InputStream)object3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FS.copyStream((InputStream)object2, byteArrayOutputStream);
            FS.close((Closeable)object2);
            FS.close(byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        } else if (object3 != null && object3.getClass().getName().equals("[B")) {
            byArray = (byte[])object3;
        } else {
            throw new IOException("No input stream for " + dataFlavor);
        }
        object2 = MDataTransfer.fixEncoding(byArray, UTF_8_CHARSET);
        try {
            object2 = TK.substring((String)object2, "<!--StartFragment-->", "<!--EndFragment-->", false);
        }
        catch (ParseException parseException) {
            MLogger.debug("data", "<!--StartFragment--> or <!--EndFragment--> not found");
        }
        return object2;
    }

    public static Image getImage(Object object) throws IOException, UnsupportedFlavorException {
        DataFlavor[] dataFlavorArray = MDataTransfer.getAvailableDataFlavors(object);
        DataFlavor dataFlavor = MDataTransfer.findBestImageFlavor(dataFlavorArray, IMAGE_PNG_MIME_TYPE);
        if (dataFlavor == null) {
            dataFlavor = DataFlavor.imageFlavor;
        }
        return MDataTransfer.getImage(object, dataFlavor);
    }

    public static Image getImage(Object object, DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        return MDataTransfer.toImage(MDataTransfer.getData(object, dataFlavor));
    }

    public static String getSimpleMimeType(DataFlavor dataFlavor) {
        return dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
    }

    public static String getString(Object object) throws IOException, UnsupportedFlavorException {
        return MDataTransfer.toString(MDataTransfer.getData(object, DataFlavor.stringFlavor));
    }

    public static String getString(Transferable transferable) throws IOException, UnsupportedFlavorException {
        String string = MDataTransfer.getData(transferable, DataFlavor.stringFlavor, String.class);
        return MDataTransfer.toString(string);
    }

    public static Transferable getTransferable(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDrop()) {
            return transferSupport.getTransferable();
        }
        return MClipboard.getDefault().getContents(null);
    }

    public static boolean importFromClipboard(JComponent jComponent) {
        TransferHandler transferHandler = jComponent.getTransferHandler();
        if (transferHandler == null) {
            return false;
        }
        TransferHandler.TransferSupport transferSupport = new TransferHandler.TransferSupport((Component)jComponent, MClipboard.getDefault().getContents(null));
        if (transferHandler.canImport(transferSupport)) {
            return transferHandler.importData(transferSupport);
        }
        return false;
    }

    public static boolean isImage(URL uRL) {
        String string = uRL.getPath();
        if (!string.isEmpty()) {
            String[] stringArray;
            for (String string2 : stringArray = ImageIO.getReaderFileSuffixes()) {
                if (!string.endsWith("." + string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Image toImage(Object object) throws IOException {
        if (object instanceof Image) {
            return (Image)object;
        }
        if (object instanceof InputStream) {
            return ImageIO.read((InputStream)object);
        }
        return null;
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private MDataTransfer() {
    }

    private static String fixEncoding(byte[] byArray, String string) throws UnsupportedEncodingException {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        boolean bl = false;
        if ("UTF8".equals(string) || UTF_8_CHARSET.equals(string)) {
            for (byte by : byArray) {
                if (by != 0) continue;
                bl = true;
                break;
            }
        }
        if (bl && byArray.length >= 6 && byArray[0] == -17 && byArray[1] == -65 && byArray[2] == -67 && byArray[3] == -17 && byArray[4] == -65 && byArray[5] == -67) {
            int n = 6;
            return new String(byArray, n, byArray.length - n, "UTF-16LE");
        }
        return new String(byArray, string);
    }
}

