/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSeparator;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;

public class MLayout
extends GroupLayout {
    private GroupLayout.Alignment defaultVerticalAlignment;
    private static final Dimension DEFAULT = new Dimension(-1, -1);
    private final Stack<AddOrientation> addOrientationStack = new Stack();
    private final Stack<GroupLayout.Group> hStack = new Stack();
    private final Stack<GroupLayout.Group> vStack = new Stack();

    public MLayout(Container container, boolean bl) {
        super(container);
        if (bl) {
            this.setAutoCreateGaps(bl);
        }
        GroupLayout.SequentialGroup sequentialGroup = this.createSequentialGroup();
        this.setHorizontalGroup(sequentialGroup);
        GroupLayout.ParallelGroup parallelGroup = this.createParallelGroup();
        this.setVerticalGroup(parallelGroup);
        this.addOrientationStack.push(AddOrientation.HORIZONTAL);
        this.hStack.push(sequentialGroup);
        this.vStack.push(parallelGroup);
    }

    public MLayout addComponent(Component component) {
        return this.addComponent(component, this.defaultVerticalAlignment == GroupLayout.Alignment.CENTER);
    }

    public MLayout addComponent(Component component, boolean bl) {
        this.getHGroup().addComponent(component);
        if (bl) {
            ((GroupLayout.ParallelGroup)GroupLayout.ParallelGroup.class.cast(this.getVGroup())).addComponent(component, GroupLayout.Alignment.CENTER);
        } else {
            this.getVGroup().addComponent(component);
        }
        return this;
    }

    public MLayout addComponent(Component component, Dimension dimension, Dimension dimension2, Dimension dimension3) {
        if (dimension == null) {
            dimension = DEFAULT;
        }
        if (dimension2 == null) {
            dimension2 = DEFAULT;
        }
        if (dimension3 == null) {
            dimension3 = DEFAULT;
        }
        this.getHGroup().addComponent(component, dimension.width, dimension2.width, dimension3.width);
        this.getVGroup().addComponent(component, dimension.height, dimension2.height, dimension3.height);
        return this;
    }

    public MLayout addComponent(Component component, String string) {
        switch (this.getAddOrientation()) {
            case HORIZONTAL: {
                this.addComponent((Component)MLabel.createFor(component, string, 11), true);
                if (!this.getAutoCreateGaps()) {
                    this.addGap(10);
                }
                this.addComponent(component, true);
                break;
            }
            case VERTICAL: {
                this.addComponent(MLabel.createFor(component, string));
                if (!this.getAutoCreateGaps()) {
                    this.addGap();
                }
                this.addComponent(component);
                break;
            }
            default: {
                throw new WTFError(this.getAddOrientation());
            }
        }
        return this;
    }

    public MLayout addContentGap() {
        return this.addGap(10);
    }

    public MLayout addFixedComponent(Component component, boolean bl, Dimension dimension) {
        this.getHGroup().addComponent(component, dimension.width, dimension.width, dimension.width);
        if (bl) {
            ((GroupLayout.ParallelGroup)GroupLayout.ParallelGroup.class.cast(this.getVGroup())).addComponent(component, GroupLayout.Alignment.CENTER, dimension.height, dimension.height, dimension.height);
        } else {
            this.getVGroup().addComponent(component, dimension.height, dimension.height, dimension.height);
        }
        return this;
    }

    public MLayout addGap() {
        return this.addGap(5);
    }

    public MLayout addGap(int n) {
        switch (this.getAddOrientation()) {
            case HORIZONTAL: {
                this.getHGroup().addGap(n);
                return this;
            }
            case VERTICAL: {
                this.getVGroup().addGap(n);
                return this;
            }
        }
        throw new WTFError(this.getAddOrientation());
    }

    public MLayout addHStretchComponent(Component component) {
        return this.addHStretchComponent(component, this.defaultVerticalAlignment == GroupLayout.Alignment.CENTER);
    }

    public MLayout addHStretchComponent(Component component, boolean bl) {
        this.getHGroup().addComponent(component, 1, 1, Integer.MAX_VALUE);
        if (bl) {
            ((GroupLayout.ParallelGroup)GroupLayout.ParallelGroup.class.cast(this.getVGroup())).addComponent(component, GroupLayout.Alignment.CENTER);
        } else {
            this.getVGroup().addComponent(component);
        }
        return this;
    }

    public MLayout addScrollable(JComponent jComponent) {
        return this.addScrollable(jComponent, 0);
    }

    public MLayout addScrollable(JComponent jComponent, String string) {
        return this.addScrollable(jComponent, 0, string);
    }

    public MLayout addScrollable(JComponent jComponent, int n) {
        if (UI.needScrollPane(jComponent)) {
            return this.addComponent(new MScrollPane(jComponent, n));
        }
        return this.addComponent(jComponent);
    }

    public MLayout addScrollable(JComponent jComponent, int n, String string) {
        if (UI.needScrollPane(jComponent)) {
            return this.addComponent((Component)new MScrollPane(jComponent, n), string);
        }
        return this.addComponent((Component)jComponent, string);
    }

    public MLayout addSeparator() {
        switch (this.getAddOrientation()) {
            case HORIZONTAL: {
                this.addComponent(MSeparator.createVertical());
                return this;
            }
            case VERTICAL: {
                this.addComponent(MSeparator.createHorizontal());
                return this;
            }
        }
        throw new WTFError(this.getAddOrientation());
    }

    public MLayout addStretch() {
        switch (this.getAddOrientation()) {
            case HORIZONTAL: {
                this.addComponent(Box.createHorizontalGlue());
                return this;
            }
            case VERTICAL: {
                this.addComponent(Box.createVerticalGlue());
                return this;
            }
        }
        throw new WTFError(this.getAddOrientation());
    }

    public MLayout beginColumns() {
        this.addOrientationStack.push(AddOrientation.HORIZONTAL);
        GroupLayout.Group group = this.createSequentialGroup();
        this.getHGroup().addGroup(group);
        this.hStack.push(group);
        group = this.createParallelGroup();
        this.getVGroup().addGroup(group);
        this.vStack.push(group);
        return this;
    }

    @Deprecated
    public MLayout beginColumnsInRow() {
        this.beginRows();
        this.beginColumns();
        return this;
    }

    public MLayout beginRows() {
        return this.beginRows(false);
    }

    public MLayout beginRows(boolean bl) {
        this.addOrientationStack.push(AddOrientation.VERTICAL);
        GroupLayout.Group group = bl ? this.createParallelGroup(GroupLayout.Alignment.CENTER) : this.createParallelGroup();
        this.getHGroup().addGroup(group);
        this.hStack.push(group);
        group = this.createSequentialGroup();
        this.getVGroup().addGroup(group);
        this.vStack.push(group);
        return this;
    }

    public MLayout end() {
        this.addOrientationStack.pop();
        this.hStack.pop();
        this.vStack.pop();
        return this;
    }

    @Deprecated
    public MLayout endColumnsInRow() {
        this.end();
        this.end();
        return this;
    }

    public GroupLayout.Alignment getDefaultVerticalAlignment() {
        return this.defaultVerticalAlignment;
    }

    public void setDefaultVerticalAlignment(GroupLayout.Alignment alignment) {
        this.defaultVerticalAlignment = alignment;
    }

    @Deprecated
    public GroupLayout getGroupLayout() {
        return this;
    }

    @Deprecated
    public LayoutManager getEngine() {
        return this;
    }

    @Deprecated
    public static boolean isGroupLayout(Container container) {
        return container.getLayout() instanceof GroupLayout || container.getLayout() instanceof MLayout;
    }

    public void linkLabelSize(Component ... componentArray) {
        MArrayList<Component> mArrayList = new MArrayList<Component>(componentArray.length);
        for (Component component : componentArray) {
            if (!(component instanceof JComponent)) continue;
            JLabel jLabel = MLabel.getLabel((JComponent)component);
            if (jLabel != null) {
                mArrayList.add(jLabel);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            mArrayList.add(component);
        }
        this.linkSize(mArrayList.toArray(Component.class));
    }

    @Override
    public void setAutoCreateContainerGaps(boolean bl) {
        super.setAutoCreateContainerGaps(bl);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        super.addLayoutComponent(component, object);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        super.addLayoutComponent(string, component);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return super.getLayoutAlignmentX(container);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return super.getLayoutAlignmentY(container);
    }

    @Override
    public void invalidateLayout(Container container) {
        super.invalidateLayout(container);
    }

    @Override
    public void layoutContainer(Container container) {
        super.layoutContainer(container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return super.maximumLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return super.minimumLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return super.preferredLayoutSize(container);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        super.removeLayoutComponent(component);
    }

    private AddOrientation getAddOrientation() {
        return this.addOrientationStack.peek();
    }

    private GroupLayout.Group getHGroup() {
        return this.hStack.peek();
    }

    private GroupLayout.Group getVGroup() {
        return this.vStack.peek();
    }

    private static enum AddOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

