/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMenuItem;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;

public class MMenu
extends JMenu
implements Iterable<JMenuItem> {
    private boolean splitMenu;
    private int maxHeight = -1;
    private MMenu _currentMenu;
    private static StaticComponentHighlightHandler staticComponentHighlightHandler = new StaticComponentHighlightHandler();
    private static StaticHandler staticHandler = new StaticHandler();
    private static WeakReference<JPopupMenu> currentPopupRef;

    public MMenu() {
        this(null, (Icon)null);
    }

    public MMenu(MActionInfo mActionInfo) {
        this(mActionInfo.getText(), mActionInfo.getIconName());
    }

    public MMenu(String string) {
        this(string, (Icon)null);
    }

    public MMenu(String string, Icon icon) {
        this.setDelay(500);
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setText(Mnemonic.set(this, string));
        this.addMenuListener(staticHandler);
    }

    public MMenu(String string, String string2) {
        this(string, MIcon.small(string2));
    }

    public MMenuItem add(MAction mAction) {
        MMenuItem mMenuItem = (MMenuItem)this.getCurrentMenu().add(new MMenuItem(mAction));
        mMenuItem.addMouseListener(staticComponentHighlightHandler);
        return mMenuItem;
    }

    @Override
    public MMenuItem add(String string) {
        MMenuItem mMenuItem = (MMenuItem)this.getCurrentMenu().add(new MMenuItem(string));
        mMenuItem.addMouseListener(staticComponentHighlightHandler);
        return mMenuItem;
    }

    public JCheckBoxMenuItem addCheckBox(Action action) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.getCurrentMenu().add(new JCheckBoxMenuItem(action));
        jCheckBoxMenuItem.addMouseListener(staticComponentHighlightHandler);
        String string = MAction.getValue(action, "LongDescription", null);
        jCheckBoxMenuItem.setToolTipText(string);
        return jCheckBoxMenuItem;
    }

    public JCheckBoxMenuItem addCheckBox(MAction mAction, boolean bl) {
        mAction.setSelected(bl);
        return this.addCheckBox(mAction);
    }

    public void addItemsFromMenu(MMenu mMenu) {
        Component[] componentArray;
        for (Component component : componentArray = mMenu.getMenuComponents()) {
            this.getCurrentMenu().add(component);
        }
    }

    public JRadioButtonMenuItem addRadioButton(MAction mAction) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.getCurrentMenu().add(new JRadioButtonMenuItem(mAction));
        jRadioButtonMenuItem.addMouseListener(staticComponentHighlightHandler);
        jRadioButtonMenuItem.setToolTipText(mAction.getLongDescription());
        return jRadioButtonMenuItem;
    }

    public JRadioButtonMenuItem addRadioButton(MAction mAction, boolean bl) {
        mAction.setSelected(bl);
        return this.addRadioButton(mAction);
    }

    @Override
    public void addSeparator() {
        if (this._currentMenu == null) {
            super.addSeparator();
        } else {
            this._currentMenu.addSeparator();
        }
    }

    public void addSeparator(boolean bl) {
        if (!bl) {
            int n = this.getMenuComponentCount();
            if (n == 0) {
                return;
            }
            Component component = this.getMenuComponent(n - 1);
            if (component instanceof JPopupMenu.Separator || component instanceof MPanel && ((MPanel)MPanel.class.cast(component)).getComponentCount() == 1 && ((MPanel)MPanel.class.cast(component)).getComponent(0) instanceof Title) {
                return;
            }
        }
        this.addSeparator();
    }

    public Title addTitle(MActionInfo mActionInfo) {
        return this.addTitle(mActionInfo.getDialogTitle(), mActionInfo.getIconName());
    }

    public Title addTitle(String string) {
        return this.addTitle(string, (Icon)null);
    }

    public Title addTitle(String string, Icon icon) {
        Title title = new Title(string, icon);
        MPanel mPanel = MPanel.createBorderPanel();
        mPanel.addCenter(title);
        mPanel.setOpaque(false);
        this.getCurrentMenu().add(mPanel);
        return title;
    }

    public Title addTitle(String string, String string2) {
        return this.addTitle(string, MIcon.small(string2));
    }

    public Icon getComponentIcon() {
        Component component = this.getComponent();
        return component instanceof AbstractButton ? ((AbstractButton)AbstractButton.class.cast(component)).getIcon() : null;
    }

    public static JPopupMenu getCurrentPopup() {
        if (currentPopupRef == null) {
            return null;
        }
        return (JPopupMenu)currentPopupRef.get();
    }

    public boolean getSplitMenu() {
        return this.splitMenu;
    }

    public void setSplitMenu(boolean bl) {
        this._currentMenu = null;
        this.splitMenu = bl;
    }

    public static void hideCurrentPopup() {
        JPopupMenu jPopupMenu = MMenu.getCurrentPopup();
        if (jPopupMenu != null) {
            jPopupMenu.setVisible(false);
            currentPopupRef.clear();
        }
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public Iterator<JMenuItem> iterator() {
        return new AbstractIterator<JMenuItem>(){

            @Override
            public JMenuItem getObjectAt(int n) {
                return MMenu.this.getItem(n);
            }

            @Override
            public int getObjectCount() {
                return MMenu.this.getItemCount();
            }
        };
    }

    @Override
    public void removeAll() {
        this._currentMenu = null;
        super.removeAll();
        this.putClientProperty("org.makagiga.commons.MMenu.mnemonicDone", false);
    }

    public void removeFrom(int n) {
        this._currentMenu = null;
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            this.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMnemonics() {
        if (UI.getClientProperty(this, "org.makagiga.commons.MMenu.mnemonicDone", false).booleanValue()) {
            return;
        }
        if (UI.getClientProperty(this, "org.makagiga.commons.MMenu.mnemonicLock", false).booleanValue()) {
            return;
        }
        try {
            this.putClientProperty("org.makagiga.commons.MMenu.mnemonicLock", true);
            new Mnemonic(this);
        }
        finally {
            this.putClientProperty("org.makagiga.commons.MMenu.mnemonicDone", true);
            this.putClientProperty("org.makagiga.commons.MMenu.mnemonicLock", null);
        }
    }

    public JPopupMenu showPopup(Component component) {
        Point point = component instanceof JComponent ? ((JComponent)JComponent.class.cast(component)).getPopupLocation(null) : null;
        if (point == null) {
            point = component.getMousePosition();
        }
        if (point == null) {
            return this.showPopup(component, 0, 0);
        }
        return this.showPopup(component, point);
    }

    public JPopupMenu showPopup(Component component, Component component2) {
        Rectangle rectangle = component2.getBounds();
        return this.showPopup(component, new Point(rectangle.x, rectangle.y + rectangle.height));
    }

    public JPopupMenu showPopup(Component component, Point point) {
        if (point == null) {
            return this.showPopup(component);
        }
        return this.showPopup(component, point.x, point.y);
    }

    public JPopupMenu showPopup(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        MMenu.showPopup(jPopupMenu, component, n, n2);
        return jPopupMenu;
    }

    public static void showPopup(final JPopupMenu jPopupMenu, Component component, int n, int n2) {
        block3: {
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    if (currentPopupRef != null) {
                        currentPopupRef.clear();
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (ComponentHighlight.isInstance()) {
                        ComponentHighlight.getInstance().hideCurrent(true);
                    }
                    if (currentPopupRef != null) {
                        currentPopupRef.clear();
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    currentPopupRef = new WeakReference<JPopupMenu>(jPopupMenu);
                    new Mnemonic(jPopupMenu);
                }
            });
            try {
                jPopupMenu.show(component, n, n2);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                if (MLogger.isDeveloper()) {
                    MLogger.exception(illegalComponentStateException);
                }
                if (component == null || !component.isShowing()) break block3;
                jPopupMenu.show(null, n, n2);
            }
        }
    }

    public JPopupMenu showPopup(InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            return this.showPopup((Component)inputEvent.getSource(), ((MouseEvent)MouseEvent.class.cast(inputEvent)).getPoint());
        }
        return this.showPopup((Component)inputEvent.getSource());
    }

    protected MMenu getCurrentMenu() {
        int n;
        Component component;
        Component[] componentArray;
        if (!this.splitMenu) {
            return this;
        }
        if (this.maxHeight == -1) {
            this.maxHeight = UI.WindowSize.LARGE.getDimension().height;
        }
        if ((componentArray = this.currentMenu().getMenuComponents()).length > 0) {
            component = componentArray[0];
            for (Component component2 : componentArray) {
                if (!(component2 instanceof JMenuItem)) continue;
                component = component2;
                break;
            }
            n = component.getPreferredSize().height * componentArray.length + 50;
        } else {
            n = 0;
        }
        if (n > this.maxHeight) {
            component = new MMenu(UI._("More..."));
            UI.setStyle("font-style: italic", component);
            MMenu mMenu = this.currentMenu();
            int n2 = mMenu.getMenuComponentCount();
            if (n2 > 0 && !(mMenu.getMenuComponent(n2 - 1) instanceof JPopupMenu.Separator)) {
                mMenu.addSeparator();
            }
            mMenu.add((JMenuItem)component);
            this._currentMenu = component;
        }
        return this.currentMenu();
    }

    private MMenu currentMenu() {
        return this._currentMenu == null ? this : this._currentMenu;
    }

    private static final class StaticHandler
    extends MMenuAdapter {
        @Override
        protected void onSelect(MMenu mMenu) {
            mMenu.setMnemonics();
        }

        private StaticHandler() {
        }
    }

    private static final class StaticComponentHighlightHandler
    extends MMouseAdapter {
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private StaticComponentHighlightHandler() {
        }

        private Component getHighlightedComponent(MouseEvent mouseEvent) {
            Action action;
            if (mouseEvent.getSource() instanceof AbstractButton && (action = ((AbstractButton)AbstractButton.class.cast(mouseEvent.getSource())).getAction()) instanceof MAction) {
                return ((MAction)MAction.class.cast(action)).getHighlightedComponent();
            }
            return null;
        }
    }

    private static final class ComponentHighlight
    extends MComponent {
        private final Color color = MColor.HOT_ORANGE.deriveAlpha(128);
        private static ComponentHighlight _instance;
        private WeakReference<Component> currentRef;

        @Override
        protected void paintComponent(Graphics graphics) {
            Component component;
            Component component2 = component = this.currentRef != null ? (Component)this.currentRef.get() : null;
            if (component == null || !component.isShowing() || !component.isVisible()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            JScrollPane jScrollPane = MScrollPane.getScrollPane(component);
            Rectangle rectangle = SwingUtilities.convertRectangle(jScrollPane != null ? jScrollPane.getParent() : component.getParent(), jScrollPane != null ? jScrollPane.getBounds() : component.getBounds(), this);
            graphics2D.setColor(this.color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 10, 10);
        }

        private ComponentHighlight() {
            this.setOpaque(false);
        }

        private static ComponentHighlight getInstance() {
            if (_instance == null) {
                _instance = new ComponentHighlight();
            }
            return _instance;
        }

        private void hideCurrent(boolean bl) {
            Component component;
            Component component2 = component = this.currentRef != null ? (Component)this.currentRef.get() : null;
            if (component != null) {
                if (bl) {
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window instanceof RootPaneContainer) {
                        MFrame.clearGlassPane((RootPaneContainer)((Object)window));
                    }
                } else {
                    this.repaint();
                }
            }
            this.currentRef = null;
        }

        private static boolean isInstance() {
            return _instance != null;
        }

        private void show(Component component) {
            this.hideCurrent(false);
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window instanceof RootPaneContainer) {
                this.currentRef = new WeakReference<Component>(component);
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                if (rootPaneContainer.getGlassPane() != this) {
                    rootPaneContainer.setGlassPane(this);
                    this.setVisible(true);
                } else {
                    this.repaint();
                }
            }
        }

        static /* synthetic */ void access$600(ComponentHighlight componentHighlight, Component component) {
            componentHighlight.show(component);
        }
    }

    public static final class Title
    extends MLabel {
        private GlassPainter painter;

        public Title(String string) {
            this(string, (Icon)null);
        }

        public Title(String string, Icon icon) {
            super(string);
            if (icon != null) {
                this.setIcon(MIcon.getColorizedInstance(icon, MColor.GRAY));
            }
        }

        @Override
        public Color getBackground() {
            Container container = this.getParent();
            Color color = container == null ? null : container.getBackground();
            return color == null ? Color.WHITE : color;
        }

        @Override
        public Color getForeground() {
            Container container = this.getParent();
            Color color = container == null ? null : container.getForeground();
            return color == null ? Color.BLACK : color;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, super.getMaximumSize().height);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.painter == null) {
                this.painter = new GlassPainter(MColor.deriveColor(this.getBackground(), 0.9f));
                this.painter.setRoundType(GlassPainter.RoundType.NONE);
            }
            this.painter.paint(this, (Graphics2D)graphics);
            super.paintComponent(graphics);
        }

        @Override
        public void updateUI() {
            this.painter = null;
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 10));
        }
    }
}

