/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.makagiga.commons.UI;

public class MMouseAdapter
extends MouseAdapter {
    public static boolean isDoubleClick(MouseEvent mouseEvent) {
        return mouseEvent.getClickCount() == 2;
    }

    public static boolean isLeft(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddle(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) != 0;
    }

    public static boolean isRight(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public static boolean isSingleClick(MouseEvent mouseEvent) {
        return mouseEvent.getClickCount() == 1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.doPopupTrigger(mouseEvent, false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopupTrigger(mouseEvent, true);
    }

    public void popupTrigger(MouseEvent mouseEvent) {
    }

    private void doPopupTrigger(MouseEvent mouseEvent, boolean bl) {
        if (((Boolean)UI.mouseGestures.get()).booleanValue() && MMouseAdapter.isRight(mouseEvent) && bl) {
            this.popupTrigger(mouseEvent);
            mouseEvent.consume();
        } else if (!((Boolean)UI.mouseGestures.get()).booleanValue() && mouseEvent.isPopupTrigger()) {
            this.popupTrigger(mouseEvent);
            mouseEvent.consume();
        }
    }

    public static abstract class Drag
    extends MouseMotionAdapter {
        private int sourceActions;

        public Drag(int n) {
            this.sourceActions = n;
        }

        public Drag(JComponent jComponent, int n) {
            this.sourceActions = n;
            jComponent.addMouseMotionListener(this);
        }

        @Override
        public final void mouseDragged(final MouseEvent mouseEvent) {
            if (!MMouseAdapter.isLeft(mouseEvent)) {
                return;
            }
            if (!this.canDrag(mouseEvent)) {
                return;
            }
            TransferHandler transferHandler = new TransferHandler(){

                @Override
                public Transferable createTransferable(JComponent jComponent) {
                    return Drag.this.createTransferable(mouseEvent);
                }

                @Override
                public int getSourceActions(JComponent jComponent) {
                    return Drag.this.sourceActions;
                }
            };
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            jComponent.setTransferHandler(transferHandler);
            transferHandler.exportAsDrag(jComponent, mouseEvent, this.sourceActions);
        }

        protected boolean canDrag(MouseEvent mouseEvent) {
            return true;
        }

        protected abstract Transferable createTransferable(MouseEvent var1);
    }
}

