/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MBorderLayout;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSeparator;
import org.makagiga.commons.Pair;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.painters.AbstractPainter;
import org.makagiga.commons.painters.LinearGradientPainter;
import org.makagiga.commons.painters.Painter;
import org.makagiga.commons.painters.RoundedBackgroundPainter;
import org.makagiga.commons.style.StyleSupport;

public class MPanel
extends JPanel
implements MBorderLayout,
StyleSupport {
    public static final int DEFAULT_CONTENT_MARGIN = 10;
    public static final String MOD_ADD_NOTIFY = "addNotify@org.makagiga.commons.MPanel";
    public static final String MOD_REMOVE_NOTIFY = "removeNotify@org.makagiga.commons.MPanel";
    private int boxLayoutAxis;
    private Painter painter;
    static final String HEADER_FONT_STYLE = "font-size: x-large; font-weight: bold";

    public MPanel() {
        super(new BorderLayout());
    }

    public MPanel(boolean bl) {
        super(null);
        this.setGroupLayout(bl);
    }

    public MPanel(int n) {
        super(null);
        switch (n) {
            case 0: {
                this.setHBoxLayout();
                break;
            }
            case 1: {
                this.setVBoxLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException("\"orientation\" must be \"UI.HORIZONTAL\" or \"UI.VERTICAL\": " + n);
            }
        }
    }

    public MPanel(int n, int n2) {
        this(new BorderLayout(n, n2));
    }

    public MPanel(int n, int n2, int n3, int n4) {
        this(new GridLayout(n, n2, n3, n4));
    }

    public MPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void add(JComponent jComponent) {
        if (jComponent != null) {
            if (this.boxLayoutAxis == 3 && this.getLayout() instanceof BoxLayout) {
                jComponent.setAlignmentX(0.0f);
            }
            super.add(jComponent);
        }
    }

    public void addCenter(JComponent jComponent, int n) {
        this.addCenter(new MScrollPane(jComponent, n));
    }

    public void addContentGap() {
        this.addGap(this.getContentMargin());
    }

    public CoolHeader addCoolHeader(String string) {
        CoolHeader coolHeader = new CoolHeader(string);
        MPanel mPanel = MPanel.createBorderPanel();
        mPanel.addCenter(coolHeader);
        this.add(mPanel);
        return coolHeader;
    }

    public void addGap() {
        this.addGap(5);
    }

    public void addGap(int n) {
        this.add(this.boxLayoutAxis == 2 ? Box.createRigidArea(new Dimension(n, 0)) : Box.createRigidArea(new Dimension(0, n)));
    }

    public MLabel addHeader(String string) {
        MLabel mLabel = this.createHeaderLabel(string);
        this.add(mLabel);
        return mLabel;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Mods.exec(this, MOD_ADD_NOTIFY, new Object[0]);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Mods.exec(this, MOD_REMOVE_NOTIFY, new Object[0]);
    }

    public MLabel addSeparator(String string) {
        MLabel mLabel = this.createHeaderLabel(string);
        MSeparator mSeparator = MSeparator.createHorizontal();
        mSeparator.setCentered(true);
        MPanel mPanel = MPanel.createBorderPanel(5);
        mPanel.addWest(mLabel);
        mPanel.addCenter(mSeparator);
        mPanel.limitHeight();
        this.add(mPanel);
        return mLabel;
    }

    public void addStretch() {
        this.add(this.boxLayoutAxis == 2 ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    public void alignLabels() {
        int n = 0;
        Component[] componentArray = this.getComponents();
        MArrayList<Pair<Wrapper, Dimension>> mArrayList = MArrayList.create(componentArray.length);
        for (Serializable serializable : componentArray) {
            MLabel mLabel;
            Wrapper wrapper;
            if (!(serializable instanceof Wrapper) || (wrapper = (Wrapper)serializable).getOrientation() != 0 || (mLabel = wrapper.getLabel()) == null) continue;
            if (mLabel.isPreferredSizeSet()) {
                mLabel.setPreferredSize(null);
            }
            Dimension dimension = mLabel.getPreferredSize();
            n = Math.max(n, dimension.width);
            Pair<Wrapper, Dimension> pair = new Pair<Wrapper, Dimension>(wrapper, dimension);
            mArrayList.add(pair);
        }
        if (mArrayList.size() < 2) {
            return;
        }
        for (Pair pair : mArrayList) {
            Serializable serializable;
            MLabel mLabel = ((Wrapper)pair.getFirst()).getLabel();
            mLabel.setHorizontalAlignment(11);
            serializable = new Dimension(n, ((Dimension)pair.getSecond()).height);
            mLabel.setPreferredSize((Dimension)serializable);
        }
    }

    public static MPanel createBorderPanel() {
        return new MPanel();
    }

    public static MPanel createBorderPanel(int n) {
        return new MPanel(n, n);
    }

    public static MPanel createCardPanel() {
        return new MPanel(new CardLayout());
    }

    public static MPanel createGridPanel(int n) {
        return new MPanel(n, 1, 0, 0);
    }

    public static MPanel createGridPanel(int n, int n2) {
        return new MPanel(n, n2, 0, 0);
    }

    public static MPanel createGridPanel(int n, int n2, int n3, int n4) {
        return new MPanel(n, n2, n3, n4);
    }

    public static MPanel createGroupPanel(boolean bl) {
        return new MPanel(bl);
    }

    public static MPanel createHBoxPanel() {
        return new MPanel(0);
    }

    public static MPanel createHLabelPanel(JComponent jComponent, String string) {
        return new Wrapper<JComponent>(10, 5, 0, jComponent, string);
    }

    public static MPanel createNoLayoutPanel() {
        return new MPanel(null);
    }

    public static MPanel createPuzzlePanel(String string, JComponent jComponent) {
        MPanel mPanel = MPanel.createHBoxPanel();
        String string2 = "{0}";
        int n = string.indexOf(string2);
        if (n == -1) {
            mPanel.add(MLabel.createFor(jComponent, string));
            mPanel.addGap();
            mPanel.add(jComponent);
            return mPanel;
        }
        String string3 = string.substring(0, n - 1);
        String string4 = string.substring(n + string2.length() + 1);
        mPanel.add(MLabel.createFor(jComponent, string3));
        mPanel.addGap();
        mPanel.add(jComponent);
        mPanel.addGap();
        mPanel.add(new MLabel(string4));
        return mPanel;
    }

    @Deprecated
    public static MPanel createTitledPanel(String string) {
        MPanel mPanel = new MPanel();
        mPanel.setTitle(string);
        return mPanel;
    }

    public static MPanel createVBoxPanel() {
        MPanel mPanel = new MPanel(1);
        mPanel.setAlignmentY(0.0f);
        return mPanel;
    }

    public static MPanel createVLabelPanel(JComponent jComponent, String string) {
        return new Wrapper<JComponent>(1, jComponent, string);
    }

    public int getContentMargin() {
        return 10;
    }

    public MLayout getGroupLayout() {
        return (MLayout)this.getLayout();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        if (TK.isChange(this.painter, painter)) {
            this.painter = painter;
            this.repaint();
        }
    }

    public Window getWindowAncestor() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public static <T extends JComponent> T getWrappedView(JComponent jComponent) {
        if (jComponent instanceof Wrapper) {
            return (T)((Wrapper)Wrapper.class.cast(jComponent)).getView();
        }
        return (T)jComponent;
    }

    @Override
    public boolean isOpaque() {
        if (this.painter instanceof AbstractPainter && ((AbstractPainter)AbstractPainter.class.cast(this.painter)).isOpaque()) {
            return true;
        }
        return super.isOpaque();
    }

    public Dimension limitHeight() {
        return this.limitHeight(this);
    }

    public Dimension limitHeight(Component component) {
        Dimension dimension = new Dimension(Integer.MAX_VALUE, component.getPreferredSize().height);
        this.setMaximumSize(dimension);
        return dimension;
    }

    @Deprecated
    public void merge(JTextField jTextField, AbstractButton ... abstractButtonArray) {
        if (UI.isA03() || UI.isSynth()) {
            return;
        }
        final Border border = jTextField.getBorder();
        Insets insets = border.getBorderInsets(jTextField);
        this.setBorder(new Border(){
            private Insets smallInsets;

            @Override
            public Insets getBorderInsets(Component component) {
                Insets insets = border.getBorderInsets(component);
                if (insets.left > 2 || insets.right > 2 || insets.top > 2 || insets.bottom > 2) {
                    if (this.smallInsets == null) {
                        this.smallInsets = UI.createInsets(1);
                    }
                    return this.smallInsets;
                }
                return insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return border.isBorderOpaque();
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }
        });
        jTextField.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        for (AbstractButton abstractButton : abstractButtonArray) {
            abstractButton.setBackground(jTextField.getBackground());
            abstractButton.setOpaque(true);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.painter != null) {
            this.painter.paint(this, (Graphics2D)graphics);
        } else {
            super.paintComponent(graphics);
        }
    }

    public void setContentMargin() {
        this.setMargin(this.getContentMargin());
    }

    @Deprecated
    public boolean setDropShadow() {
        Border border = UI.createDropShadowBorder();
        if (border == null) {
            return false;
        }
        this.setBorder(border);
        return true;
    }

    public MLayout setGroupLayout(boolean bl) {
        MLayout mLayout = new MLayout(this, bl);
        this.setLayout(mLayout);
        return mLayout;
    }

    public void setHBoxLayout() {
        this.boxLayoutAxis = 2;
        this.setLayout(new BoxLayout(this, this.boxLayoutAxis));
    }

    @Deprecated
    public void setIndentBorder(JComponent jComponent) {
        Border border = BorderFactory.createEmptyBorder(0, this.getContentMargin() * 2, 0, 0);
        Border border2 = jComponent.getBorder();
        if (border2 != null) {
            border = BorderFactory.createCompoundBorder(border, border2);
        }
        jComponent.setBorder(border);
    }

    @Deprecated
    public void setLinearGradientPainter() {
        this.setLinearGradientPainter(0.0f, 0.92f);
    }

    @Deprecated
    public void setLinearGradientPainter(Color color, Color color2) {
        this.setPainter(new LinearGradientPainter(color, color2));
    }

    @Deprecated
    public void setLinearGradientPainter(float f, float f2) {
        this.setPainter(new LinearGradientPainter(f, f2));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
    }

    public String getTitle() {
        Border border = this.getBorder();
        if (border instanceof TitledBorder) {
            return ((TitledBorder)TitledBorder.class.cast(border)).getTitle();
        }
        return null;
    }

    public void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    public void setVBoxLayout() {
        this.boxLayoutAxis = 3;
        this.setLayout(new BoxLayout(this, this.boxLayoutAxis));
    }

    public void showCard(String string) {
        LayoutManager layoutManager = this.getLayout();
        if (!(layoutManager instanceof CardLayout)) {
            throw new IllegalStateException("\"java.awt.CardLayout\" is not set");
        }
        ((CardLayout)CardLayout.class.cast(layoutManager)).show(this, string);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.painter instanceof AbstractPainter) {
            ((AbstractPainter)AbstractPainter.class.cast(this.painter)).invalidate();
        }
    }

    @Override
    public void addCenter(JComponent jComponent) {
        UI.addCenter(this, jComponent);
    }

    @Override
    public void addEast(JComponent jComponent) {
        this.add((Component)jComponent, "After");
    }

    @Override
    public void addNorth(JComponent jComponent) {
        this.add((Component)jComponent, "First");
    }

    @Override
    public void addSouth(JComponent jComponent) {
        this.add((Component)jComponent, "Last");
    }

    @Override
    public void addWest(JComponent jComponent) {
        this.add((Component)jComponent, "Before");
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    private MLabel createHeaderLabel(String string) {
        MLabel mLabel = new MLabel(string);
        int n = this.getComponentCount() == 0 ? 0 : this.getContentMargin() * 2;
        mLabel.setStyle("font-size: x-large; font-weight: bold; margin-top: " + n + "; margin-bottom: 5");
        return mLabel;
    }

    public static class Wrapper<C extends JComponent>
    extends MPanel {
        private final int orientation;
        private State state = State.NORMAL;
        private final WeakReference<C> view;
        private final WeakReference<MLabel> label;

        public Wrapper(int n, C c, String string) {
            this(5, 5, n, c, string);
        }

        public Wrapper(int n, int n2, int n3, C c, String string) {
            this(new BorderLayout(n, n2), n3, c, string);
        }

        public Wrapper(LayoutManager layoutManager, int n, C c, String string) {
            super(layoutManager);
            this.setMargin(0, 2, 0, 2);
            MLabel mLabel = MLabel.createFor(c, string);
            switch (n) {
                case 0: {
                    this.addWest(mLabel);
                    break;
                }
                case 1: {
                    this.addNorth(mLabel);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\"orientation\" must be \"UI.HORIZONTAL\" or \"UI.VERTICAL\": " + n);
                }
            }
            this.addCenter((JComponent)c);
            this.orientation = n;
            this.view = new WeakReference<C>(c);
            this.label = new WeakReference<MLabel>(mLabel);
        }

        public MLabel getLabel() {
            return (MLabel)this.label.get();
        }

        public int getOrientation() {
            return this.orientation;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            TK.checkNull(state);
            if (state != this.state) {
                this.state = state;
                switch (this.state) {
                    case NORMAL: {
                        this.setPainter(null);
                        break;
                    }
                    case ERROR: {
                        this.setPainter(new RoundedBackgroundPainter(MHighlighter.ERROR_COLOR));
                        break;
                    }
                    case FOCUSED: {
                        Color color = UI.getBackground(this);
                        this.setPainter(new RoundedBackgroundPainter(MColor.deriveColor(color, 0.96f)));
                        break;
                    }
                    default: {
                        throw new WTFError(this.state);
                    }
                }
            }
        }

        public C getView() {
            return (C)((JComponent)this.view.get());
        }

        public static enum State {
            NORMAL,
            ERROR,
            FOCUSED;

        }
    }
}

