/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MPasswordField;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.security.MPermission;
import org.makagiga.commons.validator.TextComponentValidator;
import org.makagiga.commons.validator.ValidatorSupport;

public class MPasswordPanel
extends MPanel
implements MDisposable {
    public static final int OLD_PASSWORD_FIELD = 1;
    public static final int NEW_PASSWORD_FIELD = 2;
    public static final int PASSWORD_GENERATOR = 4;
    public static final int ALLOW_EMPTY_PASSWORD = 8;
    @Deprecated
    public static final int SHOW_ALL_FIELDS = 7;
    public static final int ENTER_PASSWORD_FIELD = 16;
    public static final int ENCRYPT_BUTTON = 32;
    public static final int ENTER_PASSWORD_MODE = 16;
    public static final int NEW_PASSWORD_MODE = 7;
    private char oldEchoChar = '\u0000';
    private final Flags flags;
    private final MPasswordField confirmedNewPassword;
    private final MPasswordField newPassword;
    private final MPasswordField oldPassword;
    private PasswordValidator confirmedNewPasswordValidator;
    private PasswordValidator newPasswordValidator;

    public MPasswordPanel(int n, String string) {
        super(true);
        AbstractButton abstractButton;
        this.flags = new Flags(n);
        this.oldPassword = new MPasswordField();
        this.newPassword = new MPasswordField();
        this.confirmedNewPassword = new MPasswordField();
        MLayout mLayout = this.getGroupLayout();
        mLayout.setAutoCreateContainerGaps(true);
        mLayout.beginRows();
        if (string != null) {
            mLayout.addComponent(new MLabel(string));
        }
        if (this.flags.isSet(1L)) {
            if (this.flags.isSet(16L)) {
                throw new IllegalArgumentException("\"ENTER_PASSWORD_FIELD\" flag cannot be used with \"OLD_PASSWORD_FIELD\"");
            }
            mLayout.addComponent((Component)this.oldPassword, UI._("Old Password:"));
        }
        if (this.flags.isSet(2L)) {
            if (this.flags.isSet(16L)) {
                throw new IllegalArgumentException("\"ENTER_PASSWORD_FIELD\" flag cannot be used with \"NEW_PASSWORD_FIELD\"");
            }
            mLayout.addComponent((Component)this.newPassword, UI._("New Password:"));
            mLayout.addComponent((Component)this.confirmedNewPassword, UI._("Confirm New Password:"));
            this.oldEchoChar = this.confirmedNewPassword.getEchoChar();
            abstractButton = new MCheckBox(UI._("Show Password Text"));
            ((MCheckBox)abstractButton).onSelect(this, "passwordTextVisible");
            mLayout.addGap();
            mLayout.addComponent(abstractButton);
        }
        if (this.flags.isSet(4L)) {
            if (this.flags.isSet(16L)) {
                throw new IllegalArgumentException("\"ENTER_PASSWORD_FIELD\" flag cannot be used with \"PASSWORD_GENERATOR\"");
            }
            abstractButton = new MButton(UI._("Generate Random Password..."));
            ((MButton)abstractButton).onClick(this, "generateRandomPassword");
            mLayout.addComponent(abstractButton);
        }
        if (this.flags.isSet(16L)) {
            mLayout.addComponent((Component)this.newPassword, UI._("Password:"));
        }
        mLayout.end();
        this.confirmedNewPassword.setAnotherPasswordField(this.newPassword);
        this.newPassword.setAnotherPasswordField(this.confirmedNewPassword);
    }

    public void generateRandomPassword() {
        RandomPasswordGeneratorDialog randomPasswordGeneratorDialog = new RandomPasswordGeneratorDialog(this.getWindowAncestor(), this.newPassword.getMinimumPasswordLength());
        if (randomPasswordGeneratorDialog.exec(randomPasswordGeneratorDialog.randomPassword)) {
            String string = randomPasswordGeneratorDialog.randomPassword.getText();
            this.newPassword.setText(string);
            this.confirmedNewPassword.setText(string);
        }
    }

    public char[] getConfirmedNewPassword() {
        return this.confirmedNewPassword.getPassword();
    }

    public MPasswordField getConfirmedNewPasswordField() {
        return this.confirmedNewPassword;
    }

    public char[] getNewPassword() {
        return this.newPassword.getPassword();
    }

    public MPasswordField getNewPasswordField() {
        return this.newPassword;
    }

    public char[] getOldPassword() {
        return this.oldPassword.getPassword();
    }

    public MPasswordField getOldPasswordField() {
        return this.oldPassword;
    }

    public Info getPasswordInfo() {
        return new Info(this.getOldPassword(), this.getNewPassword());
    }

    public void installValidators(ValidatorSupport validatorSupport) {
        if (this.confirmedNewPassword != null) {
            this.confirmedNewPasswordValidator = new PasswordValidator(this, this.confirmedNewPassword);
            validatorSupport.add(this.confirmedNewPasswordValidator);
        }
        if (this.newPassword != null) {
            this.newPasswordValidator = new PasswordValidator(this, this.newPassword);
            validatorSupport.add(this.newPasswordValidator);
        }
    }

    public void uninstallValidators(ValidatorSupport validatorSupport) {
        if (this.confirmedNewPasswordValidator != null) {
            validatorSupport.remove(this.confirmedNewPasswordValidator);
            this.confirmedNewPasswordValidator = null;
        }
        if (this.newPasswordValidator != null) {
            validatorSupport.remove(this.newPasswordValidator);
            this.newPasswordValidator = null;
        }
    }

    public boolean isPasswordTextVisible() {
        return this.oldEchoChar != '\u0000' && this.confirmedNewPassword != null && this.confirmedNewPassword.getEchoChar() == '\u0000';
    }

    public void setPasswordTextVisible(boolean bl) {
        if (this.confirmedNewPassword != null && this.newPassword != null) {
            char c = bl ? (char)'\u0000' : this.oldEchoChar;
            this.confirmedNewPassword.setEchoChar(c);
            this.newPassword.setEchoChar(c);
        }
    }

    @Deprecated
    public boolean validateNewPassword(MPasswordField mPasswordField) {
        MPasswordField.Status status = mPasswordField.getPasswordStatus();
        boolean bl = status == MPasswordField.Status.EMPTY && this.flags.isSet(8L) ? true : status == MPasswordField.Status.OK;
        return bl;
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.oldPassword.clear();
        this.newPassword.clear();
        this.confirmedNewPassword.clear();
        return null;
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private static final class RandomPasswordGeneratorDialog
    extends MDialog {
        private ChangeListener passwordLengthChangeListener;
        private final MCheckBox remember;
        private final MNumberSpinner<Integer> passwordLength;
        private final MTextField randomPassword;

        @Override
        protected void onClose() {
            if (this.passwordLengthChangeListener != null) {
                this.passwordLength.removeChangeListener(this.passwordLengthChangeListener);
                this.passwordLengthChangeListener = null;
            }
            super.onClose();
        }

        private RandomPasswordGeneratorDialog(Window window, int n) {
            super(window, UI._("Generate Random Password"), 23);
            this.getOKButton().setEnabled(false);
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Use Random Password"));
            this.changeButton((AbstractButton)this.getURLButton(), "Strong Password Generator (Online)");
            this.getURLButton().setURL("http://strongpasswordgenerator.com/");
            this.passwordLength = new MNumberSpinner();
            this.passwordLength.setRange((Comparable<Integer>)n, (Comparable<Integer>)32);
            this.passwordLength.setNumber(n);
            this.passwordLengthChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MNumberSpinner mNumberSpinner = (MNumberSpinner)changeEvent.getSource();
                    RandomPasswordGeneratorDialog.this.randomPassword.setText(RandomPasswordGeneratorDialog.this.createRandomPassword((Integer)mNumberSpinner.getNumber()));
                    RandomPasswordGeneratorDialog.this.remember.setSelected(false);
                    RandomPasswordGeneratorDialog.this.getOKButton().setEnabled(false);
                }
            };
            this.passwordLength.addChangeListener(this.passwordLengthChangeListener);
            this.randomPassword = new MTextField(this.createRandomPassword(n));
            this.randomPassword.setStyle("font-family: Monospaced; font-size: xx-large");
            this.remember = new MCheckBox(UI._("Remember or copy the above password and click here"));
            this.remember.onSelect(this.getOKButton(), "enabled");
            MPanel mPanel = new MPanel(true);
            mPanel.getGroupLayout().beginRows().addComponent(this.passwordLength, UI._("Password Length:")).addComponent((Component)this.randomPassword, UI._("Random Password:")).addComponent(this.remember).end();
            this.addCenter(mPanel);
            this.packFixed();
        }

        private String createRandomPassword(int n) {
            char[] cArray = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789!@#$%^&*+-=".toCharArray();
            char[] cArray2 = new char[n];
            SecureRandom secureRandom = new SecureRandom();
            for (int i = 0; i < n; ++i) {
                cArray2[i] = cArray[secureRandom.nextInt(cArray.length)];
            }
            return new String(cArray2);
        }
    }

    private static final class PasswordValidator
    extends TextComponentValidator {
        private final WeakReference<MPasswordPanel> panelRef;

        @Override
        protected boolean isValid() throws Exception {
            boolean bl;
            MPasswordPanel mPasswordPanel = (MPasswordPanel)this.panelRef.get();
            if (mPasswordPanel == null) {
                return true;
            }
            MPasswordField mPasswordField = (MPasswordField)this.getComponent();
            MPasswordField.Status status = mPasswordField.getPasswordStatus();
            if (status == MPasswordField.Status.EMPTY && mPasswordPanel.flags.isSet(8L)) {
                bl = true;
            } else {
                boolean bl2 = bl = status == MPasswordField.Status.OK;
            }
            if (!bl) {
                if (status == MPasswordField.Status.TOO_SHORT) {
                    char[] cArray = mPasswordField.getPassword();
                    MPasswordField.clear(cArray);
                    throw new Exception((Object)((Object)status) + " - " + UI._("length: {0}, minimum: {1}", cArray.length, mPasswordField.getMinimumPasswordLength()));
                }
                throw new Exception(status.toString());
            }
            return true;
        }

        private PasswordValidator(MPasswordPanel mPasswordPanel, MPasswordField mPasswordField) {
            super(mPasswordField);
            this.panelRef = TK.newWeakRef(mPasswordPanel);
        }
    }

    public static final class Permission
    extends MPermission {
        private Permission(String string) {
            super(string, PermissionInfo.ThreatLevel.HIGH, "Password Dialog Window");
        }
    }

    public static final class Info {
        private final char[] newPassword;
        private final char[] oldPassword;

        public void clear() {
            MPasswordPanel.checkPermission("setPassword");
            MPasswordField.clear(this.newPassword);
            MPasswordField.clear(this.oldPassword);
        }

        public char[] getNewPassword() {
            MPasswordPanel.checkPermission("getPassword");
            return this.newPassword == null ? null : (char[])this.newPassword.clone();
        }

        public char[] getOldPassword() {
            MPasswordPanel.checkPermission("getPassword");
            return this.oldPassword == null ? null : (char[])this.oldPassword.clone();
        }

        private Info(char[] cArray, char[] cArray2) {
            this.oldPassword = cArray;
            this.newPassword = cArray2;
        }
    }
}

