/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MWindow;
import org.makagiga.commons.SimpleProgressBar;
import org.makagiga.commons.UI;

public final class MSplashScreen {
    private static boolean closed;
    private static Color textColor;
    private static Color textShadowColor;
    private static float alpha;
    private static int textMargin;
    private static int verticalTextPosition;
    private static MLabel windowImage;
    private static MWindow window;
    private static SimpleProgressBar progressBar;
    private static String previousText;

    public static synchronized void close() {
        if (closed) {
            return;
        }
        if (window != null) {
            window.dispose();
            window = null;
        } else {
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                splashScreen.close();
            }
        }
        progressBar = null;
        windowImage = null;
        closed = true;
    }

    public static synchronized SimpleProgressBar getProgressBar() {
        if (progressBar == null) {
            progressBar = new SimpleProgressBar();
            progressBar.setBorderPainted(false);
        }
        return progressBar;
    }

    public static synchronized boolean isAvailable() {
        return !closed && SplashScreen.getSplashScreen() != null;
    }

    public static synchronized void setAlpha(float f) {
        alpha = f;
    }

    public static synchronized void setImage(Image image) {
        if (UI.isEmpty(image)) {
            return;
        }
        if (window == null) {
            window = new MWindow();
            windowImage = new MLabel();
            windowImage.setHorizontalAlignment(0);
            windowImage.setVerticalAlignment(0);
            window.addCenter(windowImage);
        }
        windowImage.setImage(image);
        Rectangle rectangle = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        window.setSize(rectangle.getSize());
        window.setLocationRelativeTo(null);
        UI.setAlpha(window, alpha);
        window.setVisible(true);
        windowImage.paintImmediately(rectangle);
        closed = false;
    }

    public static void setText(String string) {
        MSplashScreen.setText(string, Integer.MIN_VALUE);
    }

    public static synchronized void setText(String string, int n) {
        Graphics graphics = null;
        Rectangle rectangle = null;
        SplashScreen splashScreen = null;
        if (windowImage != null) {
            graphics = windowImage.getGraphics();
            rectangle = windowImage.getBounds();
        } else {
            splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                graphics = splashScreen.createGraphics();
                rectangle = splashScreen.getBounds();
            }
        }
        if (!(graphics instanceof Graphics2D) || rectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (previousText != null && windowImage != null) {
            windowImage.paintImmediately(windowImage.getBounds());
        }
        previousText = string;
        if (string != null) {
            int n2;
            graphics2D.setFont(new Font("Dialog", 0, UI.getDefaultFontSize() - 1));
            UI.setTextAntialiasing(graphics2D, null);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = n2 = verticalTextPosition == 1 ? textMargin + fontMetrics.getAscent() : rectangle.height - fontMetrics.getDescent() - textMargin;
            if (textShadowColor != null) {
                graphics2D.setColor(textShadowColor);
                graphics2D.drawString(string, textMargin - 1, n2 - 1);
                graphics2D.drawString(string, textMargin + 1, n2 + 1);
            }
            graphics2D.setColor(textColor);
            graphics2D.drawString(string, textMargin, n2);
        }
        if (n >= 0 && progressBar != null) {
            int n4 = 2;
            progressBar.setValue(n);
            progressBar.paint(graphics2D, 1, rectangle.height - n4 - 1, rectangle.width - 2, n4);
        }
        graphics2D.dispose();
        if (splashScreen != null) {
            splashScreen.update();
        }
    }

    public static void setTextColor(Color color) {
        textColor = color;
    }

    public static void setTextMargin(int n) {
        textMargin = n;
    }

    public static void setTextShadowColor(Color color) {
        textShadowColor = color;
    }

    public static void setVerticalTextPosition(int n) {
        if (n != 1 && n != 3) {
            throw new IllegalArgumentException("\"value\" must be \"UI.TOP\" or \"UI.BOTTOM\"");
        }
        verticalTextPosition = n;
    }

    private MSplashScreen() {
    }

    static {
        textColor = Color.BLACK;
        textShadowColor = Color.LIGHT_GRAY;
        alpha = 1.0f;
        textMargin = 10;
        verticalTextPosition = 3;
    }
}

