/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MainView;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public abstract class MSwingWorker<T>
implements MDisposable {
    private MSmallButton statusButton;
    private PropertyChangeListener pcl;
    private final Set<Option> options;
    private final String title;
    private volatile transient SwingWorker<T, Void> worker;
    private WeakReference<Object> ownerRef;

    public MSwingWorker(String string) {
        this(null, string);
    }

    public MSwingWorker(Object object, String string) {
        this(object, string, EnumSet.noneOf(Option.class));
    }

    public MSwingWorker(Object object, String string, Set<Option> set) {
        this.ownerRef = new WeakReference<Object>(object);
        this.title = TK.checkNullOrEmpty(string);
        this.options = TK.checkNull(set);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("state".equals(string)) {
                    SwingWorker.StateValue stateValue = (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue());
                    switch (stateValue) {
                        case DONE: {
                            MSwingWorker.this.setCursor(0);
                            MSwingWorker.this.setStatusIconVisible(false);
                            ((SwingWorker)SwingWorker.class.cast(propertyChangeEvent.getSource())).removePropertyChangeListener(this);
                            break;
                        }
                        case STARTED: {
                            MSwingWorker.this.setCursor(3);
                            MSwingWorker.this.setStatusIconVisible(true);
                        }
                    }
                }
            }
        };
    }

    public synchronized void abort() {
        if (this.worker != null) {
            if (!this.worker.cancel(true)) {
                this.worker.removePropertyChangeListener(this.pcl);
            }
            this.worker = null;
        }
    }

    public synchronized void start() {
        this.abort();
        this.worker = new SwingWorker<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return MSwingWorker.this.doInBackground();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                boolean bl = this.isCancelled();
                try {
                    if (bl) {
                        throw new PassiveException(UI._("Cancelled: {0}", MSwingWorker.this.title));
                    }
                    MSwingWorker.this.onSuccess(this.get());
                }
                catch (ExecutionException executionException) {
                    MSwingWorker.this.onError(executionException.getCause(), bl);
                }
                catch (Exception exception) {
                    MSwingWorker.this.onError(exception, bl);
                }
                finally {
                    MSwingWorker.this.onEnd();
                    MSwingWorker.this.worker = null;
                }
            }
        };
        this.worker.addPropertyChangeListener(this.pcl);
        this.worker.execute();
    }

    @Override
    public synchronized Object dispose(Object ... objectArray) {
        this.abort();
        this.pcl = null;
        if (this.ownerRef != null) {
            this.ownerRef.clear();
            this.ownerRef = null;
        }
        this.removeStatusIcon();
        return null;
    }

    protected abstract T doInBackground() throws Exception;

    protected synchronized Object getOwner() {
        return this.ownerRef != null ? this.ownerRef.get() : null;
    }

    protected void onEnd() {
    }

    protected void onError(Throwable throwable, boolean bl) {
        Object object = this.getOwner();
        Window window = object instanceof Component ? UI.windowFor((Component)object) : null;
        MMessage.error(window, throwable);
    }

    protected abstract void onSuccess(T var1);

    private void removeStatusIcon() {
        if (this.statusButton != null) {
            this.statusButton.setVisible(false);
            MainView.getStatusBar().removeButton(this.statusButton);
            this.statusButton = null;
        }
    }

    private void setCursor(int n) {
        if (!this.options.contains((Object)Option.WAIT_CURSOR)) {
            return;
        }
        Object object = this.getOwner();
        if (object instanceof Component) {
            ((Component)Component.class.cast(object)).setCursor(Cursor.getPredefinedCursor(n));
        }
    }

    private void setStatusIconVisible(boolean bl) {
        if (!this.options.contains((Object)Option.STATUS_ICON)) {
            return;
        }
        if (bl) {
            if (this.statusButton == null) {
                this.statusButton = new MSmallButton(new MAction(UI._("Cancel: {0}", this.title), "ui/stop"){

                    @Override
                    public void onAction() {
                        MSwingWorker.this.abort();
                    }
                }, false);
                MainView.getStatusBar().addButton(this.statusButton);
            }
        } else {
            this.removeStatusIcon();
        }
    }

    public static enum Option {
        STATUS_ICON,
        WAIT_CURSOR;

    }
}

