/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLogger;

public class MTimer
extends Timer
implements MDisposable {
    public MTimer(int n) {
        this(Format.MS, n);
    }

    public MTimer(int n, ActionListener actionListener) {
        super(n, actionListener);
    }

    public MTimer(Format format, int n) {
        super(MTimer.calcDelay(format, n), null);
        this.addActionListener(new StaticHandler());
    }

    public MTimer(TimeUnit timeUnit, long l) {
        super((int)timeUnit.toMillis(l), null);
        this.addActionListener(new StaticHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String debug() {
        boolean bl = true;
        Method method = Timer.class.getDeclaredMethod("timerQueue", new Class[0]);
        try {
            Object object;
            String string;
            bl = method.isAccessible();
            if (!bl) {
                method.setAccessible(true);
            }
            String string2 = string = (object = method.invoke((Object)new MTimer(0), new Object[0])) == null ? null : object.toString();
            if (!bl) {
                method.setAccessible(false);
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (!bl) {
                    method.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                return null;
            }
        }
    }

    public void setDelay(Format format, int n) {
        int n2 = MTimer.calcDelay(format, n);
        this.setDelay(n2);
        this.setInitialDelay(n2);
    }

    public void setDelay(TimeUnit timeUnit, long l) {
        int n = (int)timeUnit.toMillis(l);
        this.setDelay(n);
        this.setInitialDelay(n);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.stop();
        for (ActionListener actionListener : this.getActionListeners()) {
            this.removeActionListener(actionListener);
        }
        return null;
    }

    protected boolean onTimeout() {
        return false;
    }

    private static int calcDelay(Format format, int n) {
        switch (format) {
            case MINUTES: {
                return n * 1000 * 60;
            }
            case SECONDS: {
                return n * 1000;
            }
        }
        return n;
    }

    private static final class StaticHandler
    implements ActionListener {
        private StaticHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MTimer mTimer = (MTimer)actionEvent.getSource();
            if (!mTimer.onTimeout()) {
                mTimer.stop();
            }
        }
    }

    public static enum Format {
        MS,
        SECONDS,
        MINUTES;

    }
}

