/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.ConstructorProperties;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.beans.ContainerDelegate;
import org.makagiga.commons.painters.GlassPainter;

public class MTogglePanel
extends MPanel {
    private boolean expanded;
    private Color buttonBackground;
    private Color buttonForeground;
    private JComponent component;
    private JComponent componentPane;
    private String id;
    private ToggleButton button;

    public MTogglePanel() {
        this(null, null, null, null, false);
        if (Beans.isDesignTime()) {
            this.componentPane = new MComponent();
            this.componentPane.setLayout(new BorderLayout());
            this.setComponent(this.componentPane);
        }
    }

    public MTogglePanel(Icon icon) {
        this(null, icon, null, null, false);
    }

    @ConstructorProperties(value={"text"})
    public MTogglePanel(String string) {
        this(string, null, null, null, false);
    }

    public MTogglePanel(String string, Icon icon) {
        this(string, icon, null, null, false);
    }

    @ConstructorProperties(value={"text", "component"})
    public MTogglePanel(String string, JComponent jComponent) {
        this(string, null, jComponent, null, false);
    }

    public MTogglePanel(String string, JComponent jComponent, String string2, boolean bl) {
        this(string, null, jComponent, string2, bl);
    }

    public MTogglePanel(String string, Icon icon, JComponent jComponent, String string2, boolean bl) {
        super(1);
        if (string2 != null) {
            this.id = TK.validateID(string2);
        }
        Color color = UI.getBrighter(this.getForeground(), 50, Color.BLACK);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), UI.createEmptyBorder(5)));
        this.component = jComponent;
        this.button = new ToggleButton(string, icon);
        this.add(this.button);
        if (jComponent != null) {
            this.add(jComponent);
        }
        if (string2 == null) {
            this.setExpanded(bl);
        } else {
            this.setExpanded(this.getConfigPrivileged().read("TogglePanel.expanded." + string2, bl));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ToggleButton getButton() {
        return this.button;
    }

    public Color getButtonBackground() {
        return this.buttonBackground;
    }

    public void setButtonBackground(Color color) {
        if (TK.isChange(this.buttonBackground, color)) {
            this.buttonBackground = color;
            this.button.updateColors(false);
        }
    }

    public Color getButtonForeground() {
        return this.buttonForeground;
    }

    public void setButtonForeground(Color color) {
        if (TK.isChange(this.buttonForeground, color)) {
            this.buttonForeground = color;
            this.button.updateColors(false);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.setVisible(this.expanded);
        }
        UI.replaceComponent(this.componentPane != null && this.componentPane != jComponent ? this.componentPane : this, this.component, jComponent, null, true);
        this.component = jComponent;
    }

    @ContainerDelegate
    public Container getComponentPane() {
        if (this.componentPane == null && this.component == null) {
            this.componentPane = new MComponent();
            this.componentPane.setLayout(new BorderLayout());
            this.setComponent(this.componentPane);
        }
        return this.componentPane;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        return new Dimension(dimension.width, this.getPreferredSize().height);
    }

    public GlassPainter.RoundType getRoundType() {
        return this.button.button.getRoundType();
    }

    public void setRoundType(GlassPainter.RoundType roundType) {
        this.button.button.setRoundType(roundType);
    }

    public String getText() {
        return this.button.button.getText();
    }

    public void setText(String string) {
        this.button.button.setText(string);
    }

    @Override
    public String getToolTipText() {
        return this.button.button.getToolTipText();
    }

    @Override
    public void setToolTipText(String string) {
        this.button.button.setToolTipText(string);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.setExpanded(bl, false);
    }

    public void setExpanded(boolean bl, boolean bl2) {
        this.expanded = bl;
        this.button.setSelected(bl, bl2);
        if (this.id != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Config.getDefault().write("TogglePanel.expanded." + MTogglePanel.this.id, MTogglePanel.this.expanded);
                    return null;
                }
            });
        }
        if (this.component == null) {
            return;
        }
        if (bl) {
            this.component.setMaximumSize(null);
            this.component.setPreferredSize(null);
        } else {
            this.component.setMaximumSize(new Dimension());
            this.component.setPreferredSize(new Dimension());
        }
        this.component.setVisible(bl);
        this.validate();
    }

    protected void fireActionPerformed() {
        TK.fireActionPerformed(this, this.getActionListeners());
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }

    private void toggled(TriBoolean triBoolean) {
        boolean bl = triBoolean.isUndefined() ? !this.button.isSelected() : triBoolean.isTrue();
        this.button.setSelected(bl, true);
        this.setExpanded(bl);
        this.fireActionPerformed();
    }

    public final class ToggleButton
    extends MPanel {
        private boolean selected;
        private CoolHeader button;
        private Icon buttonIcon;

        public ToggleButton(String string) {
            this(string, null);
        }

        public ToggleButton(String string, Icon icon) {
            if (icon == null) {
                this.button = new CoolHeader(string);
                this.button.setDirection(CoolHeader.Direction.TOP);
            } else {
                this.button = new CoolHeader(string, icon);
                this.buttonIcon = icon;
            }
            this.button.setCursor(12);
            this.button.setFocusable(true);
            this.button.setRoundType(GlassPainter.RoundType.NONE);
            this.button.setStyle("font-size: smaller; margin: 1px");
            this.addCenter(this.button);
            this.limitHeight(this.button);
            this.button.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (MTogglePanel.this.isEnabled() && MAction.isTrigger(keyEvent)) {
                        keyEvent.consume();
                        MTogglePanel.this.toggled(TriBoolean.UNDEFINED);
                    }
                }
            });
            this.button.addMouseListener(new MMouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (2.isLeft(mouseEvent)) {
                        mouseEvent.consume();
                        MTogglePanel.this.toggled(TriBoolean.UNDEFINED);
                    }
                }
            });
        }

        public void doClick(boolean bl) {
            MTogglePanel.this.toggled(TriBoolean.from(bl));
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl, boolean bl2) {
            if (this.selected != bl) {
                this.selected = bl;
                this.updateColors(bl2);
                if (this.buttonIcon == null) {
                    this.button.setDirection(this.selected ? CoolHeader.Direction.BOTTOM : CoolHeader.Direction.TOP);
                }
            }
        }

        private void updateColors(boolean bl) {
            if (this.selected) {
                this.button.setColor(MTogglePanel.this.buttonBackground == null ? UI.getColor("TextField.selectionBackground") : MTogglePanel.this.buttonBackground, MTogglePanel.this.buttonForeground == null ? UI.getColor("TextField.selectionForeground") : MTogglePanel.this.buttonForeground, bl);
            } else {
                this.button.setColor(null, null, bl);
            }
        }
    }
}

