/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Map;
import org.makagiga.commons.AbstractProperty;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.DateProperty;
import org.makagiga.commons.DoubleProperty;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.SecureProperty;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;

public class Property<T>
extends AbstractProperty<T> {
    private static final long serialVersionUID = 2380920075570387681L;
    private transient T defaultValue;
    private transient T value;

    public Property() {
        this(null);
    }

    public Property(T t) {
        this.value = t;
        this.defaultValue = t;
    }

    public static <T> Property<T> create() {
        return new Property<T>();
    }

    public static <T> Property<T> create(T t) {
        return new Property<T>(t);
    }

    public boolean equalsValue(T t) {
        if (this.value == t) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(t);
    }

    public SecureProperty<T> getSecure() {
        return new SecureProperty(this);
    }

    public static String getTypeAsString(PropertyAccess<?> propertyAccess) {
        Class<?> clazz = propertyAccess.getType();
        if (clazz != null) {
            return clazz.getSimpleName();
        }
        if (propertyAccess instanceof SecureProperty) {
            propertyAccess = ((SecureProperty)SecureProperty.class.cast(propertyAccess)).getProperty();
        }
        if (propertyAccess instanceof EnumProperty) {
            return "Enum";
        }
        return "?";
    }

    public static boolean isBoolean(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof BooleanProperty || Boolean.class.equals(propertyAccess.getType()) || Boolean.TYPE.equals(propertyAccess.getType());
    }

    public static boolean isColor(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof ColorProperty || Color.class.isAssignableFrom(propertyAccess.getType());
    }

    public static boolean isDate(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof DateProperty || MDate.class.isAssignableFrom(propertyAccess.getType());
    }

    public static boolean isDouble(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof DoubleProperty || Double.class.equals(propertyAccess.getType()) || Double.TYPE.equals(propertyAccess.getType());
    }

    public static boolean isEnum(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof EnumProperty || Enum.class.isAssignableFrom(propertyAccess.getType());
    }

    public static boolean isFloat(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof FloatProperty || Float.class.equals(propertyAccess.getType()) || Float.TYPE.equals(propertyAccess.getType());
    }

    public static boolean isFont(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof FontProperty || Font.class.isAssignableFrom(propertyAccess.getType());
    }

    public static boolean isInteger(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof IntegerProperty || Integer.class.equals(propertyAccess.getType()) || Integer.TYPE.equals(propertyAccess.getType());
    }

    public static boolean isString(PropertyAccess<?> propertyAccess) {
        return propertyAccess instanceof StringProperty || String.class.equals(propertyAccess.getType());
    }

    public static Map<Field, PropertyAccess<?>> listStatic(Class<?> clazz) throws IllegalAccessException {
        return Property.list(clazz, null);
    }

    public static Map<Field, PropertyAccess<?>> list(Object object) throws IllegalAccessException {
        return Property.list(object.getClass(), object);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return super.getPropertyChangeListeners();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    @Deprecated
    public void clear() {
        super.clear();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public int compareTo(PropertyAccess<T> propertyAccess) {
        return super.compareTo(propertyAccess);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyAccess)) {
            return false;
        }
        PropertyAccess propertyAccess = (PropertyAccess)object;
        return this.equalsValue(propertyAccess.get());
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T t) {
        T t2 = this.value;
        this.value = t;
        if (this.propertyChangeSupport != null && TK.isChange(t2, this.value)) {
            this.propertyChangeSupport.firePropertyChange("value", t2, this.value);
        }
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue() {
        return this.equalsValue(this.defaultValue);
    }

    @Override
    public void setDefaultValue(T t) {
        T t2 = this.defaultValue;
        this.defaultValue = t;
        if (this.propertyChangeSupport != null && TK.isChange(t2, this.defaultValue)) {
            this.propertyChangeSupport.firePropertyChange("defaultValue", t2, this.defaultValue);
        }
    }

    @Override
    public Class<T> getType() {
        return null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isNull() {
        return super.isNull();
    }

    @Override
    public void parse(String string) throws ParseException {
        super.parse(string);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private static Map<Field, PropertyAccess<?>> list(Class<?> clazz, Object object) throws IllegalAccessException {
        Map<Field, PropertyAccess<?>> map = TK.newLinkedHashMap();
        for (Field field : clazz.getFields()) {
            Object object2;
            if (!Modifier.isFinal(field.getModifiers())) {
                MLogger.warning("core", "\"%s\" property in class \"%s\" should be declared as \"final\"", field.getName(), clazz.getName());
            }
            if (!Modifier.isPublic(field.getModifiers()) || !((object2 = field.get(object)) instanceof PropertyAccess)) continue;
            map.put(field, (PropertyAccess)object2);
        }
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = TK.deserialize(objectInputStream, "defaultValue");
        if (object != null) {
            this.defaultValue = object;
        }
        if ((object = TK.deserialize(objectInputStream, "value")) != null) {
            this.value = object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        TK.serialize(objectOutputStream, "defaultValue", this.defaultValue);
        TK.serialize(objectOutputStream, "value", this.value);
    }

    public static abstract class ValueChangeListener<T>
    implements PropertyChangeListener {
        private transient PropertyAccess<T> source;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                try {
                    this.source = (PropertyAccess)propertyChangeEvent.getSource();
                    this.onChange(propertyChangeEvent.getNewValue());
                }
                finally {
                    this.source = null;
                }
            }
        }

        protected PropertyAccess<T> getSource() {
            return this.source;
        }

        protected abstract void onChange(T var1);
    }
}

