/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.autocompletion;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.FS;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MText;
import org.makagiga.commons.MWindow;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.autocompletion.AutoCompletionData;
import org.makagiga.commons.validator.ListSelectionValidator;

public final class AutoCompletion {
    public final BooleanProperty caseSensitive = new BooleanProperty();
    public final BooleanProperty consumeEnter = new BooleanProperty(true);
    public final BooleanProperty enabled = new BooleanProperty(true);
    public final IntegerProperty limit = new IntegerProperty(100);
    public static final String TEXT_COMPONENT_IN_UPDATE_PROPERTY = "org.makagiga.commons.autocompletion.AutoCompletion.TEXT_COMPONENT_IN_UPDATE_PROPERTY";
    private AutoCompletionData data;
    private boolean showPopupOnUpDownKeyPress = true;
    private static CompletionWindow window;
    private Mode mode = Mode.ALL_TEXT;
    private Renderer userRenderer;
    private final String id;
    private final WeakReference<JTextComponent> textComponentRef;

    public AutoCompletion(JTextComponent jTextComponent, String string) {
        this.textComponentRef = TK.newWeakRef(jTextComponent);
        this.id = TK.validateID(string);
        this.install();
    }

    public void addItem(String string) {
        this.init();
        int n = this.data.indexOf(string);
        if (n == -1) {
            this.data.add(string);
        } else {
            ++this.data.getList().get((int)n).usage;
        }
    }

    public void clear() {
        if (this.data != null && this.data.getList() != null) {
            this.data.getList().clear();
            this.save();
        }
    }

    public static void deletePrivateData() {
        FS.deleteFiles(FS.makeConfigFile("autocompletion"), null);
        for (Frame frame : Frame.getFrames()) {
            for (JTextComponent jTextComponent : ContainerIterator.findAll(frame, JTextComponent.class)) {
                AutoCompletion autoCompletion = MText.getAutoCompletion(jTextComponent);
                if (autoCompletion == null) continue;
                autoCompletion.clear();
            }
        }
    }

    public static JTextComponent getCurrentTextComponent() {
        if (window == null) {
            return null;
        }
        return AutoCompletion.window.getTextComponent();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Renderer getRenderer() {
        return this.userRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.userRenderer = renderer;
    }

    public static void hidePopupWindow() {
        if (window != null) {
            AutoCompletion.window.destroy();
            window = null;
        }
    }

    public boolean getShowPopupOnUpDownKeyPress() {
        return this.showPopupOnUpDownKeyPress;
    }

    public void setShowPopupOnUpDownKeyPress(boolean bl) {
        this.showPopupOnUpDownKeyPress = bl;
    }

    public void save() {
        if (this.data != null) {
            this.data.save();
        }
    }

    private void cancel() {
        if (window != null && window.originalText != null) {
            this.updateText(window.originalText);
        }
        AutoCompletion.hidePopupWindow();
    }

    private void complete(boolean bl) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
        if (jTextComponent == null) {
            return;
        }
        if (window != null) {
            window.originalText = jTextComponent.getText();
        }
        String string = null;
        switch (this.mode) {
            case ALL_TEXT: {
                string = jTextComponent.getText();
                break;
            }
            case CURRENT_WORD: {
                try {
                    int n = Utilities.getWordStart(jTextComponent, jTextComponent.getCaretPosition());
                    int n2 = Utilities.getWordEnd(jTextComponent, n);
                    string = jTextComponent.getText(n, n2 - n);
                }
                catch (BadLocationException badLocationException) {
                    string = jTextComponent.getText();
                }
                break;
            }
            case ANY_TEXT: {
                string = jTextComponent.getText();
                break;
            }
            default: {
                throw new WTFError(this.mode);
            }
        }
        if (string == null) {
            return;
        }
        if (string.isEmpty() && !bl) {
            return;
        }
        if (!((Boolean)this.caseSensitive.get()).booleanValue()) {
            string = string.toUpperCase();
        }
        this.init();
        if (this.data.getList() == null) {
            return;
        }
        TreeSet<AutoCompletionData.Item> treeSet = new TreeSet<AutoCompletionData.Item>();
        treeSet.addAll(this.data.getList());
        MArrayList<AutoCompletionData.Item> mArrayList = MArrayList.create(treeSet.size());
        for (AutoCompletionData.Item item : treeSet) {
            if (!bl && !item.matches(string, (Boolean)this.caseSensitive.get(), this.mode)) continue;
            mArrayList.add(item);
        }
        if (mArrayList.isEmpty()) {
            AutoCompletion.hidePopupWindow();
        } else {
            if (window == null) {
                window = new CompletionWindow();
            }
            AutoCompletion.window.init(this, jTextComponent);
            AutoCompletion.window.show(mArrayList);
        }
    }

    private void init() {
        if (this.data == null) {
            this.data = AutoCompletionData.load(this.id);
            if (this.data == null) {
                this.data = new AutoCompletionData(this.id);
            }
            this.data.max = (Integer)this.limit.get();
        }
    }

    private void install() {
        JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
        if (jTextComponent == null) {
            return;
        }
        jTextComponent.getDocument().addDocumentListener(new MDocumentAdapter<JTextComponent>(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                if (documentEvent.getType() == DocumentEvent.EventType.INSERT || documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                    AutoCompletion.this.complete(false);
                }
            }
        });
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (AutoCompletion.this.showPopupOnUpDownKeyPress && window == null) {
                    switch (keyEvent.getKeyCode()) {
                        case 38: 
                        case 40: {
                            AutoCompletion.this.complete(true);
                        }
                    }
                }
                if (window == null) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        AutoCompletionData.Item item = (AutoCompletionData.Item)window.list.getSelectedItem();
                        AutoCompletion.this.setText(item);
                        if (item != null && ((Boolean)AutoCompletion.this.consumeEnter.get()).booleanValue()) {
                            keyEvent.consume();
                        }
                        AutoCompletion.hidePopupWindow();
                        break;
                    }
                    case 27: {
                        AutoCompletion.this.cancel();
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        if (!window.list.isEmpty() && window.list.getSelectedIndex() == 0) {
                            window.list.setSelectedIndex(window.list.getItemCount() - 1, true);
                        } else {
                            window.list.selectRelativeIndex(-1, true);
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        if (!window.list.isEmpty() && window.list.getSelectedIndex() == window.list.getItemCount() - 1) {
                            window.list.setSelectedIndex(0, true);
                        } else {
                            window.list.selectRelativeIndex(1, true);
                        }
                        keyEvent.consume();
                    }
                }
            }
        });
        jTextComponent.addMouseListener(new MMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (window != null) {
                    AutoCompletion.hidePopupWindow();
                    mouseEvent.consume();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setText(AutoCompletionData.Item item) {
        if (item == null) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
        if (jTextComponent == null) {
            return;
        }
        String string = item.text;
        try {
            this.enabled.no();
            switch (this.mode) {
                case ALL_TEXT: {
                    this.updateText(string);
                    return;
                }
                case CURRENT_WORD: {
                    try {
                        int n = jTextComponent.getCaretPosition();
                        int n2 = Utilities.getWordStart(jTextComponent, n);
                        int n3 = Utilities.getWordEnd(jTextComponent, n2);
                        String string2 = jTextComponent.getText(n2, n3 - n2);
                        String string3 = string.substring(string2.length());
                        jTextComponent.getDocument().insertString(n, string3, null);
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        this.updateText(string);
                        return;
                    }
                }
                case ANY_TEXT: {
                    this.updateText(string);
                    return;
                }
                default: {
                    throw new WTFError(this.mode);
                }
            }
        }
        finally {
            this.enabled.yes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(String string) {
        JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
        if (jTextComponent == null) {
            return;
        }
        try {
            jTextComponent.getDocument().putProperty(TEXT_COMPONENT_IN_UPDATE_PROPERTY, true);
            jTextComponent.setText(string);
        }
        finally {
            jTextComponent.getDocument().putProperty(TEXT_COMPONENT_IN_UPDATE_PROPERTY, null);
        }
    }

    private static final class HistoryDialog
    extends MDialog {
        private final AutoCompletion autoCompletion;
        private final CompletionList list = new CompletionList(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.TRIGGER) {
                    HistoryDialog historyDialog = (HistoryDialog)UI.windowFor(this);
                    historyDialog.accept();
                }
            }
        };
        private final MSearchPanel filter = new MSearchPanel(false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                HistoryDialog historyDialog = (HistoryDialog)UI.windowFor(this);
                historyDialog.list.filter(this, historyDialog.autoCompletion.data.getList(), new MList.Filter<AutoCompletionData.Item, String>(this.getText()){

                    @Override
                    public boolean include(AutoCompletionData.Item item) {
                        return TK.containsIgnoreCase(item.text, (String)this.filter);
                    }
                });
            }
        };

        @Override
        protected void onUserClick() {
            this.autoCompletion.clear();
            this.list.clear();
        }

        private HistoryDialog(Window window, JTextComponent jTextComponent) {
            super(window, UI._("History"), 15);
            this.autoCompletion = MText.getAutoCompletion(jTextComponent);
            this.autoCompletion.init();
            if (!TK.isEmpty(this.autoCompletion.data.getList())) {
                this.list.addAllItems(this.autoCompletion.data.getList());
                this.list.sort();
                this.list.setSelectedIndex(0);
            }
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Insert Selected Item"));
            if (this.list.isEmpty()) {
                this.getUserButton().setEnabled(false);
            }
            this.changeButton((AbstractButton)this.getUserButton(), MActionInfo.CLEAR_HISTORY);
            this.getValidatorSupport().add(new ListSelectionValidator(this.list));
            this.addNorth(this.filter);
            this.addCenter(MPanel.createVLabelPanel(this.list, UI._("Items:")));
            this.packFixed(UI.WindowSize.MEDIUM);
        }
    }

    private static final class CompletionWindow {
        private final AWTEventListener awtListener;
        private boolean visible;
        private final CompletionList list = new CompletionList(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.TRIGGER) {
                    AutoCompletion autoCompletion = CompletionWindow.this.getAutoCompletion();
                    if (autoCompletion.mode == Mode.CURRENT_WORD) {
                        autoCompletion.setText((AutoCompletionData.Item)this.getSelectedItem());
                    }
                    AutoCompletion.hidePopupWindow();
                }
            }

            @Override
            protected void onSelect() {
                AutoCompletion autoCompletion = CompletionWindow.this.getAutoCompletion();
                if (autoCompletion.mode != Mode.CURRENT_WORD) {
                    autoCompletion.setText((AutoCompletionData.Item)this.getSelectedItem());
                }
            }
        };
        private Popup popup;
        private String originalText;
        private WeakReference<AutoCompletion> autoCompletionRef;
        private WeakReference<JTextComponent> textComponentRef;

        private CompletionWindow() {
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        CompletionWindow.this.getAutoCompletion().cancel();
                        JTextComponent jTextComponent = CompletionWindow.this.getTextComponent();
                        if (jTextComponent != null) {
                            jTextComponent.requestFocusInWindow();
                        }
                    }
                }
            });
            this.awtListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    ComponentEvent componentEvent;
                    Component component;
                    if (aWTEvent instanceof FocusEvent) {
                        FocusEvent focusEvent = (FocusEvent)aWTEvent;
                        if (focusEvent.getID() == 1004 && focusEvent.getComponent() != CompletionWindow.this.list) {
                            AutoCompletion.hidePopupWindow();
                        }
                    } else if (aWTEvent instanceof ComponentEvent && ((component = (componentEvent = (ComponentEvent)aWTEvent).getComponent()) instanceof MDialog || component instanceof MFrame || component instanceof MWindow) && (componentEvent.getID() == 103 || componentEvent.getID() == 100)) {
                        AutoCompletion.hidePopupWindow();
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 5L);
        }

        private void destroy() {
            this.originalText = null;
            if (this.popup != null) {
                this.popup.hide();
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }

        private AutoCompletion getAutoCompletion() {
            return (AutoCompletion)this.autoCompletionRef.get();
        }

        private JTextComponent getTextComponent() {
            return (JTextComponent)this.textComponentRef.get();
        }

        private void init(AutoCompletion autoCompletion, JTextComponent jTextComponent) {
            this.autoCompletionRef = new WeakReference<AutoCompletion>(autoCompletion);
            this.textComponentRef = new WeakReference<JTextComponent>(jTextComponent);
            this.list.userRendererRef = TK.newWeakRef(autoCompletion.userRenderer);
        }

        private void show(List<AutoCompletionData.Item> list) {
            this.list.clear();
            this.list.addAllItems(list);
            if (!this.visible) {
                Serializable serializable;
                JTextComponent jTextComponent = this.getTextComponent();
                this.originalText = jTextComponent.getText();
                Point point = SwingUtilities.convertPoint(jTextComponent, this.list.getLocation(), this.list);
                point.setLocation(point.x, point.y + jTextComponent.getHeight());
                MScrollPane mScrollPane = new MScrollPane(this.list, 2);
                if (!UI.isGTK()) {
                    serializable = MColor.getContrast(UI.getBackground(this.list));
                    mScrollPane.setBorder(BorderFactory.createLineBorder(serializable, 1));
                }
                serializable = new Dimension(Math.max(jTextComponent.getWidth(), 200), this.list.getFixedCellHeight() * Math.min(10, Math.max(this.list.getItemCount(), 5)) + 4);
                if (point.y + ((Dimension)serializable).height > UI.getScreenSize().height) {
                    point.y -= ((Dimension)serializable).height + jTextComponent.getHeight();
                }
                UI.setFixedSize(mScrollPane, ((Dimension)serializable).width, ((Dimension)serializable).height);
                this.popup = PopupFactory.getSharedInstance().getPopup(jTextComponent, mScrollPane, point.x, point.y);
                this.popup.show();
                this.visible = true;
            }
        }
    }

    private static class CompletionList
    extends MList<AutoCompletionData.Item> {
        private WeakReference<Renderer> userRendererRef;

        private CompletionList() {
            MRenderer<AutoCompletionData.Item> mRenderer = new MRenderer<AutoCompletionData.Item>(){

                @Override
                protected void onRender(AutoCompletionData.Item item) {
                    Renderer renderer;
                    this.setText(item.toString());
                    Renderer renderer2 = renderer = CompletionList.this.userRendererRef == null ? null : (Renderer)CompletionList.this.userRendererRef.get();
                    if (renderer != null) {
                        renderer.onRender(this, item);
                    }
                }
            };
            mRenderer.setHTMLEnabled(false);
            this.setCellRenderer(mRenderer, new AutoCompletionData.Item("X"));
            this.setSingleSelectionMode();
            this.setText(UI._("No Items"));
        }
    }

    public static interface Renderer {
        public void onRender(MRenderer<AutoCompletionData.Item> var1, AutoCompletionData.Item var2);
    }

    public static final class HistoryAction
    extends MDataAction.Weak<JTextComponent> {
        public HistoryAction(JTextComponent jTextComponent) {
            super(jTextComponent, UI._("History..."));
        }

        @Override
        public void onAction() {
            AutoCompletionData.Item item;
            JTextComponent jTextComponent = (JTextComponent)this.get();
            HistoryDialog historyDialog = new HistoryDialog(this.getSourceWindow(), jTextComponent);
            if (historyDialog.exec(historyDialog.filter) && (item = (AutoCompletionData.Item)historyDialog.list.getSelectedItem()) != null) {
                jTextComponent.setText(item.text);
            }
        }
    }

    public static enum Mode {
        ALL_TEXT,
        CURRENT_WORD,
        ANY_TEXT;

    }
}

