/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.category;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIconButton;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.validator.TextComponentValidator;

public class CategoryManager
implements Iterable<Category> {
    private boolean editable;
    private final CategoryList set = new CategoryList();
    private final EventListenerList eventListenerList = new EventListenerList();
    private File file;
    private final Map<String, Category> map = TK.newHashMap();

    public void addCategory(Category category) {
        this.set.add(category);
        this.map.put(category.getName(), category);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventListenerList.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.eventListenerList.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.eventListenerList.remove(ChangeListener.class, changeListener);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void removeAll() {
        this.set.clear();
        this.map.clear();
    }

    public Category getCategory(String string) {
        return this.map.get(string);
    }

    public Set<Category> getCategorySet() {
        return Collections.unmodifiableSet(this.set);
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    public static CategoryManager getSharedInstance() {
        return LazyCategoryManagerHolder.INSTANCE;
    }

    public boolean read(File file) {
        this.file = TK.checkNull(file, "file");
        Config config = new Config(file.getPath());
        this.load(config);
        return !config.isError();
    }

    public boolean showDialog(Window window) {
        CategoryManagerDialog categoryManagerDialog;
        File file = new File(FS.getUserDir(), ".evolution/categories.xml");
        int n = 7;
        if (file.exists()) {
            n |= 8;
        }
        if ((categoryManagerDialog = new CategoryManagerDialog(window, n, this.set, file)).exec(categoryManagerDialog.categoryList)) {
            this.removeAll();
            for (Category category : categoryManagerDialog.categoryList) {
                this.addCategory(category);
            }
            this.sync();
            this.fireStateChanged();
            return true;
        }
        return false;
    }

    public boolean sync() {
        Config config = new Config(this.file.getPath());
        this.store(config);
        return config.sync();
    }

    @Override
    public Iterator<Category> iterator() {
        return TK.unmodifiableIterator(this.set.iterator());
    }

    protected CategoryManager() {
    }

    protected void fireStateChanged() {
        TK.fireStateChanged(this, this.getChangeListeners());
    }

    private CategoryManager(File file) {
        this.setEditable(true);
        this.read(file);
    }

    private static void importFromEvolution(Window window, File file, MList<Category> mList) {
        try {
            EvolutionCategories evolutionCategories = XMLHelper.unmarshal(EvolutionCategories.class, file);
            XMLHelper.clearContextCache(EvolutionCategories.class);
            if (!TK.isEmpty(evolutionCategories.list)) {
                if (!MMessage.simpleConfirm(window, MActionInfo.IMPORT, evolutionCategories.list.toArray())) {
                    return;
                }
                for (EvolutionCategory evolutionCategory : evolutionCategories.list) {
                    if (TK.isEmpty(evolutionCategory.name) || !evolutionCategory.searchable) continue;
                    if (!TK.isEmpty(evolutionCategory.icon)) {
                        URL uRL = FS.toURL(evolutionCategory.icon);
                        evolutionCategory.icon = uRL == null ? null : uRL.toString();
                    }
                    evolutionCategory.name = evolutionCategory.name.replace(',', '_');
                    mList.addItem(new Category(evolutionCategory.name, null, evolutionCategory.icon));
                }
            }
        }
        catch (Exception exception) {
            MMessage.error(window, exception);
        }
    }

    private void load(Config config) {
        this.removeAll();
        int n = config.readInt("Category.count", 0, 0);
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String string = config.read("Category.name." + i, null);
            if (TK.isEmpty(string)) continue;
            this.addCategory(new Category(string, config.readColor("Category.color." + i, null), config.read("Category.icon." + i, null)));
        }
    }

    private void store(Config config) {
        config.removeAll();
        config.write("Category.count", this.set.size());
        int n = 0;
        for (Category category : this) {
            config.write("Category.color." + n, category.getColor());
            config.write("Category.icon." + n, category.getIconName());
            config.write("Category.name." + n, category.getName());
            ++n;
        }
    }

    private static final class LazyCategoryManagerHolder {
        private static final CategoryManager INSTANCE = new CategoryManager(FS.makeConfigFile("categories.properties"));

        private LazyCategoryManagerHolder() {
        }
    }

    private static final class EvolutionCategory {
        @XmlAttribute(name="searchable")
        private boolean searchable;
        @XmlAttribute(name="icon")
        private String icon;
        @XmlAttribute(name="a")
        private String name;

        private EvolutionCategory() {
        }

        public String toString() {
            return this.name;
        }
    }

    @XmlRootElement(name="categories")
    private static final class EvolutionCategories {
        @XmlElement(name="category")
        private List<EvolutionCategory> list;

        private EvolutionCategories() {
        }
    }

    private static final class CategoryPropertiesPanel
    extends MPanel {
        private MIconButton iconField;
        private MSmallColorChooser colorField;
        private MTextField nameField;

        private CategoryPropertiesPanel(Category category) {
            super(false);
            if (category == null) {
                this.iconField = new MIconButton(null);
                this.nameField = new MTextField();
                this.colorField = new MSmallColorChooser();
                this.colorField.setColor(null);
            } else {
                this.iconField = new MIconButton(category.getIconName());
                this.nameField = new MTextField(category.getName());
                this.colorField = new MSmallColorChooser();
                this.colorField.getClearButton().setVisible(true);
                this.colorField.setColor(category.getColor());
            }
            this.iconField.setIconChooserFlags(2);
            this.nameField.setAutoCompletion("categoryname");
            this.getGroupLayout().setAutoCreateContainerGaps(true);
            this.getGroupLayout().addComponent(this.iconField).addGap(this.getContentMargin() * 2).beginRows().addComponent((Component)this.nameField, UI._("Category Name:")).addGap(this.getContentMargin() * 2).addComponent(this.colorField).end();
        }

        private Category showDialog(Window window) {
            MDialog mDialog = new MDialog(window, UI._("Properties"), MActionInfo.PROPERTIES.getIconName());
            mDialog.getValidatorSupport().add(new TextComponentValidator(this.nameField){

                @Override
                protected boolean isValid() throws Exception {
                    Category.validateName(this.getText());
                    return true;
                }
            });
            mDialog.addCenter(this);
            mDialog.installValidatorMessage();
            mDialog.packFixed(UI.WindowSize.MEDIUM);
            if (mDialog.exec(this.nameField)) {
                this.nameField.saveAutoCompletion();
                return new Category(this.nameField.getText(), this.colorField.getColor(), this.iconField.getIconName());
            }
            return null;
        }
    }

    private static final class CategoryManagerDialog
    extends MDialog {
        private ActionGroup actionGroup;
        private ActionListener actionListener;
        private final File evolutionCategories;
        private ListSelectionListener listSelectionListener;
        private final MList<Category> categoryList;

        @Override
        protected void onClose() {
            super.onClose();
            this.actionGroup.clear();
            this.actionGroup = null;
            this.categoryList.removeActionListener(this.actionListener);
            this.actionListener = null;
            this.categoryList.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }

        @Override
        protected void onUserClick() {
            CategoryManager.importFromEvolution(this, this.evolutionCategories, this.categoryList);
        }

        private CategoryManagerDialog(Window window, int n, CategoryList categoryList, File file) {
            super(window, UI._("Edit Categories"), n);
            this.evolutionCategories = file;
            if (this.getUserButton() != null) {
                this.changeButton((AbstractButton)this.getUserButton(), UI._("Import from {0}", "Evolution"));
            }
            this.categoryList = new MList();
            Category category = new Category("FAKE", null, "ui/misc");
            this.categoryList.setCellRenderer(new MRenderer(2), category);
            this.listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    CategoryManagerDialog.this.actionGroup.update();
                }
            };
            this.categoryList.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            this.categoryList.setSingleSelectionMode();
            this.categoryList.setText(UI._("No Items"));
            this.categoryList.addAllItems(categoryList);
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CategoryManagerDialog.this.categoryList.getActionType() == MList.ActionType.TRIGGER) {
                        CategoryManagerDialog.this.actionGroup.fire("properties", CategoryManagerDialog.this.categoryList);
                    }
                }
            };
            this.categoryList.addActionListener(this.actionListener);
            this.addCenter(MPanel.createVLabelPanel(this.categoryList, UI._("Categories:")));
            this.actionGroup = new ActionGroup(){

                @Override
                public void update() {
                    boolean bl = !CategoryManagerDialog.this.categoryList.isSelectionEmpty();
                    this.getAction("delete").setEnabled(bl);
                    this.getAction("properties").setEnabled(bl);
                }
            };
            this.actionGroup.add("new", new MAction(MActionInfo.NEW){

                @Override
                public void onAction() {
                    CategoryPropertiesPanel categoryPropertiesPanel = new CategoryPropertiesPanel(null);
                    Category category = categoryPropertiesPanel.showDialog(this.getSourceWindow());
                    if (category != null) {
                        CategoryManagerDialog.this.categoryList.addItem(category);
                        CategoryManagerDialog.this.categoryList.setSelectedItem(category, true);
                        CategoryManagerDialog.this.actionGroup.update();
                    }
                }
            });
            this.actionGroup.addSeparator();
            this.actionGroup.add("delete", new MAction(MActionInfo.DELETE){

                @Override
                public void onAction() {
                    Category category = (Category)CategoryManagerDialog.this.categoryList.getSelectedItem();
                    if (category != null) {
                        CategoryManagerDialog.this.categoryList.removeItem(category);
                    }
                    CategoryManagerDialog.this.actionGroup.update();
                }
            });
            this.actionGroup.addSeparator();
            this.actionGroup.add("properties", new MAction(MActionInfo.PROPERTIES){

                @Override
                public void onAction() {
                    CategoryPropertiesPanel categoryPropertiesPanel;
                    Category category;
                    Category category2 = (Category)CategoryManagerDialog.this.categoryList.getSelectedItem();
                    if (category2 != null && (category = (categoryPropertiesPanel = new CategoryPropertiesPanel(category2)).showDialog(this.getSourceWindow())) != null && !category.equals(category2)) {
                        CategoryManagerDialog.this.categoryList.removeItem(category2);
                        CategoryManagerDialog.this.categoryList.addItem(category, 0);
                        CategoryManagerDialog.this.categoryList.setSelectedItem(category, true);
                    }
                    CategoryManagerDialog.this.actionGroup.update();
                }
            });
            this.actionGroup.installPopupMenu(this.categoryList);
            this.actionGroup.update();
            MToolBar mToolBar = new MToolBar();
            this.actionGroup.updateToolBar(mToolBar);
            mToolBar.readConfig("category-manager");
            this.setToolBar(mToolBar);
            this.packFixed(UI.WindowSize.MEDIUM);
        }
    }
}

