/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.fx;

import com.jhlabs.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.UI;

public class Reflection {
    private boolean blur;
    private float gradientAlpha = 0.8f;
    private float reflectionSize = 0.8f;
    private int gap = 0;

    public MIcon createIcon(ImageIcon imageIcon) {
        return new MIcon(this.createImage(imageIcon.getImage()));
    }

    public BufferedImage createImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = this.createGradientMask(n, (int)((float)n2 * this.reflectionSize));
        BufferedImage bufferedImage2 = this.createReflection(image, n, n2);
        this.applyAlphaMask(bufferedImage, bufferedImage2, n, n2);
        return bufferedImage2;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public float getGradientAlpha() {
        return this.gradientAlpha;
    }

    public void setGradientAlpha(float f) {
        this.gradientAlpha = f;
    }

    public float getReflectionSize() {
        return this.reflectionSize;
    }

    public void setReflectionSize(float f) {
        if (f < 0.1f || f > 1.0f) {
            throw new IllegalArgumentException("\"value\" must be in range 0.1..1.0f");
        }
        this.reflectionSize = f;
    }

    public boolean isBlur() {
        return this.blur;
    }

    public void setBlur(boolean bl) {
        this.blur = bl;
    }

    private void applyAlphaMask(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.DstOut);
        graphics2D.drawImage(bufferedImage, null, 0, n2 + this.gap);
        graphics2D.dispose();
    }

    private BufferedImage createGradientMask(int n, int n2) {
        BufferedImage bufferedImage = UI.createCompatibleImage(n, n2, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, this.gradientAlpha), 0.0f, (float)n2 / 1.2f, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
        graphics2D.dispose();
        bufferedImage.flush();
        return bufferedImage;
    }

    private BufferedImage createReflection(Image image, int n, int n2) {
        int n3 = n2 + (int)((float)n2 * this.reflectionSize) + this.gap;
        BufferedImage bufferedImage = UI.createCompatibleImage(n, n3, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        graphics2D.translate(0, n2 * 2 + this.gap);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        if (this.blur) {
            BufferedImage bufferedImage2 = UI.createCompatibleImage(image.getWidth(null), image.getHeight(null), true);
            Graphics2D graphics2D2 = bufferedImage2.createGraphics();
            graphics2D2.drawImage(image, 0, 0, null);
            graphics2D2.dispose();
            new GaussianFilter(5.0f).filter(bufferedImage2, bufferedImage2);
            graphics2D.drawImage(bufferedImage2, affineTransform, null);
        } else {
            graphics2D.drawImage(image, affineTransform, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

