/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.makagiga.commons.MColor;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.painters.AbstractPainter;

public class GlassPainter
extends AbstractPainter {
    private RoundType roundType = RoundType.ALL;

    public GlassPainter() {
        this((Color)null);
    }

    public GlassPainter(Color color) {
        super(color, null);
        this.cache = new AbstractPainter.Cache();
    }

    public GlassPainter(RoundType roundType) {
        this(null, roundType);
    }

    public GlassPainter(Color color, RoundType roundType) {
        super(color, null);
        this.roundType = TK.checkNull(roundType, "roundType");
        this.cache = new AbstractPainter.Cache();
    }

    public static Color getBrighterColor(Color color) {
        return MColor.getBrighter(color, MColor.isDark(color) ? 35 : 55);
    }

    public RoundType getRoundType() {
        return this.roundType;
    }

    public void setRoundType(RoundType roundType) {
        if (TK.isChange((Object)this.roundType, (Object)roundType)) {
            this.roundType = TK.checkNull(roundType, "value");
            this.cache.invalidate();
        }
    }

    @Override
    public boolean isOpaque() {
        return this.roundType == RoundType.NONE;
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (this.isOpaque() && this.cache.paint(this, component, graphics2D, n, n2, n3, n4)) {
            return;
        }
        int n5 = n4 / 2;
        Color color = this.getPrimaryColor();
        if (color == null && (color = component.getBackground()) == null) {
            color = Color.WHITE;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        int n6 = Math.min(Math.max(8, n4 / 3), 24);
        GradientPaint gradientPaint = new GradientPaint(0.0f, n5 + n2, MColor.deriveColor(color, 0.96f), 0.0f, n4 + n2, color);
        graphics2D.setPaint(gradientPaint);
        RectangularShape rectangularShape = null;
        switch (this.roundType) {
            case NONE: 
            case TOP: {
                rectangularShape = new Rectangle2D.Float(n, n5 - n6 / 2 + n2, n3, n5 + n6 / 2 + 1);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case ALL: 
            case BOTTOM: {
                rectangularShape = new RoundRectangle2D.Float(n, n5 - n6 / 2 + n2, n3, n5 + n6 / 2 + 1, n6, n6);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            default: {
                throw new WTFError(this.roundType);
            }
        }
        graphics2D.fill(rectangularShape);
        Color color2 = GlassPainter.getBrighterColor(color);
        int n7 = n5 + n6 / 4;
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, n2, color2, 0.0f, n7 + n2, color);
        graphics2D.setPaint(gradientPaint2);
        switch (this.roundType) {
            case NONE: 
            case BOTTOM: {
                rectangularShape = new Rectangle2D.Float(n, n2, n3, n7);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case TOP: 
            case ALL: {
                rectangularShape = new RoundRectangle2D.Float(n, n2, n3, n7, n6, n6);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            default: {
                throw new WTFError(this.roundType);
            }
        }
        graphics2D.fill(rectangularShape);
        graphics2D.setPaint(null);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static enum RoundType {
        NONE,
        ALL,
        TOP,
        BOTTOM;

    }
}

