/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.preview;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MTaskPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.preview.Preview;

public class PreviewPanel
extends MTaskPanel<Image> {
    public static final int SMALL_WIDTH = 150;
    public static final int MEDIUM_WIDTH = 400;
    private boolean previewEnabled = true;
    private File file;
    private int maximumHeight;
    private int width;
    private MLabel previewImage;
    private Preview preview;

    public PreviewPanel() {
        this(DefaultPreview.getInstance(), 150);
    }

    public PreviewPanel(int n) {
        this(DefaultPreview.getInstance(), n);
    }

    public PreviewPanel(Preview preview, int n) {
        this.preview = TK.checkNull(preview, "preview");
        this.width = n;
        this.setOpaque(false);
        this.previewImage = new MLabel();
        this.previewImage.setHorizontalAlignment(0);
        this.previewImage.setPreferredSize(new Dimension(n, n));
        this.previewImage.setStyle("background-color: white");
        this.setFrontComponent(this.previewImage);
        String string = UI._("Preview");
        this.previewImage.setToolTipText(string);
        this.setToolTipText(string);
    }

    public void clear() {
        this.previewImage.setIcon(null);
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(int n) {
        this.maximumHeight = n;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean bl) {
        if (this.previewEnabled == bl) {
            return;
        }
        this.previewEnabled = bl;
        this.setVisible(bl);
        if (!this.previewEnabled) {
            this.cancel(true);
        }
    }

    @Override
    public void setFrontVisible(boolean bl, boolean bl2) {
        if (bl && this.previewImage != null) {
            this.previewImage.setIcon(null);
        }
        super.setFrontVisible(bl, bl2);
    }

    public void update(File file) {
        this.cancel(true);
        this.file = file;
        if (!(this.previewEnabled && file != null && file.exists() && file.isFile())) {
            this.previewImage.setIcon(null);
            return;
        }
        this.start();
    }

    @Override
    protected Image doInBackground() throws Exception {
        return this.preview.getImage(this.file, this.width, new MProperties());
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.error();
            return;
        }
        try {
            Image image = (Image)this.getResult();
            if (image == null) {
                this.error();
            } else {
                if (this.maximumHeight > 0 && image.getHeight(null) > this.maximumHeight) {
                    BufferedImage bufferedImage = UI.createCompatibleImage(image.getWidth(null), this.maximumHeight, true);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    graphics2D.dispose();
                    image = bufferedImage;
                }
                this.previewImage.setImage(image);
                this.previewImage.setText(null);
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            this.error();
        }
    }

    protected void error() {
        this.previewImage.setIcon(null);
        this.previewImage.setText(UI._("Preview not available"));
    }
}

