/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.awt.Component;
import java.awt.Image;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.EnumSet;
import javax.print.attribute.PrintRequestAttributeSet;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MSwingWorker;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.print.AbstractPrintInfo;
import org.makagiga.commons.print.PrintDialog;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.PrintableImage;

public class ImagePrintInfo
extends AbstractPrintInfo
implements MDisposable {
    @Deprecated
    public static final int WEAK_REFERENCE = 1;
    private Image image;

    public ImagePrintInfo(String string, Image image) {
        this(string, image, 1);
    }

    @Deprecated
    public ImagePrintInfo(String string, Image image, int n) {
        super(string, null, null);
        this.image = image;
    }

    @Override
    public void afterPrint(PrintInfo.PrintResult printResult) {
    }

    @Override
    public void beforePrint() {
    }

    @Override
    public Printable getPrintable(Flags flags) throws PrinterException {
        return new PrintableImage(this.image);
    }

    @Override
    public Component getPrintComponent() {
        return null;
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags) throws PrinterException {
        return ImagePrintInfo.printDocument(this.getPrintable(flags), this.getPrintTitle(), flags);
    }

    @Deprecated
    public static PrintInfo.PrintResult printDocument(Printable printable, String string) throws PrinterException {
        return ImagePrintInfo.printDocument(printable, string, new Flags());
    }

    public static PrintInfo.PrintResult printDocument(Printable printable, String string, Flags flags) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(printable);
        PrintRequestAttributeSet printRequestAttributeSet = ImagePrintInfo.getPrintRequestAttributeSet(flags, string);
        if (!printerJob.printDialog(printRequestAttributeSet)) {
            return PrintInfo.PrintResult.CANCELLED;
        }
        PrintTask printTask = new PrintTask(printable, string, printRequestAttributeSet, printerJob);
        printTask.start();
        return PrintInfo.PrintResult.IN_PROGRESS;
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.image = null;
        return null;
    }

    private static final class PrintTask
    extends MSwingWorker<Void> {
        private Printable printable;
        private PrinterJob job;
        private final PrintRequestAttributeSet attr;

        @Override
        protected Void doInBackground() throws PrinterException {
            this.job.print(this.attr);
            return null;
        }

        @Override
        protected void onEnd() {
            this.job = null;
            this.printable = TK.dispose(this.printable);
        }

        @Override
        protected void onError(Throwable throwable, boolean bl) {
            if (bl) {
                this.job.cancel();
                PrintDialog.showMessage(PrintInfo.PrintResult.CANCELLED);
            } else if (throwable instanceof PrinterAbortException) {
                PrintDialog.showMessage(PrintInfo.PrintResult.CANCELLED, throwable);
            } else {
                PrintDialog.showMessage(PrintInfo.PrintResult.ERROR, throwable);
            }
        }

        @Override
        protected void onSuccess(Void void_) {
            PrintDialog.showMessage(PrintInfo.PrintResult.COMPLETE);
        }

        private PrintTask(Printable printable, String string, PrintRequestAttributeSet printRequestAttributeSet, PrinterJob printerJob) {
            super(null, UI._("Printing \"{0}\"...", string), EnumSet.of(MSwingWorker.Option.STATUS_ICON));
            this.printable = printable;
            this.attr = printRequestAttributeSet;
            this.job = printerJob;
        }
    }
}

