/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MIconButton;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.script.ScriptComboBox;
import org.makagiga.commons.script.ScriptError;
import org.makagiga.commons.script.ScriptExecutor;
import org.makagiga.commons.script.ScriptIDE;

public final class ScriptYourself {
    public static final String CONTEXT_PROPERTY = "org.makagiga.commons.script.ScriptYourself.CONTEXT_PROPERTY";
    private static MouseListener buttonMouseListener;
    private static MouseListener toolBarMouseListener;
    private static final String ACTION_ID_PROPERTY = "org.makagiga.commons.script.ScriptYourself.ACTION_ID";
    private static final String TOOL_BAR_ID_PROPERTY = "org.makagiga.commons.script.ScriptYourself.TOOL_BAR_ID";

    @Deprecated
    public static String getActionBasePath(MAction mAction) {
        return ScriptYourself.getActionBasePath(mAction, true);
    }

    @Deprecated
    public static String getActionBasePath(String string, String string2) {
        return ScriptYourself.getActionBasePath(string, string2, true);
    }

    @Deprecated
    public static String getToolBarDir(String string) {
        return ScriptYourself.getToolBarDir(string, true);
    }

    public static void install(MToolBar mToolBar) {
        ScriptYourself.install(mToolBar, mToolBar.getID());
    }

    public static void install(MToolBar mToolBar, String string) {
        TK.validateID(string);
        if (FS.isRestricted()) {
            return;
        }
        MLogger.debug("script", "Installing \"%s\" tool bar scripts...", string);
        if (mToolBar.getID() == null) {
            mToolBar.setID(string);
        }
        String string2 = ScriptYourself.getToolBarDir(string, false);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new FilePermission(string2 + File.separatorChar + "*", "read"));
            }
            catch (SecurityException securityException) {
                MLogger.warning("core", "User script actions disabled by security manager: %s", string);
                return;
            }
        }
        String string3 = (String)mToolBar.getClientProperty(CONTEXT_PROPERTY);
        File file = new File(string2);
        if (file.exists()) {
            for (String string4 : FS.listNames(file)) {
                if (!"properties".equals(FS.getExtension(string4))) continue;
                ActionProperties actionProperties = new ActionProperties(new Config(FS.makePath(file.getPath(), string4)));
                if (string3 != null && !TK.isEmpty(actionProperties.context) && !MObject.safeEquals(string3, actionProperties.context)) {
                    MLogger.debug("script", "No valid context (%s) for action \"%s\"", actionProperties.context, actionProperties.name);
                    continue;
                }
                String string5 = string4.substring(0, string4.lastIndexOf(46));
                mToolBar.addButton(ScriptYourself.createActionButton(string, string5, actionProperties), 0);
            }
        }
        mToolBar.add(new Marker(string));
        if (toolBarMouseListener == null) {
            toolBarMouseListener = new MMouseAdapter(){

                @Override
                public void popupTrigger(MouseEvent mouseEvent) {
                    if (ScriptExecutor.userScript.get().booleanValue() && 1.isRight(mouseEvent)) {
                        ScriptYourself.showNewActionMenu((JComponent)mouseEvent.getSource());
                        mouseEvent.consume();
                    }
                }
            };
        }
        mToolBar.addMouseListener(toolBarMouseListener);
    }

    public static void deleteAction(MButton mButton) {
        if (MMessage.confirmDelete(mButton.getWindowAncestor(), UI._("Delete action?"), mButton.getText())) {
            String string = ScriptYourself.getActionBasePath((MAction)mButton.getAction(), false);
            ActionProperties actionProperties = new ActionProperties(string);
            FS.deleteFile(string + "." + actionProperties.language);
            FS.deleteFile(string + ".properties");
            MComponent.removeFromParent(mButton, true);
        }
    }

    public static void editProperties(MButton mButton) {
        MAction mAction = (MAction)mButton.getAction();
        MToolBar mToolBar = (MToolBar)mButton.getParent();
        String string = ScriptYourself.getActionBasePath(mAction, false);
        ActionProperties actionProperties = new ActionProperties(string);
        if (actionProperties.showDialog(mButton.getWindowAncestor(), mToolBar, false)) {
            mAction.setIconName(actionProperties.getIconName());
            mAction.setName(actionProperties.name);
            mAction.setLongDescription(actionProperties.description);
            actionProperties.save(string);
            if (mToolBar.getIconSize() != MIcon.Size.DEFAULT) {
                mButton.setIcon(MAction.getIcon(mAction, mToolBar.getIconSize()));
            }
            if (mToolBar.getTextPosition() == MToolBar.TextPosition.ALONGSIDE_ICONS) {
                mButton.setToolTipText(actionProperties.name);
                mButton.setText(null);
            } else {
                mButton.setToolTipText(actionProperties.description);
                mButton.setText(actionProperties.name);
            }
        }
    }

    public static void editScript(MButton mButton) {
        String string = ScriptYourself.getActionBasePath((MAction)mButton.getAction(), false);
        ActionProperties actionProperties = new ActionProperties(string);
        new ScriptIDE(mButton.getWindowAncestor(), string + "." + actionProperties.language, actionProperties.name);
    }

    public static void newAction(JComponent jComponent) {
        MToolBar mToolBar;
        ActionProperties actionProperties = new ActionProperties();
        Window window = UI.windowFor(jComponent);
        if (!actionProperties.showDialog(window, mToolBar = (MToolBar)jComponent, true)) {
            return;
        }
        String string = TK.createRandomUUID();
        String string2 = mToolBar.getID();
        MButton mButton = ScriptYourself.createActionButton(string2, string, actionProperties);
        ScriptYourself.addButton(mToolBar, string2, mButton);
        jComponent.validate();
        jComponent.repaint();
        String string3 = ScriptYourself.getActionBasePath(mToolBar.getID(), string, true);
        String string4 = string3 + "." + actionProperties.language;
        actionProperties.save(string3);
        try {
            if (new File(string4).createNewFile()) {
                new ScriptIDE(window, string4, actionProperties.name);
            } else {
                MMessage.error(window, UI._("Could not create a new file"));
            }
        }
        catch (IOException iOException) {
            MMessage.error(window, iOException);
        }
        mButton.requestFocusInWindow();
    }

    public static void showActionMenu(final MButton mButton) {
        MMenu mMenu = new MMenu();
        mMenu.add(new MAction(UI._("Edit Script...")){

            @Override
            public void onAction() {
                ScriptYourself.editScript(mButton);
            }
        });
        mMenu.addSeparator();
        mMenu.add(new MAction(UI._("Delete Action..."), "ui/delete"){

            @Override
            public void onAction() {
                ScriptYourself.deleteAction(mButton);
            }
        });
        mMenu.addSeparator();
        mMenu.add(new MAction(MActionInfo.PROPERTIES){

            @Override
            public void onAction() {
                ScriptYourself.editProperties(mButton);
            }
        });
        mMenu.showPopup(mButton);
    }

    public static void showNewActionMenu(final JComponent jComponent) {
        MMenu mMenu = new MMenu();
        mMenu.add(new MAction(UI._("New Action..."), "ui/newfile"){

            @Override
            public void onAction() {
                ScriptYourself.newAction(jComponent);
            }
        });
        mMenu.showPopup(jComponent);
    }

    private ScriptYourself() {
    }

    private static void addButton(MToolBar mToolBar, String string, MButton mButton) {
        int n = mToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Marker marker;
            Component component = mToolBar.getComponent(i);
            if (!(component instanceof Marker) || !(marker = (Marker)component).id.equals(string)) continue;
            MLogger.debug("script", "Found marker \"%s\" at %d index", string, i);
            mToolBar.addButtonAt(i, mButton, 0);
            return;
        }
        mToolBar.addButton(mButton);
    }

    private static MButton createActionButton(String string, String string2, final ActionProperties actionProperties) {
        MAction mAction = new MAction(actionProperties.name, actionProperties.getIconName()){

            @Override
            public void onAction() {
                if (!ScriptExecutor.userScript.get().booleanValue()) {
                    TK.beep();
                    return;
                }
                String string = ScriptYourself.getActionBasePath(this, false);
                try {
                    ScriptExecutor.execute(new File(string + "." + actionProperties.language));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MMessage.error(null, fileNotFoundException);
                }
                catch (ScriptException scriptException) {
                    ScriptError.getSharedInstance().showError(scriptException);
                }
            }
        };
        mAction.setLongDescription(actionProperties.description);
        mAction.putValue(ACTION_ID_PROPERTY, string2);
        mAction.putValue(TOOL_BAR_ID_PROPERTY, string);
        MButton mButton = new MButton(mAction);
        if (buttonMouseListener == null) {
            buttonMouseListener = new MMouseAdapter(){

                @Override
                public void popupTrigger(MouseEvent mouseEvent) {
                    if (ScriptExecutor.userScript.get().booleanValue() && 7.isRight(mouseEvent)) {
                        ScriptYourself.showActionMenu((MButton)mouseEvent.getSource());
                        mouseEvent.consume();
                    }
                }
            };
        }
        mButton.addMouseListener(buttonMouseListener);
        return mButton;
    }

    private static String getActionBasePath(MAction mAction, boolean bl) {
        return ScriptYourself.getActionBasePath(mAction.getValue(TOOL_BAR_ID_PROPERTY, null), mAction.getValue(ACTION_ID_PROPERTY, null), bl);
    }

    private static String getActionBasePath(String string, String string2, boolean bl) {
        return FS.makePath(ScriptYourself.getToolBarDir(string, bl), string2);
    }

    private static String getToolBarDir(String string, boolean bl) {
        String string2 = FS.makeConfigPath("scripts");
        string2 = FS.makePath(string2, "actions");
        string2 = FS.makePath(string2, string);
        if (bl) {
            FS.mkdirs(string2);
        }
        return string2;
    }

    private static final class Marker
    extends MComponent {
        private final String id;

        @Override
        public Dimension getMaximumSize() {
            return new Dimension();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension();
        }

        private Marker(String string) {
            this.id = string;
            this.setOpaque(false);
        }
    }

    private static final class ActionProperties {
        private String context;
        private String description;
        private String iconName = "ui/misc";
        private String language;
        private String name;

        private ActionProperties() {
        }

        private ActionProperties(Config config) {
            this.context = config.read("context", "");
            this.name = config.read("name", "");
            this.description = config.read("description", null);
            this.iconName = config.read("icon", null);
            this.language = config.read("language", "js");
        }

        private ActionProperties(String string) {
            this(new Config(string + ".properties"));
        }

        private String getIconName() {
            return this.iconName == null ? "ui/misc" : this.iconName;
        }

        private void save(String string) {
            Config config = new Config(string + ".properties");
            config.write("context", this.context);
            config.write("icon", this.iconName);
            config.write("language", this.language);
            config.write("name", this.name);
            config.write("description", this.description);
            config.sync();
        }

        private boolean showDialog(Window window, MToolBar mToolBar, boolean bl) {
            MIconButton mIconButton = new MIconButton(this.getIconName());
            MTextField mTextField = new MTextField(this.name);
            mTextField.setAutoCompletion("actionname");
            MTextField mTextField2 = new MTextField(this.description);
            mTextField2.setAutoCompletion("actiondescription");
            String string = (String)mToolBar.getClientProperty(ScriptYourself.CONTEXT_PROPERTY);
            MCheckBox mCheckBox = new MCheckBox(UI._("Show only in this context ({0})", string));
            mCheckBox.setEnabled(string != null);
            mCheckBox.setSelected(!TK.isEmpty(this.context));
            ScriptComboBox scriptComboBox = new ScriptComboBox();
            MPanel mPanel = new MPanel(true);
            MLayout mLayout = mPanel.getGroupLayout();
            mLayout.addComponent(mIconButton).addGap(mPanel.getContentMargin() * 2).beginRows().addComponent((Component)mTextField, UI._("Action Name:")).addComponent((Component)mTextField2, UI._("Description:")).addComponent(mCheckBox);
            if (bl) {
                mLayout.addComponent((Component)scriptComboBox, UI._("Script Language:"));
            }
            mLayout.end();
            MDialog mDialog = new MDialog(window, bl ? UI._("New Action") : UI._("Properties"), bl ? "ui/newfile" : MActionInfo.PROPERTIES.getIconName());
            if (bl) {
                mDialog.changeButton((AbstractButton)mDialog.getOKButton(), UI._("Create"));
            }
            mDialog.addCenter(mPanel);
            mDialog.packFixed(UI.WindowSize.MEDIUM);
            if (mDialog.exec(mTextField)) {
                mTextField.saveAutoCompletion();
                this.iconName = mIconButton.getIconName();
                if (bl) {
                    this.language = ((ScriptEngineFactory)scriptComboBox.getSelectedItem()).getExtensions().get(0);
                }
                this.name = mTextField.getText();
                this.description = mTextField2.isEmpty() ? null : mTextField2.getText();
                this.context = mCheckBox.isSelected() ? string : null;
                return true;
            }
            return false;
        }
    }
}

