/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.transition;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDisposable;

public class ImageView
implements MDisposable {
    private BufferedImage image;
    private float alpha = 1.0f;
    private final Point location = new Point();
    private WeakReference<JComponent> componentRef;

    public ImageView(JComponent jComponent) {
        if (jComponent != null) {
            this.componentRef = new WeakReference<JComponent>(jComponent);
            if (jComponent.getWidth() > 0 && jComponent.getHeight() > 0) {
                this.image = MComponent.createScreenshot(jComponent, jComponent.getBackground());
            }
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public JComponent getComponent() {
        return this.componentRef == null ? null : (JComponent)this.componentRef.get();
    }

    public int getX() {
        return this.location.x;
    }

    public void setX(int n) {
        this.location.x = n;
    }

    public int getY() {
        return this.location.y;
    }

    public void setY(int n) {
        this.location.y = n;
    }

    public void paint(JComponent jComponent, Graphics2D graphics2D) {
        if (this.image != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            graphics2D2.drawImage((Image)this.image, this.location.x, this.location.y, null);
            graphics2D2.dispose();
        }
    }

    @Override
    public Object dispose(Object ... objectArray) {
        if (this.componentRef != null) {
            this.componentRef.clear();
            this.componentRef = null;
        }
        this.image = null;
        return null;
    }
}

