/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.transition;

import javax.swing.JComponent;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.transition.ImageView;
import org.makagiga.commons.transition.Transition;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Sine;

public class MoveTransition
extends Transition {
    private final Direction direction;

    public MoveTransition(Direction direction) {
        super(500L);
        this.direction = TK.checkNull(direction);
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setup(JComponent jComponent, Timeline timeline, ImageView imageView, ImageView imageView2) {
        Direction direction;
        timeline.setEase(new Sine());
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        imageView.setX(0);
        imageView.setY(0);
        switch (this.getDirection()) {
            case AUTO_HORIZONTAL: {
                direction = this.isNext(jComponent, imageView, imageView2) ? Direction.RIGHT : Direction.LEFT;
                break;
            }
            case AUTO_VERTICAL: {
                direction = this.isNext(jComponent, imageView, imageView2) ? Direction.UP : Direction.DOWN;
                break;
            }
            default: {
                direction = this.direction;
            }
        }
        switch (direction) {
            case LEFT: {
                imageView2.setX(n);
                timeline.addPropertyToInterpolate(Timeline.property("x").on(imageView).from(0).to(-n));
                timeline.addPropertyToInterpolate(Timeline.property("x").on(imageView2).from(imageView2.getX()).to(0));
                break;
            }
            case RIGHT: {
                imageView2.setX(-n);
                timeline.addPropertyToInterpolate(Timeline.property("x").on(imageView).from(0).to(n));
                timeline.addPropertyToInterpolate(Timeline.property("x").on(imageView2).from(imageView2.getX()).to(0));
                break;
            }
            case UP: {
                imageView2.setY(n2);
                timeline.addPropertyToInterpolate(Timeline.property("y").on(imageView).from(0).to(-n2));
                timeline.addPropertyToInterpolate(Timeline.property("y").on(imageView2).from(imageView2.getY()).to(0));
                break;
            }
            case DOWN: {
                imageView2.setY(-n2);
                timeline.addPropertyToInterpolate(Timeline.property("y").on(imageView).from(0).to(n2));
                timeline.addPropertyToInterpolate(Timeline.property("y").on(imageView2).from(imageView2.getY()).to(0));
                break;
            }
            default: {
                throw new WTFError(this.direction);
            }
        }
    }

    private boolean isNext(JComponent jComponent, ImageView imageView, ImageView imageView2) {
        JComponent jComponent2 = imageView.getComponent();
        JComponent jComponent3 = imageView2.getComponent();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (n2 == -1 && jComponent.getComponent(i) == jComponent2) {
                n2 = i;
            }
            if (n != -1 || jComponent.getComponent(i) != jComponent3) continue;
            n = i;
        }
        return n > n2;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        AUTO_VERTICAL,
        AUTO_HORIZONTAL;

    }
}

