/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.validator;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.validator.Validator;

public abstract class TextComponentValidator
extends Validator<Document> {
    private DocumentListener listener;

    public TextComponentValidator() {
    }

    public TextComponentValidator(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    protected String getText() {
        return ((JTextComponent)JTextComponent.class.cast(this.getComponent())).getText();
    }

    @Override
    protected Document getValue() {
        return ((JTextComponent)JTextComponent.class.cast(this.getComponent())).getDocument();
    }

    @Override
    protected void install() {
        this.listener = new MDocumentAdapter<JTextComponent>(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && document.getLength() == 0 && Boolean.TRUE.equals(document.getProperty("org.makagiga.commons.autocompletion.AutoCompletion.TEXT_COMPONENT_IN_UPDATE_PROPERTY"))) {
                    return;
                }
                TextComponentValidator.this.revalidate();
            }
        };
        this.getValue().addDocumentListener(this.listener);
    }

    @Override
    protected void uninstall() {
        this.getValue().removeDocumentListener(this.listener);
        this.listener = null;
    }
}

