/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.util.Map;
import java.util.Properties;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.console.Console;
import org.makagiga.console.ConsoleCommand;

final class DebugCommand
extends ConsoleCommand {
    @Override
    public Object onCommand(Console console, String ... stringArray) {
        Console.IO iO = console.getIO();
        iO.printLine();
        iO.printLine("----[ CUT HERE ]----");
        console.executeCommand("version");
        iO.printLine("User directory          = " + FS.getUserDir());
        iO.printLine("Configuration directory = " + FS.getConfigDir());
        if (!OS.isWebStart()) {
            iO.printLine("Base directory          = " + FS.getBaseDir());
        }
        iO.printLine();
        Properties properties = System.getProperties();
        int n = 0;
        Map<String, String> map = TK.newHashMap(properties.size());
        for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
            if (object2.getKey() == null) continue;
            n = Math.max(n, object2.getKey().toString().length());
            map.put(object2.getKey().toString(), object2.getValue() == null ? "" : object2.getValue().toString());
        }
        int n2 = 0;
        for (Map.Entry entry : TK.sortByKey(map, null).entrySet()) {
            String string = (String)entry.getValue();
            if ("line.separator".equals(entry.getKey())) {
                string = string.replace("\n", "\\n");
                string = string.replace("\r", "\\r");
            }
            iO.printLine(console.getRowAttr(n2++), "%-" + n + "s = %s", entry.getKey(), string);
        }
        iO.printLine();
        console.executeCommand("getenv");
        console.executeCommand("mem");
        iO.printLine("Logs:");
        n2 = 0;
        for (MLogger mLogger : MLogger.getLogs()) {
            iO.printLine(console.getRowAttr(n2++), mLogger.getName());
        }
        iO.printLine();
        iO.printLine("Threads:");
        n2 = 0;
        Thread[] threadArray = new Thread[Thread.activeCount()];
        int n3 = Thread.enumerate(threadArray);
        for (int i = 0; i < n3; ++i) {
            String string;
            Thread thread = threadArray[i];
            int n4 = thread.getPriority();
            switch (n4) {
                case 1: {
                    string = "Minimum (" + n4 + ")";
                    break;
                }
                case 5: {
                    string = "Normal (" + n4 + ")";
                    break;
                }
                case 10: {
                    string = "Maximum (" + n4 + ")";
                    break;
                }
                default: {
                    string = "Custom (" + n4 + ")";
                }
            }
            iO.printLine(console.getRowAttr(n2++), "Name: %s, State = %s, Priority: %s, Daemon = %s, Alive = %s, Group = %s", new Object[]{thread.getName(), thread.getState(), string, thread.isDaemon(), thread.isAlive(), thread.getThreadGroup().getName()});
        }
        String string = MTimer.debug();
        if (string != null) {
            iO.printLine();
            iO.printLine("Timers:");
            iO.printLine(string);
        }
        return null;
    }

    DebugCommand() {
        super("debug", "Show debug information");
    }
}

