/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;

public final class DesktopPanel
extends MPanel
implements Focusable {
    private MButton addWidgetButton;
    private static MGuardedObject<DesktopPanel> _guardedInstance;
    private MPanel bottomPanel;
    private MTip tip;
    private final WeakReference<Desktop> desktopRef;

    public DesktopPanel(Desktop desktop) {
        this.desktopRef = new WeakReference<Desktop>(TK.checkNull(desktop));
        MWhatsThis.set(this, UI._("Widgets")).setKeyStroke(116);
        this.addCenter(desktop);
        this.addSouth(this.createBottomPanel());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("locked".equals(string) && propertyChangeEvent.getSource() instanceof Desktop) {
                    boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                    DesktopPanel.this.addWidgetButton.setEnabled(!bl);
                } else if ("value".equals(string)) {
                    DesktopPanel.this.updateBackground();
                }
            }
        };
        Desktop.backgroundColor.addPropertyChangeListener(propertyChangeListener);
        Desktop.widgetsPainterType.addPropertyChangeListener(propertyChangeListener);
        desktop.addPropertyChangeListener(propertyChangeListener);
        this.updateBackground();
    }

    @Override
    public void focus() {
        this.getDesktop().focus();
    }

    public MButton getAddWidgetButton() {
        return this.addWidgetButton;
    }

    public MPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public Desktop getDesktop() {
        return (Desktop)this.desktopRef.get();
    }

    @Deprecated
    public static synchronized DesktopPanel getInstance() {
        if (_guardedInstance == null) {
            _guardedInstance = new MGuardedObject<DesktopPanel>(new DesktopPanel(Desktop.getInstance()), "org.makagiga.desktop.DesktopPanel", PermissionInfo.ThreatLevel.MEDIUM, "Widgets");
        }
        return _guardedInstance.get();
    }

    public MTip getTip() {
        return this.tip;
    }

    private MPanel createBottomPanel() {
        this.bottomPanel = MPanel.createBorderPanel();
        this.bottomPanel.addWest(Pager.getInstance());
        this.tip = new MTip(Desktop.class.getName());
        this.tip.setRoundType(GlassPainter.RoundType.NONE);
        this.tip.showNextTip(MTip.Visible.OFTEN);
        this.bottomPanel.addCenter(this.tip);
        this.addWidgetButton = new MButton(UI._("Add Widget"), MIcon.small("ui/newfile")){

            @Override
            protected MMenu onPopupMenu() {
                MMenu mMenu = new MMenu();
                DesktopPanel.this.getDesktop().createNewWidgetMenu(mMenu, null);
                return mMenu;
            }
        };
        this.addWidgetButton.setPopupMenuEnabled(true);
        this.bottomPanel.addEast(this.addWidgetButton);
        return this.bottomPanel;
    }

    private void updateBackground() {
        if (UI.isGTK()) {
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setPainter(null);
        } else {
            WidgetDesktopPaneUI.PainterType painterType = (WidgetDesktopPaneUI.PainterType)((Object)Desktop.widgetsPainterType.get());
            if (painterType == WidgetDesktopPaneUI.PainterType.GRADIENT) {
                painterType = WidgetDesktopPaneUI.PainterType.FLAT;
            }
            this.bottomPanel.setPainter(WidgetDesktopPaneUI.createPainter(false, painterType));
        }
    }

    @Deprecated
    static synchronized boolean isInstance() {
        return _guardedInstance != null;
    }
}

