/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.FlatPainter;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.LinearGradientPainter;
import org.makagiga.commons.painters.Painter;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.desktop.ui.WidgetDesktopIconUI;
import org.makagiga.desktop.ui.WidgetInternalFrameUI;

public final class WidgetDesktopPaneUI
extends BasicDesktopPaneUI {
    private ActionGroup actionGroup;
    private static Painter _activeWidgetPainter;
    private static Painter _inactiveWidgetPainter;
    private static WidgetBorder widgetBorder;

    public WidgetDesktopPaneUI(final Desktop desktop) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("value".equals(propertyChangeEvent.getPropertyName())) {
                    _activeWidgetPainter = null;
                    _inactiveWidgetPainter = null;
                    desktop.repaint();
                    for (WidgetInternalFrame widgetInternalFrame : desktop) {
                        ((WidgetInternalFrameUI)WidgetInternalFrameUI.class.cast(widgetInternalFrame.getUI())).flushPainterCache();
                        widgetInternalFrame.repaint();
                        if (widgetInternalFrame.getDesktopIcon() == null) continue;
                        DesktopIconUI desktopIconUI = widgetInternalFrame.getDesktopIcon().getUI();
                        if (desktopIconUI instanceof WidgetDesktopIconUI) {
                            ((WidgetDesktopIconUI)WidgetDesktopIconUI.class.cast((Object)desktopIconUI)).contentPanel.setPainter(WidgetDesktopPaneUI.getSharedPainter(false));
                        }
                        widgetInternalFrame.getDesktopIcon().repaint();
                    }
                }
            }
        };
        Desktop.backgroundColor.addPropertyChangeListener(propertyChangeListener);
        Desktop.widgetsPainterType.addPropertyChangeListener(propertyChangeListener);
    }

    public static Border createBorder() {
        if (widgetBorder == null) {
            widgetBorder = new WidgetBorder();
        }
        if (UI.isGTK() || UI.isWindows()) {
            return widgetBorder;
        }
        return BorderFactory.createCompoundBorder(UI.createDropShadowBorder(), widgetBorder);
    }

    public static Painter createPainter(boolean bl) {
        return WidgetDesktopPaneUI.createPainter(bl, (PainterType)((Object)Desktop.widgetsPainterType.get()));
    }

    public static Painter createPainter(boolean bl, PainterType painterType) {
        switch (painterType) {
            case FLAT: {
                return new WidgetFlatPainter(bl);
            }
            case GRADIENT: {
                return new WidgetGradientPainter(bl);
            }
        }
        return new WidgetGlassPainter(bl);
    }

    public static Color getDesktopBackground() {
        Color color = (Color)Desktop.backgroundColor.get();
        return color == null ? Color.BLACK : color;
    }

    public static Color getDesktopForeground() {
        Color color = WidgetDesktopPaneUI.getDesktopBackground();
        if (MColor.isDark(color)) {
            return MColor.getBrighter(color, 60);
        }
        return MColor.deriveColor(color, 0.6f);
    }

    public static Painter getSharedPainter(boolean bl) {
        if (bl) {
            if (_activeWidgetPainter == null) {
                _activeWidgetPainter = WidgetDesktopPaneUI.createPainter(true);
            }
            return _activeWidgetPainter;
        }
        if (_inactiveWidgetPainter == null) {
            _inactiveWidgetPainter = WidgetDesktopPaneUI.createPainter(false);
        }
        return _inactiveWidgetPainter;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public static Composite setComposite(Graphics2D graphics2D, boolean bl) {
        Composite composite = null;
        composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(bl ? 0.7f : 0.5f));
        return composite;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.actionGroup = new ActionGroup();
        this.actionGroup.add("close", new MAction("close", 115, 2){

            @Override
            public void onAction() {
                JInternalFrame jInternalFrame = WidgetDesktopPaneUI.this.desktop.getSelectedFrame();
                if (jInternalFrame != null) {
                    jInternalFrame.doDefaultCloseAction();
                }
            }
        });
        this.actionGroup.add("minimize", new MAction("minimize", 120, 2){

            @Override
            public void onAction() {
                JInternalFrame jInternalFrame = WidgetDesktopPaneUI.this.desktop.getSelectedFrame();
                if (jInternalFrame != null) {
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        MLogger.exception(propertyVetoException);
                    }
                }
            }
        });
        this.actionGroup.add("selectNextFrame", new MAction("selectNextFrame", 117, 2){

            @Override
            public void onAction() {
                WidgetDesktopPaneUI.this.desktop.selectFrame(true);
            }
        });
        for (ActionGroup.Item item : this.actionGroup) {
            this.actionGroup.connect(item.getID(), (JComponent)this.desktop, 2);
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        if (this.actionGroup != null) {
            for (ActionGroup.Item item : this.actionGroup) {
                this.actionGroup.disconnect(item.getID(), this.desktop, 2);
            }
            this.actionGroup = null;
        }
    }

    private static Color getPainterColor(boolean bl) {
        Color color = WidgetDesktopPaneUI.getDesktopBackground();
        return MColor.deriveColor(color, bl ? 1.1f : 0.9f);
    }

    private static final class WidgetGradientPainter
    extends LinearGradientPainter {
        private boolean active;

        @Override
        public Color getPrimaryColor() {
            return WidgetDesktopPaneUI.getPainterColor(this.active);
        }

        @Override
        public Color getSecondaryColor() {
            return MColor.getBrighter(this.getPrimaryColor());
        }

        private WidgetGradientPainter(boolean bl) {
            super((Color)null, (Color)null);
            this.active = bl;
        }
    }

    private static final class WidgetGlassPainter
    extends GlassPainter {
        private boolean active;

        @Override
        public Color getPrimaryColor() {
            return WidgetDesktopPaneUI.getPainterColor(this.active);
        }

        private WidgetGlassPainter(boolean bl) {
            super(null, GlassPainter.RoundType.NONE);
            this.active = bl;
        }
    }

    private static final class WidgetFlatPainter
    extends FlatPainter {
        private boolean active;

        @Override
        public Color getPrimaryColor() {
            return WidgetDesktopPaneUI.getPainterColor(this.active);
        }

        private WidgetFlatPainter(boolean bl) {
            super(null);
            this.active = bl;
        }
    }

    private static final class WidgetBorder
    extends LineBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = component instanceof JInternalFrame ? ((JInternalFrame)JInternalFrame.class.cast(component)).isSelected() : (component instanceof JInternalFrame.JDesktopIcon ? ((JInternalFrame.JDesktopIcon)JInternalFrame.JDesktopIcon.class.cast(component)).isFocusOwner() : false);
            this.lineColor = WidgetDesktopPaneUI.getPainterColor(bl);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = WidgetDesktopPaneUI.setComposite(graphics2D, bl);
            super.paintBorder(component, graphics2D, n, n2, n3, n4);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }

        private WidgetBorder() {
            super(Color.BLACK, 2);
        }
    }

    public static enum PainterType {
        FLAT,
        GLASS,
        GRADIENT;

    }
}

