/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.link;

import java.awt.Component;
import java.awt.Window;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.UUID;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.ConfigFile;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.HTMLSelection;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextArea;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MZip;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.TextPrintInfo;
import org.makagiga.editors.Actions;
import org.makagiga.editors.EditorExportV2;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.SimpleEditor;
import org.makagiga.editors.link.Link;
import org.makagiga.form.Default;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.tree.formats.Incollector;

public final class LinkEditor
extends SimpleEditor
implements EditorExportV2,
EditorIO,
EditorPrint,
Focusable {
    private boolean autoSyncEnabled = true;
    private final MCheckBox visited;
    private MHTMLViewer printComponent;
    private final MPanel urlPanel;
    private final MTextArea description;
    private final MTextField urlEditor;
    private final MURLButton urlViewer;

    public LinkEditor() {
        MPanel mPanel = this.getMainPanel();
        mPanel.setContentMargin();
        mPanel.setVBoxLayout();
        this.initActions();
        this.urlPanel = MPanel.createCardPanel();
        this.urlEditor = new MTextField(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                LinkEditor.this.setModified(true);
                LinkEditor.this.updateActions();
            }
        };
        this.urlEditor.setAutoCompletion("linkurl");
        this.urlPanel.add((Component)MPanel.createHLabelPanel(this.urlEditor, UI._("Link Address:")), "editor");
        this.urlViewer = new MURLButton(){

            @Override
            protected void onClick() {
                LinkEditor.this.doOpen();
            }
        };
        this.urlPanel.add((Component)this.urlViewer, "viewer");
        this.urlPanel.limitHeight(this.urlViewer);
        mPanel.add(this.urlPanel);
        mPanel.addGap();
        this.visited = new MCheckBox(UI._("Visited")){

            @Override
            protected void onClick() {
                if (this.isModified()) {
                    LinkEditor.this.setModified(true);
                }
            }
        };
        mPanel.add(this.visited);
        mPanel.addGap();
        this.description = new MTextArea(){

            @Override
            public void setModified(boolean bl, Object object) {
                super.setModified(bl, object);
                LinkEditor.this.setModified(bl);
            }
        };
        mPanel.add(MLabel.createFor(this.description, "Description"));
        mPanel.addGap();
        mPanel.add(new MScrollPane(this.description));
        mPanel.addGap();
        MTip mTip = new MTip(CoolHeader.Direction.LEFT, LinkEditor.class.getName());
        mTip.showNextTip(MTip.Visible.OFTEN);
        mPanel.add(mTip);
    }

    @Override
    public void focus() {
        this.urlEditor.requestFocusInWindow();
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    @Override
    public void setModified(boolean bl) {
        super.setModified(bl);
        if (this.autoSyncEnabled && bl) {
            this.syncLater();
        }
    }

    @Override
    public void updateActions() {
        boolean bl = !this.urlEditor.isEmpty();
        this.editActionGroup.setEnabled("copy-as-html", bl);
        this.editActionGroup.setEnabled("open", bl);
        this.editActionGroup.setEnabled("paste", !this.isLocked());
        this.urlEditor.setEditable(!this.isLocked());
        this.urlViewer.setEnabled(bl);
        this.urlViewer.setURLAndText(this.urlEditor.getText());
        this.urlPanel.showCard(this.isLocked() ? "viewer" : "editor");
        this.description.setEditable(!this.isLocked());
        this.visited.setEnabled(!this.isLocked());
    }

    @Override
    public void exportFile(EditorPlugin.FileType fileType, OutputStream outputStream) throws Exception {
        if (fileType.is("desktop")) {
            this.saveDesktopFile(outputStream);
        } else if (fileType.is("ied")) {
            this.saveIncollectorFile(outputStream);
        } else if (fileType.is("mglink")) {
            this.saveFile(outputStream);
        } else if (fileType.is("url")) {
            this.saveURLFile(outputStream);
        }
    }

    @Override
    public Object configureExport(Window window, EditorPlugin.FileType fileType) throws Exception {
        if (fileType.is("webapp")) {
            return this.configureWebappFile(window);
        }
        return null;
    }

    @Override
    public EditorExportV2.ExportResult exportFile(EditorPlugin.FileType fileType, File file, OutputStream outputStream, Object object) throws Exception {
        if (fileType.is("webapp")) {
            this.saveWebappFile(outputStream, (WebappForm)object);
        }
        return EditorExportV2.ExportResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFile(InputStream inputStream, boolean bl) throws Exception {
        if (!bl) {
            try {
                this.autoSyncEnabled = false;
                Link link = XMLHelper.unmarshal(Link.class, inputStream);
                this.description.setText(link.getDescription());
                this.description.scrollToTop();
                MText.setText(this.urlEditor, link.getURL());
                this.visited.setAndRemember(link.isVisited());
            }
            finally {
                this.autoSyncEnabled = true;
            }
        }
    }

    @Override
    public void saveFile(OutputStream outputStream) throws Exception {
        this.urlEditor.saveAutoCompletion();
        Link link = new Link();
        link.setDescription(this.description.getText());
        link.setURL(this.urlEditor.getText());
        link.setVisited(this.visited.isSelected());
        XMLHelper.marshal((Object)link, outputStream);
        Object[] objectArray = new Object[]{link.getURL(), link.getDescription()};
        if (!this.updateLocalIndex(objectArray)) {
            this.updateIndex(objectArray);
        }
    }

    @Override
    public Printable getPrintable(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        if (this.printComponent == null) {
            this.printComponent = new MHTMLViewer();
            this.printComponent.setStyle("background-color: white; color: black");
        }
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.addHeader(1, HTMLBuilder.escape(this.getMetaInfo().toString()));
        if (!this.urlEditor.isEmpty()) {
            hTMLBuilder.addHeader(2, HTMLBuilder.escape(UI._("Address")));
            hTMLBuilder.beginTag("p");
            hTMLBuilder.doubleTag("code", HTMLBuilder.escape(this.urlEditor.getText()), new Object[0]);
            hTMLBuilder.endTag("p");
        }
        if (!this.description.isEmpty()) {
            hTMLBuilder.addHeader(2, HTMLBuilder.escape(UI._("Description")));
            hTMLBuilder.doubleTag("p", HTMLBuilder.escape(this.description.getText()), new Object[0]);
        }
        if (this.visited.isSelected()) {
            hTMLBuilder.addHeader(2, HTMLBuilder.escape(UI._("Visited")));
        }
        this.printComponent.setHTML(hTMLBuilder);
        return this.printComponent.getPrintable(messageFormat, messageFormat2);
    }

    @Override
    public int getPrintingCapabilities() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintInfo.PrintResult printDocument(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        try {
            PrintInfo.PrintResult printResult = TextPrintInfo.printDocument(this.printComponent, flags, messageFormat, messageFormat2, this.getPrintTitle());
            return printResult;
        }
        finally {
            this.printComponent = null;
        }
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        String string2;
        super.updateMenu(string, mMenu);
        if (string.equals("EDIT_MENU") && !(string2 = this.urlEditor.getText()).isEmpty()) {
            MURLButton.updateLinkMenu(mMenu, string2, this.getMetaInfo().toString());
        }
    }

    private Object configureWebappFile(Window window) throws URISyntaxException {
        WebappForm webappForm = new WebappForm();
        webappForm.uri = new URI(this.urlEditor.getText());
        webappForm.id = webappForm.uri.getHost() + "@" + UUID.randomUUID();
        FormPanel<WebappForm> formPanel = new FormPanel<WebappForm>(webappForm);
        if (formPanel.createDialog(window, UI._("Export")).exec()) {
            return webappForm;
        }
        return CANCEL_EXPORT;
    }

    private void doOpen() {
        try {
            URI uRI;
            File file = new File(this.urlViewer.getURL());
            if (OS.isWindows() && file.exists()) {
                uRI = file.toURI();
                MLogger.debug("link", "Using local URI: %s", uRI);
            } else {
                uRI = new URI(this.urlViewer.getURL());
                MLogger.debug("link", "Using URI: %s", uRI);
            }
            MMainWindow.openURI(uRI);
            if (!this.visited.isSelected()) {
                this.visited.setSelected(true);
                TK.fireActionPerformed(this.visited, this.visited.getActionListeners());
            }
            this.urlViewer.setVisited(true);
        }
        catch (URISyntaxException uRISyntaxException) {
            MMessage.error(null, UI._("Invalid link address"));
        }
    }

    private void initActions() {
        this.editActionGroup.add("copy-as-html", new MAction(MActionInfo.COPY_AS_HTML){

            @Override
            public void onAction() {
                LinkEditor.this.urlEditor.makeDefault();
                String string = LinkEditor.this.urlEditor.getText();
                String string2 = LinkEditor.this.getMetaInfo().toString();
                HTMLSelection hTMLSelection = new HTMLSelection(HTMLBuilder.createLink(string, string2));
                try {
                    MClipboard.setContents(hTMLSelection);
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
            }
        }).setShowTextInToolBar(true);
        this.editActionGroup.add("paste", new Actions.Paste<LinkEditor>(){

            @Override
            public void onAction(LinkEditor linkEditor) {
                try {
                    linkEditor.urlEditor.setText(MClipboard.getString());
                    linkEditor.urlEditor.makeDefault();
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
            }
        }).setShowTextInToolBar(true);
        this.editActionGroup.addSeparator();
        this.editActionGroup.add("open", new MAction(MActionInfo.OPEN_URI){

            @Override
            public void onAction() {
                LinkEditor.this.doOpen();
            }
        }).setShowTextInToolBar(true);
    }

    private void saveDesktopFile(OutputStream outputStream) throws Exception {
        ConfigFile configFile = new ConfigFile();
        ConfigFile.Group group = configFile.setDesktopEntry("Link", this.getMetaInfo().toString());
        group.set("Icon", "www");
        group.set("URL", this.urlEditor.getText());
        configFile.write(outputStream);
    }

    private void saveIncollectorFile(OutputStream outputStream) throws Exception {
        Incollector incollector = new Incollector();
        Incollector.Entry entry = new Incollector.Entry();
        entry.setMetaInfo(this.getMetaInfo());
        Incollector.WebAddress webAddress = new Incollector.WebAddress();
        webAddress.setName(this.getMetaInfo().toString());
        webAddress.setText(this.urlEditor.getText());
        if (!this.description.isEmpty()) {
            entry.setComment(this.description.getText());
        }
        entry.setWebAddress(webAddress);
        incollector.addEntry(entry);
        incollector.export(outputStream);
    }

    private void saveURLFile(OutputStream outputStream) throws Exception {
        ConfigFile configFile = new ConfigFile(ConfigFile.Format.INI);
        ConfigFile.Group group = configFile.get("InternetShortcut");
        group.set("URL", this.urlEditor.getText());
        configFile.write(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveWebappFile(OutputStream outputStream, WebappForm webappForm) throws Exception {
        MZip mZip = null;
        try {
            mZip = MZip.write(outputStream);
            mZip.beginEntry("webapp.ini");
            ConfigFile configFile = new ConfigFile(ConfigFile.Format.INI);
            ConfigFile.Group group = configFile.get("Parameters");
            group.set("id", webappForm.id);
            group.set("uri", webappForm.uri.toString());
            group.set("status", WebappForm.toString(webappForm.status));
            group.set("location", WebappForm.toString(webappForm.location));
            group.set("sidebar", WebappForm.toString(webappForm.sidebar));
            group.set("navigation", WebappForm.toString(webappForm.navigation));
            configFile.write(mZip.getOutputStream());
        }
        finally {
            mZip.close();
        }
    }

    @Form(order={"id", "status", "location", "sidebar", "navigation"})
    private static final class WebappForm {
        @Default
        @Field(label="Unique ID:", required=true)
        private String id;
        @Field(label="Show Statusbar")
        private boolean status = true;
        @Field(label="Show Location Bar")
        private boolean location;
        @Field(label="Show Sidebar")
        private boolean sidebar;
        @Field(label="History Navigation")
        private boolean navigation;
        private URI uri;

        private WebappForm() {
        }

        private static String toString(boolean bl) {
            return bl ? "yes" : "no";
        }
    }
}

