/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.notepad;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.ServiceLoader;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.commons.Tuple;
import org.makagiga.commons.UI;
import org.makagiga.editors.Designer;
import org.makagiga.editors.notepad.NotepadEditor;
import org.makagiga.editors.notepad.spi.CodePreviewProvider;
import org.makagiga.editors.notepad.spi.HTMLPreviewProvider;
import org.makagiga.plugins.PluginManager;

public final class NotepadEditorDesigner
extends Designer
implements MDisposable {
    private JComponent settingsComponent;
    private MAction automaticRefresh;
    private MButton manualRefreshButton;
    private MButton showHTMLButton;
    private MComboBox<CodePreviewProvider> preview;
    private MHTMLViewer viewer;
    private MTimer updateTimer;
    private final WeakReference<NotepadEditor> editorRef;

    @Override
    public Object dispose(Object ... objectArray) {
        this.automaticRefresh = null;
        this.editorRef.clear();
        if (this.preview != null) {
            for (CodePreviewProvider codePreviewProvider : this.preview) {
                TK.dispose(codePreviewProvider);
            }
            this.preview = null;
        }
        this.manualRefreshButton = null;
        if (this.settingsComponent != null) {
            this.remove(this.settingsComponent);
            this.settingsComponent = null;
        }
        this.showHTMLButton = null;
        this.updateTimer = TK.dispose(this.updateTimer);
        if (this.viewer != null) {
            this.viewer.uninstallCache();
            this.viewer = null;
        }
        return null;
    }

    private void initComponents() {
        CodePreviewProvider codePreviewProvider = this.preview.getSelectedItem();
        JComponent jComponent = codePreviewProvider.getSettingsComponent();
        UI.replaceComponent(this, this.settingsComponent, jComponent, "South", true);
        this.settingsComponent = jComponent;
        if (this.viewer == null) {
            this.viewer = new MHTMLViewer();
            MText.disableCaretUpdate(this.viewer);
            this.addCenter(this.viewer);
            this.revalidate();
        }
    }

    private void setHTML(String string) {
        this.viewer.installCache(3);
        JViewport jViewport = MScrollPane.getViewport(this.viewer);
        Point point = jViewport == null ? null : jViewport.getViewPosition();
        this.viewer.setHTML(string);
        this.viewer.setVisible(true);
        if (point != null) {
            jViewport.setViewPosition(point);
        }
    }

    private void showHTML() {
        String string = this.viewer.getText();
        MMessage.text(this.getWindowAncestor(), string, "HTML", false);
    }

    NotepadEditorDesigner(NotepadEditor notepadEditor) {
        super(new BorderLayout(0, 0));
        this.setDisplayText(UI._("Preview"));
        this.editorRef = new WeakReference<NotepadEditor>(notepadEditor);
        this.preview = new MComboBox<CodePreviewProvider>(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(10, super.getMinimumSize().height);
            }

            @Override
            protected void onSelect() {
                NotepadEditorDesigner.this.initComponents();
                NotepadEditorDesigner.this.updateViewer();
            }
        };
        this.preview.setWideList(true);
        this.preview.setEventsEnabled(false);
        this.preview.addItem((NonePreview)new NonePreview());
        for (CodePreviewProvider object2 : ServiceLoader.load(CodePreviewProvider.class)) {
            this.preview.addItem((CodePreviewProvider)object2);
        }
        for (CodePreviewProvider codePreviewProvider : PluginManager.loadServices(CodePreviewProvider.class)) {
            this.preview.addItem((CodePreviewProvider)codePreviewProvider);
        }
        this.preview.setEventsEnabled(true);
        MSmallButton mSmallButton = new MSmallButton(MActionInfo.SETTINGS){

            @Override
            protected MMenu onPopupMenu() {
                MMenu mMenu = new MMenu();
                mMenu.addCheckBox(NotepadEditorDesigner.this.automaticRefresh);
                CodePreviewProvider codePreviewProvider = (CodePreviewProvider)NotepadEditorDesigner.this.preview.getSelectedItem();
                codePreviewProvider.updateSettingsMenu(mMenu);
                return mMenu;
            }
        };
        mSmallButton.setPopupMenuEnabled(true);
        this.automaticRefresh = new MAction(UI._("Auto Refresh")){

            @Override
            public void onAction() {
                if (this.isSelected()) {
                    NotepadEditorDesigner.this.updateViewer();
                }
            }
        };
        this.automaticRefresh.setSelected(true);
        this.manualRefreshButton = new MButton(MActionInfo.REFRESH.getText()){

            @Override
            protected void onClick() {
                NotepadEditorDesigner.this.updateViewer();
            }
        };
        this.manualRefreshButton.setRequestFocusEnabled(false);
        this.showHTMLButton = new MButton(UI._("Show HTML")){

            @Override
            protected void onClick() {
                NotepadEditorDesigner.this.updateViewer();
                NotepadEditorDesigner.this.showHTML();
            }
        };
        this.showHTMLButton.setRequestFocusEnabled(false);
        MArrayList<Tuple.Two<String, String>> mArrayList = MArrayList.create();
        mArrayList.add(Tuple.of("WikiMedia Syntax Preview", "{02bf62ed-5ce2-49c8-bd00-b7d927a0daf3}"));
        mArrayList.add(Tuple.of("Markup (BB Code, Markdown) Preview", "{6cc61e43-701c-40fa-86ae-49692ac6e5e0}"));
        MPanel mPanel = MPanel.createGroupPanel(true);
        mPanel.setMargin(5);
        mPanel.getGroupLayout().beginRows().beginColumns().addComponent(this.preview, UI._("Preview:")).addComponent(mSmallButton).end().addComponent(PluginManager.createPluginInstallButton(mArrayList)).beginColumns().addComponent(this.manualRefreshButton).addComponent(this.showHTMLButton).end().end();
        this.addNorth(mPanel);
        this.updateTimer = new MTimer(MTimer.Format.SECONDS, 1){

            @Override
            protected boolean onTimeout() {
                if (NotepadEditorDesigner.this.automaticRefresh.isSelected()) {
                    NotepadEditorDesigner.this.updateViewer();
                }
                return false;
            }
        };
    }

    void selectHTMLPreview() {
        for (CodePreviewProvider codePreviewProvider : this.preview) {
            if (!(codePreviewProvider instanceof HTMLPreviewProvider)) continue;
            this.preview.setSelectedItem(codePreviewProvider);
            break;
        }
    }

    void updateLater() {
        if (this.updateTimer != null) {
            this.updateTimer.restart();
        }
    }

    void updateViewer() {
        String string;
        CodePreviewProvider codePreviewProvider = this.preview.getSelectedItem();
        if (codePreviewProvider instanceof NonePreview) {
            this.manualRefreshButton.setEnabled(false);
            this.showHTMLButton.setEnabled(false);
        } else {
            this.manualRefreshButton.setEnabled(true);
            this.showHTMLButton.setEnabled(true);
        }
        if (this.viewer == null) {
            return;
        }
        NotepadEditor notepadEditor = (NotepadEditor)this.editorRef.get();
        if (notepadEditor == null) {
            return;
        }
        try {
            string = codePreviewProvider.createHTMLCode(notepadEditor);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            string = null;
        }
        if (string == null) {
            this.viewer.setVisible(false);
        } else {
            this.setHTML(string);
        }
    }

    private static final class NonePreview
    extends CodePreviewProvider {
        @Override
        public String createHTMLCode(NotepadEditor notepadEditor) {
            return null;
        }

        private NonePreview() {
            super("<" + UI._("None") + ">");
        }
    }
}

