/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.text;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.HTMLViewFactory;
import org.makagiga.commons.TK;
import org.makagiga.editors.text.TextEditorDocument;

public final class TextEditorKit
extends HTMLEditorKit {
    static final Map<Color, String> highlightColors = new LinkedHashMap<Color, String>();

    @Override
    public Document createDefaultDocument() {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginRule("a");
        hTMLBuilder.addAttr("color", "blue");
        hTMLBuilder.addAttr("text-decoration", "underline");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("body");
        hTMLBuilder.addAttr("margin", "2");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("h1, h2, h3, h4, h5, h6");
        hTMLBuilder.addAttr("margin-top", "10");
        hTMLBuilder.addAttr("margin-bottom", "0");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("ul, ol");
        hTMLBuilder.addAttr("margin-top", "0");
        hTMLBuilder.addAttr("margin-bottom", "0");
        hTMLBuilder.endRule();
        for (Map.Entry<Color, String> object2 : highlightColors.entrySet()) {
            hTMLBuilder.beginRule("span." + TextEditorKit.makeClassID(object2.getValue()));
            hTMLBuilder.addAttr("background-color", object2.getKey());
            hTMLBuilder.endRule();
        }
        hTMLBuilder.beginRule("span.no_highlight");
        hTMLBuilder.addAttr("background-color", "transparent");
        hTMLBuilder.endRule();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule(hTMLBuilder.toString());
        styleSheet.addStyleSheet(this.getStyleSheet());
        TextEditorDocument textEditorDocument = new TextEditorDocument(styleSheet);
        textEditorDocument.setParser(this.getParser());
        textEditorDocument.setAsynchronousLoadPriority(-1);
        textEditorDocument.setTokenThreshold(100);
        return textEditorDocument;
    }

    @Override
    public ViewFactory getViewFactory() {
        HTMLViewFactory hTMLViewFactory = new HTMLViewFactory(super.getViewFactory());
        hTMLViewFactory.setLoadsSynchronously(true);
        return hTMLViewFactory;
    }

    @Override
    public void write(Writer writer, Document document, int n, int n2) throws BadLocationException, IOException {
        super.write(writer, document, n, n2);
    }

    static String makeClassID(String string) {
        return "highlight_" + TK.toLowerCase(string);
    }

    static {
        highlightColors.put(new Color(14286771), "Green");
        highlightColors.put(new Color(0xFFFFB3), "Yellow");
        highlightColors.put(new Color(0xFFB3B3), "Red");
        highlightColors.put(new Color(0xFFB3FF), "Pink");
        highlightColors.put(new Color(0xB3FFFF), "Cyan");
        highlightColors.put(Color.BLACK, "Black");
    }
}

