/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.todo;

import java.io.Serializable;
import java.util.Map;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MList;
import org.makagiga.commons.MV;
import org.makagiga.commons.Property;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.validator.ListSelectionValidator;
import org.makagiga.console.Console;
import org.makagiga.console.ConsoleCommand;
import org.makagiga.fs.MetaInfo;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.todo.TaskState;
import org.makagiga.tools.summary.SummaryData;

public final class TodoCommand
extends ConsoleCommand {
    private final ActionGroup actionGroup = new ActionGroup();
    private MetaInfo defaultTodoList;

    public TodoCommand() {
        super("todo", "Add and edit todo list via command line");
        this.addAliasName("t");
        this.setSmallIcon("labels/todo");
        Action action = new Action("List tasks"){

            @Override
            protected void onAction(Console console, String string) {
                Console.IO iO = console.getIO();
                SummaryData summaryData = SummaryData.getInstance();
                for (Map.Entry<TaskState, SummaryData.Node> entry : summaryData.getTaskStateMap().entrySet()) {
                    iO.printLine(entry.getKey().toString());
                    iO.printLine();
                    for (SummaryData.Node node : entry.getValue().list(MV.MODEL)) {
                        if (node.getMetaInfo() != TodoCommand.this.defaultTodoList) continue;
                        for (SummaryData.Node node2 : node.list(MV.MODEL)) {
                            iO.printLine(node2.toString());
                        }
                    }
                }
            }
        };
        this.actionGroup.add("l", action);
        this.actionGroup.add("list", action);
        action = new Action("Select Default Todo List"){

            @Override
            protected void onAction(Console console, String string) {
                TodoCommand.this.selectDefaultTodoList(console);
            }
        };
        this.actionGroup.add("s", action);
        this.actionGroup.add("select", action);
        this.actionGroup.addSeparator();
        action = new Action("Add task"){

            @Override
            protected void onAction(Console console, String string) {
            }
        };
        this.actionGroup.add("a", action);
        this.actionGroup.add("add", action);
        action = new Action("Remove task"){

            @Override
            protected void onAction(Console console, String string) {
            }
        };
        this.actionGroup.add("rm", action);
        this.actionGroup.add("remove", action);
        Config config = Config.getDefault();
        String string = config.read("defaultTodoListID", null);
        if (string != null) {
            for (Hit hit : this.startQuery()) {
                if (!string.equals(((MetaInfo)hit.get()).getID())) continue;
                this.defaultTodoList = (MetaInfo)hit.get();
                break;
            }
        }
    }

    @Override
    public Object onCommand(Console console, String ... stringArray) {
        if (stringArray.length == 0) {
            this.onHelp(console);
            return null;
        }
        Console.IO iO = console.getIO();
        Action action = (Action)this.actionGroup.getAction(stringArray[0]);
        if (action == null) {
            iO.printError("Unknown action: " + stringArray[0]);
        } else {
            if (!(this.defaultTodoList != null && this.defaultTodoList.getFile().exists() || this.selectDefaultTodoList(console))) {
                return null;
            }
            action.onAction(console, stringArray.length < 2 ? "" : stringArray[1]);
        }
        return null;
    }

    @Override
    public boolean onHelp(Console console) {
        Console.IO iO = console.getIO();
        int n = 0;
        for (ActionGroup.Item item : this.actionGroup) {
            if (item.getType() != ActionGroup.Type.ACTION) continue;
            n = Math.max(item.getID().length(), n);
        }
        block5: for (ActionGroup.Item item : this.actionGroup) {
            switch (item.getType()) {
                case ACTION: {
                    iO.printLine("%-" + n + "s  %s", item.getID(), item.getAction().getValue("Name"));
                    continue block5;
                }
                case SEPARATOR: {
                    iO.printLine();
                    continue block5;
                }
            }
            throw new WTFError(item.getType());
        }
        return true;
    }

    private boolean selectDefaultTodoList(Console console) {
        MList<Object> mList = new MList<Object>();
        mList.setText("Create a new Todo file first.");
        for (Serializable serializable : this.startQuery()) {
            mList.addItem(((Property)serializable).get());
        }
        if (!mList.isEmpty()) {
            if (this.defaultTodoList != null) {
                mList.setSelectedItem(this.defaultTodoList, true);
            } else {
                mList.setSelectedIndex(0);
            }
        }
        MDialog mDialog = new MDialog(console.getWindowAncestor(), "Select Default Todo List");
        mDialog.getValidatorSupport().add(new ListSelectionValidator(mList));
        mDialog.addNorth(MLabel.createFor(mList, "Available Todo Lists:"));
        mDialog.addCenter(mList);
        mDialog.packFixed();
        if (mDialog.exec()) {
            Serializable serializable;
            serializable = Config.getDefault();
            this.defaultTodoList = (MetaInfo)mList.getSelectedItem();
            ((Config)serializable).write("defaultTodoListID", this.defaultTodoList.getID());
            ((Config)serializable).sync();
            return true;
        }
        return false;
    }

    private Query.Hits startQuery() {
        Query query = new Query(SortMethod.NAME);
        query.add("type", "mgtodo");
        return query.start();
    }

    private static abstract class Action
    extends MAction {
        protected abstract void onAction(Console var1, String var2);

        private Action(String string) {
            super(string);
        }
    }
}

