/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.io.File;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.FS;
import org.makagiga.commons.Item;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.swing.Input;
import org.makagiga.commons.validator.ListSelectionValidator;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSException;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MountManager;
import org.makagiga.tree.Tree;

public final class MountPanel
extends MPanel
implements Lockable,
MDisposable {
    private boolean available;
    private boolean locked;
    private String originalExternalFolder;
    private String parentFS;
    private MButton externalFolderSelector;
    private MButton findButton;
    private MCheckBox mountExternalFolder;
    private MTextField externalFolder;

    public MountPanel(MetaInfo metaInfo, MetaInfo metaInfo2) {
        super(1);
        if (metaInfo != null) {
            this.parentFS = metaInfo.getFS().getID();
        }
        this.mountExternalFolder = new MCheckBox(UI._("Mount External Directory as Virtual Folder")){

            @Override
            protected void onClick() {
                MountPanel.this.setComponentsEnabled(this.isSelected());
            }
        };
        this.add(this.mountExternalFolder);
        this.externalFolder = new MTextField();
        this.externalFolder.setAutoCompletion("mount");
        this.externalFolderSelector = new MButton(UI._("Browse...")){

            @Override
            protected void onClick() {
                MountPanel.this.selectExternalFolder();
            }
        };
        MPanel mPanel = MPanel.createHLabelPanel(this.externalFolder, UI._("External Directory:"));
        mPanel.addEast(this.externalFolderSelector);
        mPanel.limitHeight();
        this.add(mPanel);
        this.addGap();
        this.findButton = new MButton(UI._("Find External Makagiga Folders...")){

            @Override
            protected void onClick() {
                MountPanel.this.findExternalFolders();
            }
        };
        this.add(this.findButton);
        this.setComponentsEnabled(false);
        if (metaInfo2 == null) {
            this.available = true;
        } else if (metaInfo2.isMount()) {
            this.available = true;
            this.mountExternalFolder.setAndRemember(true);
            this.externalFolder.setEditable(true);
            this.externalFolderSelector.setEnabled(true);
            this.externalFolder.setText(metaInfo2.getMount());
            this.findButton.setEnabled(true);
        } else {
            this.available = false;
            this.mountExternalFolder.setAndRemember(false);
            this.mountExternalFolder.setEnabled(false);
            this.externalFolder.setEditable(false);
            this.externalFolderSelector.setEnabled(false);
            this.findButton.setEnabled(false);
        }
        this.originalExternalFolder = this.externalFolder.getText();
        if (this.originalExternalFolder == null) {
            this.originalExternalFolder = "";
        }
    }

    public String getExternalFolder() {
        return this.externalFolder.getText();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isModified() {
        return this.available && (this.mountExternalFolder.isModified() || !this.originalExternalFolder.equals(this.externalFolder.getText()));
    }

    public boolean isMountExternalFolder() {
        return this.mountExternalFolder.isSelected();
    }

    public void saveAutoCompletion() {
        this.externalFolder.saveAutoCompletion();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        if (this.locked == bl) {
            return;
        }
        this.locked = bl;
        this.externalFolderSelector.setEnabled(!this.locked);
        this.mountExternalFolder.setEnabled(!this.locked);
        this.externalFolder.setEditable(!this.locked);
        this.findButton.setEnabled(!this.locked);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.externalFolderSelector = null;
        this.findButton = null;
        this.mountExternalFolder = null;
        this.externalFolder = null;
        return null;
    }

    private void findExternalFolders() {
        final ExternalFolderList externalFolderList = new ExternalFolderList(this.parentFS);
        if (externalFolderList.isEmpty()) {
            MMessage.info(this.getWindowAncestor(), UI._("No folder found. Use the \"{0}\" button to locate folder manually.", this.externalFolderSelector.getText()));
            return;
        }
        MDialog mDialog = new MDialog(this.getWindowAncestor(), UI._("External Folders"), 7);
        final MList<ExternalFolder> mList = new MList<ExternalFolder>();
        mList.setCellRenderer(Item.createListCellRenderer());
        mList.setSingleSelectionMode();
        mList.addAllItems(externalFolderList);
        mList.setSelectedIndex(0);
        mDialog.getValidatorSupport().add(new ListSelectionValidator(mList));
        MSearchPanel mSearchPanel = new MSearchPanel(false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                mList.filter(this, externalFolderList, new MList.Filter<ExternalFolder, String>(this.getText()){

                    @Override
                    public boolean include(ExternalFolder externalFolder) {
                        return TK.containsIgnoreCase(externalFolder.toString(), (String)this.filter);
                    }
                });
            }
        };
        mDialog.addNorth(mSearchPanel);
        mDialog.addCenter(MPanel.createVLabelPanel(mList, UI._("Folders:")));
        mDialog.pack();
        if (mDialog.exec(mSearchPanel)) {
            ExternalFolder externalFolder = (ExternalFolder)mList.getSelectedItem();
            this.setExternalFolder(((File)externalFolder.getValue()).getPath());
        }
    }

    private void selectExternalFolder() {
        File file = Input.getDirectory(this.getWindowAncestor(), UI._("Select a Makagiga folder you want to mount"), "mount");
        if (file != null) {
            this.setExternalFolder(file.getPath());
        }
    }

    private void setComponentsEnabled(boolean bl) {
        this.externalFolder.setEditable(bl);
        this.externalFolderSelector.setEnabled(bl);
        if (bl) {
            this.externalFolder.makeDefault();
        }
        this.findButton.setEnabled(bl);
    }

    private void setExternalFolder(String string) {
        try {
            MountManager.validate(string);
            this.externalFolder.setText(string);
        }
        catch (FSException fSException) {
            MMessage.error(null, fSException);
        }
    }

    private static final class ExternalFolderList
    extends MArrayList<ExternalFolder> {
        private final String parentFS;

        private ExternalFolderList(String string) {
            this.parentFS = string;
            if (OS.isLinux()) {
                this.addUsers("/home");
                this.addUsers("/media/hda1/Documents and Settings");
                this.addUsers("/media/hda1/Users");
            } else if (OS.isWindows()) {
                this.addUsers("C:\\Documents and Settings");
                this.addUsers("C:\\Users");
            }
            this.sort();
        }

        private void addFileSystems(File file, String string) {
            for (File file2 : FS.listFiles(new File(file, "vfs"))) {
                AbstractFS abstractFS;
                if (!file2.isDirectory() || !file2.canRead() || (abstractFS = Tree.getInstance().getFS(file2.getName())) == null || !abstractFS.getID().equals(this.parentFS)) continue;
                this.add(new ExternalFolder(file2, string, abstractFS.getSmallIcon()));
            }
        }

        private void addProfiles(File file) {
            for (File file2 : FS.listFiles(new File(file, "profiles"))) {
                if (!file2.isDirectory() || !file2.canRead()) continue;
                this.addFileSystems(file2, UI._("profile: {0}", file2.getName()));
            }
        }

        private void addUsers(String string) {
            for (File file : FS.listFiles(string)) {
                File file2;
                if (!file.isDirectory() || !file.canRead() || !(file2 = new File(file, ".makagiga")).exists() || !file2.isDirectory() || !file2.canRead()) continue;
                this.addFileSystems(file2, null);
                this.addProfiles(file2);
            }
        }
    }

    private static final class ExternalFolder
    extends Item<File>
    implements Comparable<ExternalFolder> {
        @Override
        public String toString() {
            String string = ((File)this.value).getPath();
            if (this.text != null) {
                string = string + " (" + this.text + ")";
            }
            return string;
        }

        @Override
        public int compareTo(ExternalFolder externalFolder) {
            String string = ((File)this.getValue()).getPath();
            String string2 = ((File)externalFolder.getValue()).getPath();
            return string.compareToIgnoreCase(string2);
        }

        private ExternalFolder(File file, String string, Icon icon) {
            super(file, string);
            this.setIcon(icon);
        }
    }
}

