/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.sb.DefaultPageChecker;
import org.makagiga.feeds.archive.ArchiveItem;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.FeedViewer;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.tree.Tree;

public final class ArticleList
extends MTable<Model> {
    private boolean inUpdate;
    MetaInfo parent;

    public ArticleList() {
        this((FeedViewer)null);
    }

    @Deprecated
    public ArticleList(FeedViewer feedViewer) {
        super(new Model());
        this.setGridVisible(false);
        this.setSelectionMode(0);
        this.getColumnManager().setDefaultColumnOrder(Model.Column.TITLE, Model.Column.DATE, Model.Column.OPEN);
        this.getColumnManager().updateProperties();
        this.setAutoResizeMode(0);
        block6: for (Model.Column column : ((Model)this.getModel()).columnValues) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column.ordinal());
            switch (column) {
                case TITLE: {
                    FeedsFS feedsFS = (FeedsFS)Tree.getInstance().getFS("feeds");
                    tableColumn.setCellRenderer(new ArchiveItemRenderer(feedsFS));
                    tableColumn.setPreferredWidth(400);
                    continue block6;
                }
                case DATE: {
                    tableColumn.setCellRenderer(new DateRenderer());
                    tableColumn.setPreferredWidth(200);
                    continue block6;
                }
                case OPEN: {
                    tableColumn.setCellRenderer(new ButtonRenderer());
                    tableColumn.setPreferredWidth(MIcon.getUISize());
                    continue block6;
                }
                case AUTHOR: {
                    tableColumn.setCellRenderer(new AuthorRenderer());
                    tableColumn.setPreferredWidth(100);
                    continue block6;
                }
                default: {
                    throw new WTFError(column);
                }
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == Model.Column.OPEN.ordinal()) {
            int n4 = this.convertRowIndexToModel(n);
            ArchiveItem archiveItem = (ArchiveItem)((Model)this.getModel()).getRowAt(n4);
            if (archiveItem.isLinkPresent()) {
                MMainWindow.openURI(archiveItem.getLink(), DefaultPageChecker.get());
            } else {
                TK.beep();
            }
            this.doneEdit();
            return null;
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public void scrollToRow(int n) {
        MScrollPane.scrollToNextItem(this, this.getCellRect(n, 0, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<ArchiveItem> list, ArchiveItem archiveItem) {
        try {
            this.inUpdate = true;
            Model model = (Model)this.getModel();
            model.clear();
            for (ArchiveItem archiveItem2 : list) {
                model.addRow(archiveItem2);
            }
            model.fireTableDataChanged();
            int n = model.getRows().indexOf(archiveItem);
            if (n != -1) {
                this.selectRow(this.convertRowIndexToView(n));
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        MetaInfo metaInfo;
        super.valueChanged(listSelectionEvent);
        if (!listSelectionEvent.getValueIsAdjusting() && !this.inUpdate && (metaInfo = this.getMetaInfoAt(this.getSelectedRow())) != null) {
            Tree.getInstance().open(metaInfo);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            int n = -1;
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            n = n2 != -1 ? (this.convertColumnIndexToModel(n2) == Model.Column.OPEN.ordinal() ? 12 : 0) : 0;
            if (n != -1) {
                this.setCursor(Cursor.getPredefinedCursor(n));
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    MetaInfo getMetaInfoAt(int n) {
        if (n < 0 || n > this.getRowCount() - 1) {
            return null;
        }
        int n2 = this.convertRowIndexToModel(n);
        if (n2 == -1) {
            return null;
        }
        ArchiveItem archiveItem = (ArchiveItem)((Model)this.getModel()).getRowAt(n2);
        for (MetaInfo metaInfo : this.parent.list(MV.MODEL)) {
            String string;
            if (!(metaInfo instanceof FeedsFS.ArticleMetaInfo) || (string = ((FeedsFS.ArticleMetaInfo)FeedsFS.ArticleMetaInfo.class.cast(metaInfo)).getArticleID()) == null || !string.equals(archiveItem.getUniqueID())) continue;
            return metaInfo;
        }
        return null;
    }

    private static final class DateRenderer
    extends MRenderer<MDate> {
        private DateRenderer() {
        }

        @Override
        protected void onRender(MDate mDate) {
            this.setText(mDate == null ? "" : mDate.fancyFormat(1, true));
        }
    }

    private static final class ButtonRenderer
    extends MRenderer<String> {
        private ButtonRenderer() {
        }

        @Override
        protected void onRender(String string) {
            MLabel mLabel = this.getLabel();
            mLabel.setHorizontalAlignment(0);
            mLabel.setHorizontalTextPosition(0);
            mLabel.setIcon(MIcon.small("ui/misc"));
            mLabel.setToolTipText(MURLButton.getLinkToolTipText(string));
        }
    }

    private static final class AuthorRenderer
    extends MRenderer<String> {
        private AuthorRenderer() {
        }

        @Override
        protected void onRender(String string) {
            this.setText(string);
        }
    }

    private static final class ArchiveItemRenderer
    extends MRenderer<ArchiveItem> {
        private final FeedsFS fs;
        private final MColorIcon statusIcon;

        @Override
        protected void onRender(ArchiveItem archiveItem) {
            this.getLabel().setIconTextGap(2);
            if (archiveItem.isRead()) {
                this.setIcon(null);
            } else {
                this.statusIcon.setColor(this.fs == null ? FeedsFS.DEFAULT_UNREAD_COLOR : this.fs.getUnreadColor());
                this.setIcon(this.statusIcon);
            }
            this.setText(" " + archiveItem);
        }

        private ArchiveItemRenderer(FeedsFS feedsFS) {
            this.fs = feedsFS;
            this.statusIcon = new MColorIcon(null, MIcon.getSmallSize(), MIcon.getSmallSize(), MColorIcon.Type.RECTANGLE);
        }
    }

    public static final class Model
    extends AbstractListTableModel<ArchiveItem> {
        private final Column[] columnValues = Column.values();

        @Override
        public Object getValueAt(int n, int n2) {
            ArchiveItem archiveItem = (ArchiveItem)this.getRowAt(n);
            Column column = this.columnValues[n2];
            switch (column) {
                case TITLE: {
                    return archiveItem;
                }
                case DATE: {
                    return archiveItem.getDate();
                }
                case OPEN: {
                    return archiveItem.getLink();
                }
                case AUTHOR: {
                    return archiveItem.getAuthor();
                }
            }
            throw new WTFError(column);
        }

        private Model() {
            super(new AbstractListTableModel.ColumnInfo(UI._("Title"), ArchiveItem.class, false, Column.TITLE.name()), new AbstractListTableModel.ColumnInfo(UI._("Date"), MDate.class, false, Column.DATE.name()), new AbstractListTableModel.ColumnInfo(UI._("Open"), String.class, true, Column.OPEN.name()), new AbstractListTableModel.ColumnInfo(UI._("Author"), String.class, false, Column.AUTHOR.name()));
            this.setEventsEnabled(false);
        }

        private static enum Column {
            TITLE,
            DATE,
            OPEN,
            AUTHOR;

        }
    }
}

