/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.makagiga.Vars;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.FeedThread;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.tags.Tags;
import org.makagiga.tree.Tree;

public final class FeedDownloader {
    private static ExecutorService pool;
    private static List<FeedThread> threads;

    public static synchronized void abort(MetaInfo metaInfo) {
        if (threads == null) {
            return;
        }
        for (FeedThread feedThread : threads) {
            if (feedThread.getParent() != metaInfo) continue;
            feedThread.abort();
        }
    }

    public static synchronized void download(FeedsFS feedsFS, MetaInfo metaInfo, boolean bl, String string) {
        FeedDownloader.download(feedsFS, metaInfo, bl, string, false);
    }

    static synchronized void download(FeedsFS feedsFS, MetaInfo metaInfo, boolean bl, String string, boolean bl2) {
        if (pool == null) {
            int n = bl2 ? 1 : Vars.feedsThreads.normalize(1, 16);
            MLogger.debug("feeds", "Using thread pool size of %d", n);
            pool = Executors.newFixedThreadPool(n);
        }
        FeedThread feedThread = new FeedThread(feedsFS, metaInfo, bl, string);
        feedThread.fetchOffline = bl2;
        if (threads == null) {
            threads = new ArrayList<FeedThread>();
        }
        threads.add(feedThread);
        pool.execute(feedThread);
    }

    public static synchronized boolean isActive() {
        return !TK.isEmpty(threads);
    }

    public static synchronized void abortAll() {
        MLogger.debug("feed", "Abort fetch");
        FeedDownloader.setFetchMode(true);
        if (threads != null) {
            for (FeedThread feedThread : threads) {
                feedThread.abort();
            }
            threads = null;
        }
        if (pool != null) {
            pool.shutdown();
            pool = null;
        }
    }

    public static synchronized void finished(FeedThread feedThread) {
        if (threads == null) {
            return;
        }
        if (!threads.remove(feedThread)) {
            MLogger.error("feed", "threads.remove(thread) == false");
        }
        if (threads.isEmpty()) {
            threads = null;
            if (pool != null) {
                pool.shutdown();
                pool = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MLogger.debug("feed", "Fetch complete");
                    FeedDownloader.setFetchMode(true);
                }
            });
        }
    }

    private FeedDownloader() {
    }

    static synchronized void setFetchMode(boolean bl) {
        FeedDownloader.setFetchMode((FeedsFS)Tree.getInstance().getFS("feeds"), bl, false);
    }

    static synchronized void setFetchMode(FeedsFS feedsFS, boolean bl, boolean bl2) {
        String string;
        if (bl) {
            string = null;
            Tags.clearAll();
        } else {
            string = bl2 ? UI._("Loading...") : (FeedDownloader.isActive() ? UI._("Downloading...") : null);
        }
        feedsFS.fetchAllFeedsAction.setIdle(bl);
        Tree.getInstance().setExtraInfo(feedsFS.getRoot(), string);
    }
}

