/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.makagiga.Tabs;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLinkAction;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSplitPane;
import org.makagiga.commons.MTextLabel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWebBrowserPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.icons.Favicon;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorNavigation;
import org.makagiga.editors.EditorStats;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.WebBrowserEditor;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.Enclosure;
import org.makagiga.feeds.FeedUtils;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.feeds.archive.ArchiveChannel;
import org.makagiga.feeds.archive.ArchiveException;
import org.makagiga.feeds.archive.ArchiveItem;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.ArticleList;
import org.makagiga.fs.feeds.FeedThread;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.tree.Tree;

public class FeedViewer
extends WebBrowserEditor
implements EditorConfig,
EditorNavigation,
EditorStats<ChartModel> {
    private ArticleList articleList;
    private boolean blockImages;
    private boolean loadCompleteStory;
    private final CommentsAction commentsAction;
    private Favicon favicon;
    private int readItems;
    private int totalItems;
    private final List<Enclosure> enclosures = new ArrayList<Enclosure>();
    private MButton enclosuresButton;
    private MButton exportButton;
    private final MLabel hostLabel;
    private MSplitPane splitPane;
    private final OpenAction openAction;
    private String feedURL;
    private String oldHost;
    FeedsFS fs;

    public FeedViewer() {
        this.commentsAction = new CommentsAction();
        this.openAction = new OpenAction();
        this.enclosuresButton = new MButton(UI._("Enclosures"), MActionInfo.DOWNLOAD.getIconName()){

            @Override
            protected MMenu onPopupMenu() {
                return FeedViewer.this.createEnclosuresMenu();
            }
        };
        this.enclosuresButton.setEnabled(false);
        this.enclosuresButton.setPopupMenuEnabled(true);
        this.exportButton = new MButton(UI._("Export"), MActionInfo.SAVE.getIconName()){

            @Override
            protected MMenu onPopupMenu() {
                return FeedViewer.this.createExportMenu();
            }
        };
        this.exportButton.setPopupMenuEnabled(true);
        this.hostLabel = MLabel.createSmall(null, null);
        this.browser.setProperty("org.makagiga.commons.WebBrowser.IMAGE_FACTORY_PROPERTY", new FeedUtils.BlockImageFactory());
    }

    public String getLink() {
        return this.openAction.getURL();
    }

    @Override
    public MToolBar.TextPosition getPreferredToolBarTextPosition() {
        return MToolBar.TextPosition.ALONGSIDE_ICONS;
    }

    /*
     * WARNING - void declaration
     */
    public void loadFromMetaInfo(MetaInfo metaInfo, MetaInfo metaInfo2) {
        void var13_21;
        Object object;
        Object object2;
        Archive.ItemInfo itemInfo;
        Object object4;
        MNotification.Message message22;
        if (this.browser instanceof MWebBrowserPanel) {
            this.browser.stop(0);
        }
        if (!(metaInfo2 instanceof FeedsFS.ArticleMetaInfo)) {
            return;
        }
        MNotification mNotification = MNotification.getInstance();
        for (MNotification.Message message22 : mNotification) {
            if (!(message22.getAction() instanceof FeedThread.NotificationAction) || ((FeedThread.Action)(object4 = (FeedThread.NotificationAction)message22.getAction())).getParent() != metaInfo) continue;
            mNotification.hideMessage(message22);
        }
        Config config = metaInfo.getConfig();
        this.blockImages = config.read("x.blockImages", false);
        message22 = this.browser.getProperty("org.makagiga.commons.WebBrowser.IMAGE_FACTORY_PROPERTY");
        if (message22 instanceof FeedUtils.BlockImageFactory) {
            object4 = (FeedUtils.BlockImageFactory)((Object)message22);
            ((FeedUtils.BlockImageFactory)object4).setPolicy(this.blockImages ? FeedUtils.BlockImageFactory.Policy.BLOCK_ALL_IMAGES : FeedUtils.BlockImageFactory.Policy.BLOCK_TRACKING_IMAGES);
        }
        this.loadCompleteStory = MWebBrowserPanel.getUseInternalBrowser() && metaInfo.getProperty("feed.loadCompleteStory", false) != false;
        object4 = (FeedsFS.ArticleMetaInfo)metaInfo2;
        String string = ((FeedsFS.ArticleMetaInfo)object4).getArticleID();
        String string2 = config.read("x.url", null);
        try {
            itemInfo = Archive.getInstance().get(string2, string, true);
        }
        catch (ArchiveException archiveException) {
            MLogger.exception(archiveException);
            return;
        }
        ArchiveChannel archiveChannel = itemInfo.getChannel();
        this.feedURL = string2;
        this.readItems = 0;
        this.totalItems = 0;
        List<ArchiveItem> list = archiveChannel.getItems();
        if (!TK.isEmpty(list)) {
            this.totalItems = list.size();
            for (ArchiveItem object32 : list) {
                if (!object32.isRead()) continue;
                ++this.readItems;
            }
        }
        ArchiveItem archiveItem = itemInfo.getItem();
        this.articleList.parent = metaInfo;
        this.articleList.update(list, archiveItem);
        if (archiveItem.isCommentsLinkPresent()) {
            this.commentsAction.setEnabled(true);
            this.commentsAction.setToolTipText(MLinkButton.getLinkToolTipText(archiveItem.getCommentsLink()));
            this.commentsAction.setURL(archiveItem.getCommentsLink());
        } else {
            this.commentsAction.setEnabled(false);
        }
        if (archiveItem.isLinkPresent() && !TK.isEmpty(archiveItem.getLink())) {
            try {
                URL malformedURLException = new URL(archiveItem.getLink());
                object2 = malformedURLException.getHost();
                if (TK.isChange(object2, this.oldHost)) {
                    if (this.favicon != null) {
                        this.favicon.cancelRequest();
                        this.favicon.setImageObserver(null);
                        this.favicon = null;
                    }
                    this.oldHost = object2;
                    if (this.blockImages) {
                        this.hostLabel.setIcon(null);
                    } else {
                        this.favicon = new Favicon(this.hostLabel, malformedURLException);
                        this.hostLabel.setIcon(this.favicon);
                    }
                }
                this.hostLabel.setText((String)object2);
                this.hostLabel.setVisible(true);
            }
            catch (MalformedURLException malformedURLException) {
                MLogger.exception(malformedURLException);
                this.hostLabel.setVisible(false);
            }
            this.openAction.setEnabled(true);
            this.openAction.setToolTipText(MLinkButton.getLinkToolTipText(archiveItem.getLink()));
            this.openAction.setURL(archiveItem.getLink());
            if (this.commentsAction.isEnabled() && archiveItem.getLink().equals(archiveItem.getCommentsLink())) {
                this.commentsAction.setEnabled(false);
            }
        } else {
            this.hostLabel.setVisible(false);
            this.openAction.setEnabled(false);
            this.openAction.setToolTipText(null);
        }
        String string3 = metaInfo.toString();
        if (archiveChannel.isTitlePresent() && !((String)(object2 = archiveChannel.getTitle())).equals(string3)) {
            String string4 = string3 + " (" + (String)object2 + ")";
        }
        if (this.browser instanceof MWebBrowserPanel && (object2 = (ActionGroup)this.browser.getProperty("org.makagiga.commons.WebBrowser.ACTION_GROUP_PROPERTY")) != null) {
            object = ((ActionGroup)object2).getAction("back");
            if (object != null) {
                object.putValue("org.makagiga.commons.MAction.VISIBLE_KEY", false);
            }
            if ((object = ((ActionGroup)object2).getAction("forward")) != null) {
                object.putValue("org.makagiga.commons.MAction.VISIBLE_KEY", false);
            }
            if ((object = ((ActionGroup)object2).getAction("stop")) != null) {
                object.putValue("org.makagiga.commons.MAction.VISIBLE_KEY", this.loadCompleteStory);
            }
        }
        if (this.loadCompleteStory && archiveItem.isLinkPresent()) {
            try {
                this.browser.setProperty("org.makagiga.commons.WebBrowser.HONOR_DISPLAY_PROPERTIES_PROPERTY", false);
                this.browser.setDocument(archiveItem.getLink());
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                this.loadItem((String)var13_21, archiveItem);
            }
        } else {
            this.loadItem((String)var13_21, archiveItem);
        }
        try {
            object2 = archiveChannel.getBase();
            object = object2 == null ? null : new URL((String)object2);
            this.browser.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", object);
        }
        catch (MalformedURLException malformedURLException) {
            this.browser.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", null);
            MLogger.exception(malformedURLException);
        }
        this.enclosures.clear();
        if (archiveItem.hasEnclosure()) {
            this.enclosures.addAll(archiveItem.getEnclosure());
            this.enclosuresButton.setEnabled(true);
        } else {
            this.enclosuresButton.setEnabled(false);
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        MetaInfo metaInfo = this.getMetaInfo().getParentFolder();
        if (metaInfo != null) {
            Tree.getInstance().setExpanded(metaInfo, false);
        }
        this.enclosuresButton = null;
        this.exportButton = null;
    }

    @Override
    public void loadConfig(Config config) {
        this.loadFont();
        Config config2 = Config.getDefault();
        this.articleList.getColumnManager().readConfig(config2, config, this);
        int n = Math.min(200, this.articleList.getRowHeight() * 6);
        this.splitPane.setDividerLocation(config2.readInt(this.getGlobalEntry("SplitPane.dividerLocation"), n, 0));
    }

    @Override
    public void saveConfig(Config config) {
        Config config2 = Config.getDefault();
        this.articleList.getColumnManager().writeConfig(config2, config, this);
        config2.write(this.getGlobalEntry("SplitPane.dividerLocation"), this.splitPane.getDividerLocation());
    }

    @Override
    public int getNavigationCapabilities() {
        return 54;
    }

    @Override
    public JComponent getNavigationComponent() {
        return null;
    }

    @Override
    public void navigateTo(int n) {
        int n2 = n == 2 ? -1 : 1;
        int n3 = this.articleList.getSelectedRow() + n2;
        MetaInfo metaInfo = this.articleList.getMetaInfoAt(n3);
        if (metaInfo != null) {
            Tree.getInstance().open(metaInfo);
        }
    }

    @Override
    public MessageFormat getPrintFooter(boolean bl) {
        if (bl) {
            return new MessageFormat(TK.centerSqueeze(this.getLink(), 50));
        }
        return null;
    }

    @Override
    public MessageFormat getPrintHeader(boolean bl) {
        if (bl) {
            MessageFormat messageFormat = super.getPrintHeader(bl);
            if (this.loadCompleteStory) {
                return messageFormat;
            }
            return messageFormat == null ? null : new MessageFormat("{0}");
        }
        return null;
    }

    @Override
    public ChartPainter<ChartModel> getStatsChart() {
        ChartModel chartModel = new ChartModel();
        chartModel.setFormat("${text} - ${number} (${percent-int})");
        int n = this.totalItems - this.readItems;
        chartModel.addItem(UI._("Read Articles"), (long)this.readItems, MColor.deriveColor(MColor.WHITE, 0.9f), "ui/ok");
        chartModel.addItem(UI._("Unread Articles"), n, MColor.deriveColor(this.fs == null ? FeedsFS.DEFAULT_UNREAD_COLOR : this.fs.getUnreadColor(), 0.9f));
        ChartPainter<ChartModel> chartPainter = new ChartPainter<ChartModel>(chartModel);
        chartPainter.imageScale.no();
        chartPainter.textAlpha.set(Float.valueOf(0.7f));
        chartPainter.textBackground.set(Color.WHITE);
        chartPainter.textForeground.set(Color.BLACK);
        chartPainter.textDistance.set(-10);
        chartPainter.textLineSize.set(2);
        chartPainter.textPadding.set(5);
        return chartPainter;
    }

    @Override
    public MProperties getStatsProperties() {
        return null;
    }

    @Override
    public String getStatsTitle() {
        MetaInfo metaInfo = this.getMetaInfo().getParentFolder();
        return metaInfo == null ? null : metaInfo.toString();
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        super.zoom(zoomType);
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        if (t instanceof JTextComponent) {
            FeedViewer.saveFont(this.getGlobalEntry("font"), ((JTextComponent)JTextComponent.class.cast(t)).getFont());
            Config.getDefault().sync();
        }
        FeedViewer.applyFont();
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        super.updateMenu(string, mMenu);
        if (string.equals("VIEW_MENU_EDITOR")) {
            mMenu.addSeparator();
            mMenu.add(this.openAction);
            mMenu.add(this.commentsAction);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        super.updateToolBar(string, mToolBar);
        if (string.equals("EDITOR_TOOL_BAR")) {
            mToolBar.addSeparator();
            mToolBar.add(this.openAction, 1);
            mToolBar.add(this.commentsAction);
            mToolBar.addSeparator();
            mToolBar.addButton(this.enclosuresButton);
            mToolBar.addButton(this.exportButton);
            ScriptYourself.install(mToolBar, "feed-viewer");
            mToolBar.addSeparator();
            mToolBar.add(this.hostLabel);
        }
    }

    @Override
    protected void addWebBrowserContainer(JComponent jComponent) {
        this.articleList = new ArticleList();
        this.splitPane = new MSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(new MScrollPane(this.articleList, 2));
        this.splitPane.setBottomComponent(jComponent);
        this.addCenter(this.splitPane);
    }

    private MMenu createEnclosuresMenu() {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        for (Enclosure enclosure : this.enclosures) {
            mMenu.add(new EnclosureAction(enclosure));
        }
        return mMenu;
    }

    private MMenu createExportMenu() {
        MMenu mMenu = new MMenu();
        mMenu.add(new SaveAsAction(this));
        if (this.feedURL != null) {
            mMenu.addSeparator();
            mMenu.add(new AddToAction("Google Reader", "http://www.google.com/reader/view/feed/{0}", this.feedURL));
            mMenu.add(new AddToAction("Netvibes", "http://www.netvibes.com/subscribe.php?url={0}", this.feedURL));
        }
        return mMenu;
    }

    private String createHTMLView(String string, AbstractItem abstractItem) {
        String string2;
        String string3;
        JComponent jComponent = (JComponent)this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        Color color = UI.isNimbus() ? Color.WHITE : UI.getBackground(jComponent);
        hTMLBuilder.beginStyle();
        hTMLBuilder.bestLinkRules(color);
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        hTMLBuilder.beginTag("center");
        String string4 = "background-color: " + ColorProperty.toString(MColor.getDarker(color));
        hTMLBuilder.beginTag("table", "border", "0px", "style", "margin-bottom: 5px; width: 80%");
        StringBuilder stringBuilder = new StringBuilder();
        if (!TK.isEmpty(string)) {
            stringBuilder.append(HTMLBuilder.escape(string));
        }
        if (stringBuilder.length() > 0) {
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", stringBuilder.toString(), "colspan", 2, "style", string4);
            hTMLBuilder.endTag("tr");
        }
        if (TK.isEmpty(string3 = abstractItem.getTitle())) {
            string2 = "<i>" + HTMLBuilder.escape(UI._("No Title")) + "</i>";
        } else {
            string2 = "<b>" + HTMLBuilder.escape(string3) + "</b>";
            if (abstractItem.isLinkPresent() && !TK.isEmpty(abstractItem.getLink())) {
                string2 = "<a href=\"" + HTMLBuilder.escape(abstractItem.getLink()) + "\">" + string2 + "</a>";
            }
        }
        hTMLBuilder.beginTag("tr");
        String string5 = abstractItem.getAuthor();
        if (TK.isEmpty(string5)) {
            hTMLBuilder.doubleTag("td", string2, "colspan", 2, "style", string4);
        } else {
            hTMLBuilder.doubleTag("td", string2, "style", string4);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(UI._("Author: {0}", string5)), "align", "right", "style", string4);
        }
        hTMLBuilder.endTag("tr");
        hTMLBuilder.beginTag("tr");
        hTMLBuilder.beginTag("td", "colspan", 2);
        String string6 = abstractItem.getText();
        if (string6 != null && !string6.equals(string3)) {
            hTMLBuilder.appendLine(string6);
        }
        hTMLBuilder.endTag("td");
        hTMLBuilder.endTag("tr");
        if (abstractItem.isLinkPresent() && !TK.isEmpty(abstractItem.getLink())) {
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.beginTag("td", "colspan", 2, "style", string4);
            hTMLBuilder.doubleTag("a", HTMLBuilder.escape(UI._("Complete Story")), "href", HTMLBuilder.escape(abstractItem.getLink()));
            hTMLBuilder.endTag("td");
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.endTag("table");
        hTMLBuilder.endTag("center");
        hTMLBuilder.endDoc();
        return hTMLBuilder.toString();
    }

    private void loadFont() {
        Font font = FeedViewer.loadFont(this.getGlobalEntry("font"));
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        if (t instanceof JTextComponent) {
            ((JTextComponent)JTextComponent.class.cast(t)).setFont(font);
        }
    }

    private void loadItem(String string, AbstractItem abstractItem) {
        this.browser.setProperty("org.makagiga.commons.WebBrowser.HONOR_DISPLAY_PROPERTIES_PROPERTY", true);
        this.browser.setDocumentFromString(this.createHTMLView(string, abstractItem), null);
    }

    static void applyFont() {
        for (Editor editor : Tabs.getInstance()) {
            if (!(editor instanceof FeedViewer)) continue;
            ((FeedViewer)FeedViewer.class.cast(editor)).loadFont();
        }
    }

    static Font loadFont(String string) {
        Config config = Config.getDefault();
        Font font = config.readFont(Config.getPlatformKey(string), null);
        if (font == null) {
            font = UI.createDefaultFont();
        }
        return font;
    }

    static void saveFont(String string, Font font) {
        Config config = Config.getDefault();
        config.write(Config.getPlatformKey(string), font);
    }

    private static final class SaveAsAction
    extends MDataAction.Weak<FeedViewer> {
        @Override
        public void onAction() {
            FeedViewer feedViewer = (FeedViewer)this.get();
            MFileChooser mFileChooser = MFileChooser.createFileChooser(this.getSourceWindow(), MActionInfo.SAVE_AS.getDialogTitle());
            mFileChooser.addFilter(UI._("Plain Text"), "txt");
            FileFilter fileFilter = mFileChooser.addFilter("HTML", "html");
            mFileChooser.setAutoAddExtension(true);
            mFileChooser.setConfigKey("feed");
            mFileChooser.setSelectedPath(FS.replaceUnsafeCharacters(feedViewer.getMetaInfo().toString()));
            if (!mFileChooser.saveDialog()) {
                return;
            }
            String string = (String)feedViewer.getWebBrowser().getProperty(mFileChooser.getFileFilter() == fileFilter ? "org.makagiga.commons.WebBrowser.TEXT_HTML_CONTENT_PROPERTY" : "org.makagiga.commons.WebBrowser.TEXT_PLAIN_CONTENT_PROPERTY");
            try {
                FS.write(mFileChooser.getSelectedFile(), TK.isEmpty(string) ? "\n" : string);
            }
            catch (IOException iOException) {
                MMessage.error(this.getSourceWindow(), iOException);
            }
        }

        private SaveAsAction(FeedViewer feedViewer) {
            super(feedViewer, MActionInfo.SAVE_AS);
        }
    }

    private static final class OpenAction
    extends MLinkAction {
        private OpenAction() {
            this.setActionInfo(MActionInfo.OPEN_URI);
            this.setEnabled(false);
            this.setSecureOpen(true);
        }
    }

    private static final class EnclosureAction
    extends MLinkAction {
        private final Enclosure enclosure;

        @Override
        public void onAction() {
            MDialog mDialog = new MDialog(this.getSourceWindow(), UI._("Enclosure"), 15){

                @Override
                protected void onUserClick() {
                    MFileChooser mFileChooser = MFileChooser.createFileChooser(this, UI._("Save As"));
                    mFileChooser.setConfigKey("enclosure");
                    try {
                        String string = EnclosureAction.this.enclosure.toURL().getPath();
                        int n = string.lastIndexOf(47);
                        if (n != -1 && n < string.length() - 1) {
                            mFileChooser.setSelectedPath(string.substring(n + 1));
                        }
                        if (mFileChooser.saveDialog()) {
                            EnclosureAction.this.enclosure.download(this, mFileChooser.getSelectedFile());
                        }
                    }
                    catch (IOException iOException) {
                        MMessage.error(EnclosureAction.this.getSourceWindow(), iOException);
                    }
                    this.reject();
                }
            };
            mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.OPEN_URI);
            mDialog.changeButton((AbstractButton)mDialog.getUserButton(), MActionInfo.DOWNLOAD);
            MPanel mPanel = MPanel.createVBoxPanel();
            mPanel.add(MPanel.createHLabelPanel(new MTextLabel(this.enclosure.getURL()), "URL:"));
            mPanel.addGap();
            if (this.enclosure.getLength() > 0L) {
                mPanel.add(MPanel.createHLabelPanel(new MLabel(MFormat.toAutoSize(this.enclosure.getLength())), UI._("File Size:")));
                mPanel.addGap();
            }
            mPanel.add(MPanel.createHLabelPanel(new MLabel(this.enclosure.getType()), UI._("File Type:")));
            mPanel.addGap();
            mPanel.add(MLabel.createSmall(UI._("Do not download/open files from untrusted sources"), MIcon.small("ui/warning")));
            mDialog.addCenter(mPanel);
            mDialog.packFixed();
            mPanel.alignLabels();
            if (mDialog.exec()) {
                super.onAction();
            }
        }

        private EnclosureAction(Enclosure enclosure) {
            this.enclosure = enclosure;
            this.setName(enclosure.toString());
            this.setSecureOpen(true);
            if (enclosure.getURL() == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.setURL(enclosure.getURL());
            }
        }
    }

    private static final class CommentsAction
    extends MLinkAction {
        private CommentsAction() {
            this.setEnabled(false);
            this.setIconName("ui/conversation");
            this.setName(UI._("Comments"));
            this.setSecureOpen(true);
        }
    }

    private static final class AddToAction
    extends MAction {
        private final String feedURL;
        private final String readerURL;

        @Override
        public void onAction() {
            MMainWindow.openURI(this.readerURL, this.feedURL);
        }

        private AddToAction(String string, String string2, String string3) {
            super(UI._("Add to {0}", string));
            this.readerURL = string2;
            this.feedURL = string3;
        }
    }
}

