/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Color;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMultiPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.feeds.archive.ArchiveItem;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.FeedThread;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.tree.Tree;

public final class Filters
extends MMultiPanel<FilterItem>
implements Lockable {
    public Filters() {
        this.setButtonVisible(MMultiPanel.Button.COPY, true);
        this.setConfirmRemove(true);
    }

    public static void apply(List<Criteria> list, ArchiveItem archiveItem, FeedsFS.ArticleMetaInfo articleMetaInfo) {
        Filters.filter(list, null, archiveItem, articleMetaInfo);
    }

    @Deprecated
    public static void filter(List<Criteria> list, String string, ArchiveItem archiveItem, MetaInfo metaInfo) {
        if (list.isEmpty()) {
            return;
        }
        if (metaInfo instanceof FeedsFS.ArticleMetaInfo) {
            for (Criteria criteria : list) {
                criteria.apply(archiveItem, (FeedsFS.ArticleMetaInfo)metaInfo);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isLocked() {
        return !this.isEnabled();
    }

    @Override
    @Deprecated
    public void setLocked(boolean bl) {
        this.setEnabled(!bl);
        for (FilterItem filterItem : this.getItems()) {
            filterItem.setLocked(bl);
        }
    }

    public void load(Config config) {
        List<Criteria> list = Filters.loadCriteria(config);
        if (list.isEmpty()) {
            this.addItem(this.createDefaultItem());
        } else {
            for (Criteria criteria : list) {
                this.addItem(new FilterItem(criteria));
            }
        }
    }

    public static List<Criteria> loadCriteria(Config config) {
        int n = config.readInt("Feed.Filter.count", 0);
        if (n == 0) {
            return Collections.emptyList();
        }
        MArrayList<Criteria> mArrayList = new MArrayList<Criteria>(n);
        for (int i = 0; i < n; ++i) {
            String string = config.read("Feed.Filter.value." + i, null);
            if (string == null) continue;
            try {
                List<String> list = TK.parseArguments(string);
                if (list.size() != 5) continue;
                Criteria criteria = new Criteria();
                criteria.element = EnumProperty.parse(list.get(0), FeedElement.NO_FILTER);
                criteria.operator = EnumProperty.parse(list.get(1), FeedElementOperator.CONTAINS);
                criteria.matchValue = list.get(2);
                criteria.action = EnumProperty.parse(list.get(3), Action.NO_ACTION);
                criteria.actionValue = list.get(4);
                mArrayList.add(criteria);
                continue;
            }
            catch (ParseException parseException) {
                MLogger.exception(parseException);
            }
        }
        return mArrayList;
    }

    public void save(Config config) {
        List list = this.getItems();
        config.removeAllValues(new RegExp("String\\.Feed\\.Filter\\.value\\.[0-9]+"));
        if (list.size() == 1 && ((FilterItem)this.getItems().get(0)).elements.getSelectedItem() == FeedElement.NO_FILTER) {
            config.removeInt("Feed.Filter.count");
        } else {
            config.write("Feed.Filter.count", list.size());
            int n = 0;
            for (FilterItem filterItem : list) {
                config.write("Feed.Filter.value." + n, filterItem.getFilterValue());
                ++n;
            }
        }
        config.sync();
    }

    protected FilterItem createDefaultItem() {
        return new FilterItem(FeedElement.NO_FILTER, FeedElementOperator.CONTAINS, null, Action.NO_ACTION, null);
    }

    @Override
    protected FilterItem onAddItem(MButton mButton) {
        return this.createDefaultItem();
    }

    @Override
    protected FilterItem onCopyItem(FilterItem filterItem) {
        return new FilterItem((FeedElement)((Object)filterItem.elements.getSelectedItem()), (FeedElementOperator)((Object)filterItem.operators.getSelectedItem()), filterItem.elementValue.getText(), (Action)((Object)filterItem.actions.getSelectedItem()), filterItem.getActionValue());
    }

    static final class FiltersAction
    extends MAction {
        @Override
        public void onAction() {
            MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(true);
            Config config = metaInfo.getConfig();
            MDialog mDialog = new MDialog(this.getSourceWindow(), UI._("RSS Filters: {0}", metaInfo), "ui/feed", 71);
            Filters filters = new Filters();
            filters.load(config);
            mDialog.addCenter(new MScrollPane(filters));
            mDialog.setSize(UI.WindowSize.LARGE);
            if (mDialog.exec()) {
                filters.save(config);
                FeedsFS.refresh(metaInfo);
            }
        }

        FiltersAction() {
            super(UI._("RSS Filters..."), "ui/feed");
        }
    }

    public static final class FilterItem
    extends MMultiPanel.PanelItem
    implements Lockable {
        private JComponent actionValue;
        private final MComboBox<Action> actions;
        private final MComboBox<FeedElement> elements;
        private final MComboBox<FeedElementOperator> operators;
        private final MComponent noActionComponent;
        private final MTextField elementValue;

        public FilterItem(Criteria criteria) {
            this(criteria.element, criteria.operator, criteria.matchValue, criteria.action, criteria.action == Action.COLOR ? criteria.getColorValue() : criteria.actionValue);
        }

        public FilterItem(FeedElement feedElement, FeedElementOperator feedElementOperator, String string, Action action, Object object) {
            super(null);
            this.setBackground(UI.getDarker(this.getBackground(), Color.WHITE));
            Color color = UI.getForeground(this);
            this.setBorder(BorderFactory.createLineBorder(color));
            this.elements = new MComboBox();
            this.elements.setToolTipText(UI._("Element"));
            this.elements.addAllItems((FeedElement[])FeedElement.values());
            this.elements.setMouseWheelEventsEnabled(false);
            this.elements.setSelectedItem((Object)feedElement);
            this.operators = new MComboBox<FeedElementOperator>(){

                @Override
                public Dimension getMaximumSize() {
                    return super.getMinimumSize();
                }
            };
            this.operators.setToolTipText(UI._("Operator"));
            this.operators.addAllItems((FeedElementOperator[])new FeedElementOperator[]{FeedElementOperator.CONTAINS, FeedElementOperator.DOES_NOT_CONTAIN, FeedElementOperator.MATCHES_REGEX});
            this.operators.setMouseWheelEventsEnabled(false);
            this.operators.setSelectedItem((Object)feedElementOperator);
            this.elementValue = new MTextField(string);
            this.elementValue.setAutoCompletion("filtervalue");
            this.elementValue.setPromptText(UI._("Enter Value"));
            this.actions = new MComboBox<Action>(){

                @Override
                protected void onSelect() {
                    FilterItem.this.setActionValue((Action)((Object)this.getSelectedItem()), null);
                }
            };
            this.actions.setToolTipText(UI._("Action"));
            this.actions.setEventsEnabled(false);
            this.actions.addAllItems((Action[])new Action[]{Action.NO_ACTION, Action.COLOR, Action.NOTIFICATION, Action.HIDE});
            this.actions.setSelectedItem((Object)action);
            this.actions.setEventsEnabled(true);
            this.actions.setMouseWheelEventsEnabled(false);
            MLabel mLabel = new MLabel(UI._("Element:"));
            mLabel.setHorizontalAlignment(11);
            MLabel mLabel2 = new MLabel(UI._("Action:"));
            mLabel2.setHorizontalAlignment(11);
            this.noActionComponent = new MComponent();
            this.noActionComponent.setVisible(false);
            this.actionValue = this.noActionComponent;
            this.setGroupLayout(true);
            MLayout mLayout = this.getGroupLayout();
            mLayout.setAutoCreateContainerGaps(true);
            mLayout.setDefaultVerticalAlignment(GroupLayout.Alignment.CENTER);
            mLayout.beginRows().beginColumns().addComponent(mLabel).addComponent(this.elements).addComponent(new MLabel(MIcon.small("ui/next"))).addComponent(this.operators).addComponent(new MLabel(MIcon.small("ui/next"))).addComponent(this.elementValue).end().beginColumns().addComponent(mLabel2).addComponent(this.actions).addComponent(this.actionValue).end().end();
            mLayout.linkSize(mLabel, mLabel2);
            mLayout.linkSize(this.elements, this.actions);
            this.setActionValue(action, object);
        }

        public String getFilterValue() {
            this.elementValue.saveAutoCompletion();
            StringBuilder stringBuilder = new StringBuilder(this.elements.getSelectedItem().name());
            stringBuilder.append(' ').append(this.operators.getSelectedItem().name()).append(' ').append(this.quote(this.elementValue.getText())).append(' ').append(this.actions.getSelectedItem().name()).append(' ').append(this.quote(this.getActionValueAsString()));
            return stringBuilder.toString();
        }

        @Override
        @Deprecated
        public boolean isLocked() {
            return !this.isEnabled();
        }

        @Override
        @Deprecated
        public void setLocked(boolean bl) {
            boolean bl2 = !bl;
            this.setEnabled(bl2);
            if (this.actionValue instanceof JTextComponent) {
                ((JTextComponent)JTextComponent.class.cast(this.actionValue)).setEditable(bl2);
            } else if (this.actionValue != null) {
                this.actionValue.setEnabled(bl2);
            }
            if (this.actions != null) {
                this.actions.setEnabled(bl2);
            }
            if (this.elements != null) {
                this.elements.setEnabled(bl2);
            }
            if (this.operators != null) {
                this.operators.setEnabled(bl2);
            }
            if (this.elementValue != null) {
                this.elementValue.setEditable(bl2);
            }
        }

        private Object getActionValue() {
            switch (this.actions.getSelectedItem()) {
                case COLOR: {
                    return ((MSmallColorChooser)MSmallColorChooser.class.cast(this.actionValue)).getColor();
                }
                case NOTIFICATION: {
                    return ((MTextField)MTextField.class.cast(this.actionValue)).getText();
                }
            }
            return null;
        }

        private String getActionValueAsString() {
            switch (this.actions.getSelectedItem()) {
                case COLOR: {
                    return ColorProperty.toString(((MSmallColorChooser)MSmallColorChooser.class.cast(this.actionValue)).getColor());
                }
                case NOTIFICATION: {
                    MTextField mTextField = (MTextField)this.actionValue;
                    mTextField.saveAutoCompletion();
                    return mTextField.getText();
                }
            }
            return "";
        }

        private String quote(String string) {
            if (string == null) {
                string = "";
            } else {
                string = string.replace("\\", "\\\\");
                string = string.replace("\"", "\\\"");
            }
            return "\"" + string + "\"";
        }

        private void setActionValue(Action action, Object object) {
            JComponent jComponent = this.actionValue;
            switch (action) {
                case COLOR: {
                    MSmallColorChooser mSmallColorChooser = new MSmallColorChooser();
                    mSmallColorChooser.getTitleLabel().setVisible(false);
                    mSmallColorChooser.setColor((Color)object);
                    this.actionValue = mSmallColorChooser;
                    break;
                }
                case NOTIFICATION: {
                    MTextField mTextField = new MTextField((String)object);
                    mTextField.setAutoCompletion("filtermessage");
                    mTextField.setPromptText(UI._("Text"));
                    this.actionValue = mTextField;
                    break;
                }
                case HIDE: {
                    this.actionValue = this.noActionComponent;
                    break;
                }
                default: {
                    this.actionValue = this.noActionComponent;
                }
            }
            this.getGroupLayout().replace(jComponent, this.actionValue);
        }
    }

    public static final class Criteria {
        private Action action;
        private Color colorValue;
        private FeedElement element;
        private FeedElementOperator operator;
        private Object actionValue;
        private String matchValue;

        private Criteria() {
        }

        private void apply(ArchiveItem archiveItem, FeedsFS.ArticleMetaInfo articleMetaInfo) {
            boolean bl;
            String string;
            if (this.action == Action.NO_ACTION || this.element == FeedElement.NO_FILTER) {
                return;
            }
            switch (this.element) {
                case TITLE: {
                    string = archiveItem.getTitle();
                    break;
                }
                case TEXT: {
                    string = archiveItem.getText();
                    break;
                }
                case TITLE_OR_TEXT: {
                    if (archiveItem.isTitlePresent()) {
                        string = archiveItem.getTitle() + " " + archiveItem.getText();
                        break;
                    }
                    string = archiveItem.getText();
                    break;
                }
                case LINK: {
                    string = archiveItem.getLink();
                    break;
                }
                case AUTHOR: {
                    string = archiveItem.getAuthor();
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (TK.isEmpty(string)) {
                return;
            }
            switch (this.operator) {
                case CONTAINS: {
                    bl = TK.containsIgnoreCase(string, this.matchValue);
                    break;
                }
                case DOES_NOT_CONTAIN: {
                    bl = !TK.containsIgnoreCase(string, this.matchValue);
                    break;
                }
                case MATCHES_REGEX: {
                    try {
                        bl = string.matches(this.matchValue);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        MLogger.error("feed", patternSyntaxException.getMessage());
                        bl = false;
                    }
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                return;
            }
            switch (this.action) {
                case COLOR: {
                    articleMetaInfo.setArticleColor(this.getColorValue());
                    break;
                }
                case NOTIFICATION: {
                    FeedThread.showNotification(null, new FeedThread.NotificationAction(articleMetaInfo, archiveItem));
                    break;
                }
                case HIDE: {
                    articleMetaInfo.setVisible(false);
                    break;
                }
            }
        }

        private Color getColorValue() {
            if (this.colorValue == null) {
                try {
                    this.colorValue = this.actionValue instanceof Color ? (Color)this.actionValue : ColorProperty.parseColor((String)this.actionValue);
                }
                catch (ParseException parseException) {
                    this.colorValue = MHighlighter.OK_COLOR;
                }
            }
            return this.colorValue;
        }
    }

    public static enum FeedElementOperator {
        CONTAINS(UI._("Contains")),
        DOES_NOT_CONTAIN(UI._("Does Not Contain")),
        EQUALS("Matches"),
        MATCHES_REGEX(UI._("Matches Regular Expression"));

        private String text;

        public String toString() {
            return this.text;
        }

        private FeedElementOperator(String string2) {
            this.text = string2;
        }
    }

    public static enum FeedElement {
        NO_FILTER(UI._("<None>")),
        TITLE(UI._("Title")),
        TEXT(UI._("Text")),
        TITLE_OR_TEXT(UI._("Title or Text")),
        LINK(UI._("Link")),
        AUTHOR(UI._("Author"));

        private String text;

        public String toString() {
            return this.text;
        }

        private FeedElement(String string2) {
            this.text = string2;
        }
    }

    public static enum Action {
        NO_ACTION(UI._("<None>")),
        COLOR(UI._("Set Color")),
        ICON("Set Icon"),
        TAG("Set Tags"),
        NOTIFICATION(UI._("Show Message")),
        MESSAGE("Show Message"),
        BEEP("Beep Sound"),
        HIDE(UI._("Hide Article")),
        OPEN_EXTERNAL_BROWSER("Open Link in External Browser"),
        OPEN_NEW_TAB("Open Link in a New Tab");

        private String text;

        public String toString() {
            return this.text;
        }

        private Action(String string2) {
            this.text = string2;
        }
    }
}

