/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.trash;

import java.io.File;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSDynamic;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.tree.Tree;

public final class TrashFS
extends AbstractFS
implements FSDynamic,
PluginMenu {
    private boolean emptyInfo = true;
    private boolean needScan = true;

    @Override
    public boolean canImport(MetaInfo metaInfo) {
        if (metaInfo == null) {
            return false;
        }
        if (metaInfo.getFS() == this) {
            return false;
        }
        return metaInfo.isAnyFolder() || metaInfo.isFile();
    }

    public void emptyTrash() {
        FS.deleteDir(this.getDirectory(), false);
        Tree.getInstance().removeAllChildren(this.getRoot(), false);
        this.getRoot().reload();
        this.updateInfo(true);
    }

    @Override
    public boolean importMetaInfos(MetaInfo metaInfo, boolean bl, List<MetaInfo> list) {
        if (this.needScan) {
            try {
                this.dynamic(0, metaInfo);
            }
            catch (FSException fSException) {
                MMessage.error(null, fSException);
            }
        }
        boolean bl2 = super.importMetaInfos(metaInfo, bl, list);
        this.updateInfo(false);
        return bl2;
    }

    public static boolean isInTrash(MetaInfo metaInfo) {
        List<TreeNode> list;
        AbstractFS abstractFS = Tree.getInstance().getFS("trash");
        return abstractFS != null && (list = metaInfo.getPathList()).size() > 1 && list.get(1) == abstractFS.getRoot();
    }

    public boolean isTrashEmpty() {
        String[] stringArray = FS.listNames(this.getDirectory());
        if (stringArray.length == 0) {
            return true;
        }
        return stringArray.length == 1 && stringArray[0].equals(".properties");
    }

    @Override
    public boolean dynamic(int n, MetaInfo metaInfo) throws FSException {
        if (this.needScan && metaInfo.isFSRoot()) {
            this.needScan = false;
            this.scan(null);
            return true;
        }
        return false;
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("TREE_MENU")) {
            mMenu.add(new EmptyTrashAction());
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
    }

    protected TrashFS(PluginInfo pluginInfo) throws FSException {
        super(pluginInfo, "trash", UI._("Trash"));
        new MTimer(MTimer.Format.SECONDS, 5){

            @Override
            protected boolean onTimeout() {
                TrashFS.this.updateInfo(TrashFS.this.isTrashEmpty());
                this.setDelay(MTimer.Format.MINUTES, 1);
                return true;
            }
        }.start();
    }

    @Override
    protected void processFile(MetaInfo metaInfo, File file) {
        String string = file.getPath();
        String string2 = FS.getExtension(string);
        if ("properties".equals(string2)) {
            if (!FS.exists(string = FSHelper.removePropertiesSuffix(string))) {
                this.processDynamicFolder(null, metaInfo, file);
            }
        } else {
            this.processTreeFile(null, metaInfo, file);
        }
    }

    private void updateInfo(boolean bl) {
        if (bl == this.emptyInfo) {
            return;
        }
        this.emptyInfo = bl;
        if (this.emptyInfo) {
            this.setIconName("emptytrashcan");
        } else {
            this.setIconName("fulltrashcan");
        }
        this.getRoot().refresh(false);
    }

    private final class EmptyTrashAction
    extends MAction {
        @Override
        public void onAction() {
            TrashFS.this.emptyTrash();
        }

        public EmptyTrashAction() {
            super(UI._("Empty Trash Bin"), "ui/delete");
            this.setEnabled(!TrashFS.this.isTrashEmpty());
        }
    }
}

