/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.internetsearch.wikipedia;

import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.UI;
import org.makagiga.form.PropertyPanel;
import org.makagiga.internetsearch.InternetSearchPlugin;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.web.wiki.WikiPanel;

public final class WikipediaInternetSearchPlugin
extends InternetSearchPlugin
implements PluginOptions<MPanel> {
    private final BooleanProperty externalBrowser = new BooleanProperty();

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        super.onInit(config, pluginInfo);
        Config config2 = Config.getDefault();
        this.externalBrowser.set(config2.read(this.getGlobalEntry("useExternalBrowser"), (Boolean)this.externalBrowser.getDefaultValue()));
    }

    @Override
    public void search(String string, boolean bl) throws PluginException {
        if (((Boolean)this.externalBrowser.get()).booleanValue()) {
            super.search(string, bl);
        } else {
            String string2 = this.getName() + " - " + this.getInfo().shortDescription;
            WikiPanel.openURI(null, this.createURL(string), string2);
        }
    }

    @Override
    public MPanel createPluginConfigPanel() {
        PropertyPanel propertyPanel = new PropertyPanel();
        propertyPanel.bind(this.externalBrowser, UI._("Open results in external browser"));
        return propertyPanel;
    }

    @Override
    @Deprecated
    public boolean isVisibleInOptionsDialog() {
        return false;
    }

    @Override
    public void loadPluginConfig(MPanel mPanel) {
    }

    @Override
    public void savePluginConfig(MPanel mPanel) {
        Config config = Config.getDefault();
        config.write(this.getGlobalEntry("useExternalBrowser"), (Boolean)this.externalBrowser.get());
    }
}

