/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;

public final class PluginClassLoader
extends URLClassLoader {
    private final Object verifiedLock = new Object();
    private static Set<String> unsigned;
    private final String id;
    private TriBoolean verified = TriBoolean.UNDEFINED;
    PluginInfo pluginInfo;

    @Deprecated
    public static PluginClassLoader create(String string, List<URL> list) {
        return PluginClassLoader.create(string, list.toArray(new URL[list.size()]));
    }

    public static PluginClassLoader create(final String string, final URL ... uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return new PluginClassLoader(string, uRLArray);
        }
        return AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

            @Override
            public PluginClassLoader run() {
                return new PluginClassLoader(string, uRLArray);
            }
        });
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getPluginDescription() {
        return this.pluginInfo == null ? "" : (String)this.pluginInfo.shortDescription.get();
    }

    public MIcon getPluginIcon() {
        return this.pluginInfo == null ? null : this.pluginInfo.getIcon();
    }

    public String getPluginName() {
        return this.pluginInfo == null ? "" : this.pluginInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVerified() {
        Object object = this.verifiedLock;
        synchronized (object) {
            if (this.verified.isUndefined()) {
                this.verified = AccessController.doPrivileged(new PrivilegedAction<TriBoolean>(){

                    @Override
                    public TriBoolean run() {
                        return PluginClassLoader.this.doVerifyPrivileged();
                    }
                });
            }
            return this.verified.isTrue();
        }
    }

    private PluginClassLoader(String string, URL ... uRLArray) {
        super(uRLArray);
        this.id = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TriBoolean doVerifyPrivileged() {
        try {
            if (unsigned == null) {
                unsigned = TK.newHashSet("META-INF/HTTP___M.DSA", "META-INF/HTTP___M.SF", "META-INF/MANIFEST.MF");
            }
            PublicKey publicKey = PluginManager.getInstance().getPublicKey();
            for (URL uRL : this.getURLs()) {
                MLogger.info("core", "Testing plugin Jar file: %s", uRL);
                ZipFile zipFile = null;
                try {
                    zipFile = new JarFile(new File(uRL.toURI()));
                    Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        InputStream inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                        try {
                            FS.copyStream(inputStream, null);
                        }
                        finally {
                            FS.close(inputStream);
                        }
                        Certificate[] certificateArray = jarEntry.getCertificates();
                        if (certificateArray != null) {
                            for (Certificate certificate : certificateArray) {
                                certificate.verify(publicKey);
                            }
                            continue;
                        }
                        String string = jarEntry.getName();
                        if (jarEntry.isDirectory() || unsigned.contains(string)) continue;
                        throw new Exception("No certificate for plugin Jar file entry: " + uRL + "/" + string);
                    }
                }
                finally {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
            }
            return TriBoolean.TRUE;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return TriBoolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void loadServices(Class<T> clazz, MArrayList<T> mArrayList) throws Exception {
        URL uRL = this.findResource("META-INF/services/" + clazz.getName());
        if (uRL == null) {
            return;
        }
        FS.TextReader textReader = null;
        try {
            textReader = FS.getUTF8Reader(uRL.openStream());
            for (String string : textReader) {
                if ((string = string.trim()).isEmpty() || string.charAt(0) == '#') continue;
                Object t = TK.newInstance(string, this);
                mArrayList.add(t);
            }
        }
        finally {
            FS.close(textReader);
        }
    }
}

