/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.test;

import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;
import org.makagiga.commons.Uninstantiable;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class Validator
extends AbstractProcessor {
    private Elements elementUtils;
    private Messager messager;
    private Types typeUtils;
    private CommentChecker commentChecker;
    private PropertyChecker propertyChecker;
    private UninstantiableChecker uninstantiableChecker;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.elementUtils = processingEnvironment.getElementUtils();
        this.messager = processingEnvironment.getMessager();
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.commentChecker = new CommentChecker();
        this.propertyChecker = new PropertyChecker();
        this.uninstantiableChecker = new UninstantiableChecker();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getRootElements()) {
            this.commentChecker.scan(element);
            this.propertyChecker.scan(element);
            this.uninstantiableChecker.scan(element);
        }
        return true;
    }

    private final class UninstantiableChecker
    extends ElementScanner6<Void, Void> {
        private UninstantiableChecker() {
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, Void void_) {
            Set<Modifier> set;
            Uninstantiable uninstantiable;
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR && (uninstantiable = executableElement.getAnnotation(Uninstantiable.class)) != null && !(set = executableElement.getModifiers()).contains((Object)Modifier.PRIVATE)) {
                Validator.this.messager.printMessage(Diagnostic.Kind.WARNING, "\"Uninstantiable\" constructor should be private", executableElement);
            }
            return (Void)super.visitExecutable(executableElement, void_);
        }
    }

    private final class PropertyChecker
    extends ElementScanner6<Void, Void> {
        private TypeMirror propertyType;

        @Override
        public Void visitVariable(VariableElement variableElement, Void void_) {
            Set<Modifier> set;
            if (variableElement.getKind() == ElementKind.FIELD && Validator.this.typeUtils.isSubtype(variableElement.asType(), this.propertyType) && (set = variableElement.getModifiers()).contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.FINAL)) {
                Validator.this.messager.printMessage(Diagnostic.Kind.WARNING, "Public property field should be \"final\"", variableElement);
            }
            return (Void)super.visitVariable(variableElement, void_);
        }

        private PropertyChecker() {
            this.propertyType = Validator.this.elementUtils.getTypeElement(Property.class.getName()).asType();
            this.propertyType = Validator.this.typeUtils.erasure(this.propertyType);
        }
    }

    private final class CommentChecker
    extends ElementScanner6<Void, Void> {
        private CommentChecker() {
        }

        @Override
        public Void scan(Element element, Void void_) {
            String string = Validator.this.elementUtils.getDocComment(element);
            if (string != null) {
                if (string.trim().isEmpty()) {
                    Validator.this.messager.printMessage(Diagnostic.Kind.WARNING, "Javadoc comment is empty", element);
                }
                if (TK.containsIgnoreCase(string, "note:", Locale.ENGLISH)) {
                    Validator.this.messager.printMessage(Diagnostic.Kind.NOTE, "Javadoc: Use \"@mg.note\" command instead of \"NOTE:\" text", element);
                }
                if (string.contains("@i ")) {
                    Validator.this.messager.printMessage(Diagnostic.Kind.WARNING, "Javadoc: Use <i> and </i> HTML tags instead of \"@i\" command", element);
                }
            }
            return (Void)super.scan(element, void_);
        }
    }
}

