/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Color;
import java.io.Serializable;
import java.util.EnumSet;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MObject;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.pim.PIMData;
import org.makagiga.pim.calendar.ICalendar;
import org.makagiga.pim.calendar.ICalendarTodo;
import org.makagiga.pim.calendar.VCalendarTodo;
import org.makagiga.todo.Priority;
import org.makagiga.todo.TaskState;

public class Task
implements Cloneable,
Searchable<String>,
Serializable {
    private int complete;
    private MDate completeDateTime = MDate.invalid();
    private MDate dateTime = MDate.invalid();
    private MDate startDateTime = MDate.invalid();
    private Priority priority = Priority.DEFAULT;
    private String category = "";
    private String summary = "";

    public Task() {
    }

    @Deprecated
    public Task(Task task) {
        this(task.summary, task.priority, task.complete, task.dateTime, task.startDateTime, task.completeDateTime);
        this.setCategory(task.category);
    }

    @Deprecated
    public Task(String string, Priority priority, int n, MDate mDate, MDate mDate2, MDate mDate3) {
        this(string, priority, n, mDate.getTime(), mDate2.getTime(), mDate3.getTime());
    }

    public Task(String string, Priority priority, int n, long l, long l2, long l3) {
        this.priority = priority;
        this.complete = TK.range(n, 0, 0, 100);
        this.setSummary(string);
        this.setDateTime(l);
        this.setStartDateTime(l2);
        this.setCompleteDateTime(l3);
    }

    public boolean equals(Object object) {
        switch (MObject.maybeEquals(this, object)) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        Task task = (Task)object;
        return this.complete == task.complete && this.priority == task.priority && this.category.equals(task.category) && this.summary.equals(task.summary) && this.dateTime.equals(task.dateTime) && this.startDateTime.equals(task.startDateTime) && this.completeDateTime.equals(task.completeDateTime);
    }

    public String formatComplete() {
        return Task.formatComplete(this.complete);
    }

    public static String formatComplete(int n) {
        return n + "%";
    }

    public String formatDate() {
        return this.formatDate(this.getDateTimeState());
    }

    public String formatDate(TaskState taskState) {
        return Task.formatDate(this.dateTime, taskState);
    }

    public static String formatDate(MDate mDate, TaskState taskState) {
        if (!mDate.isValid()) {
            return "";
        }
        if (taskState == TaskState.TODAY || taskState == TaskState.TOMORROW) {
            return mDate.fancyFormat(2, true);
        }
        return mDate.formatDateTime(2, 3);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string == null ? "" : string;
    }

    public MDate getCompleteDateTime() {
        return this.completeDateTime;
    }

    public void setCompleteDateTime(long l) {
        this.completeDateTime.setTime(l);
    }

    public void setCompleteDateTime(MDate mDate) {
        this.completeDateTime.setTime(mDate);
    }

    public MDate getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(long l) {
        this.dateTime.setTime(l);
    }

    public void setDateTime(MDate mDate) {
        this.dateTime.setTime(mDate);
    }

    public TaskState getDateTimeState() {
        return Task.getTaskState(this.dateTime, MDate.now());
    }

    public static TaskState getDateTimeState(MDate mDate) {
        return Task.getTaskState(mDate, MDate.now());
    }

    public TaskState getDateTimeStateNow(MDate mDate) {
        return Task.getTaskState(this.dateTime, mDate);
    }

    public MDate getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(long l) {
        this.startDateTime.setTime(l);
    }

    public void setStartDateTime(MDate mDate) {
        this.startDateTime.setTime(mDate);
    }

    public int getComplete() {
        return this.complete;
    }

    public void setComplete(int n) {
        this.complete = n;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string == null ? "" : string;
    }

    public String getToolTipTable(boolean bl) {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginTag("table", "cellpadding", 2, "cellspacing", 1);
        if (bl) {
            hTMLBuilder.beginTag("tr");
            String string = this.summary.isEmpty() ? "<i>" + HTMLBuilder.escape(UI._("No Summary")) + "</i>" : HTMLBuilder.escape(TK.centerSqueeze(this.summary, 100));
            hTMLBuilder.doubleTag("td", string, "colspan", 2);
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.beginTag("tr");
        Priority priority = this.getPriority();
        Color color = priority.getColor();
        String string = String.format("background-color: %s; color: %s; text-align: center", color == null ? "white" : ColorProperty.toString(color), ColorProperty.toString(Color.BLACK));
        hTMLBuilder.doubleTag("td", HTMLBuilder.escape(priority.toString()), "style", string);
        hTMLBuilder.doubleTag("td", HTMLBuilder.escape(this.formatComplete()), "style", "text-align: center");
        hTMLBuilder.endTag("tr");
        long l = this.dateTime.getTime();
        if (l != 0L) {
            long l2;
            TaskState taskState = this.getDateTimeState();
            String string2 = "background-color: " + ColorProperty.toString(taskState.getColorForPaint()) + "; color: " + ColorProperty.toString(Color.BLACK);
            hTMLBuilder.beginTag("tr", "style", string2);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(this.formatDate()), new Object[0]);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(taskState.toString()), "style", "text-align: center");
            hTMLBuilder.endTag("tr");
            if ((taskState == TaskState.LATER || taskState == TaskState.TODAY || taskState == TaskState.TOMORROW) && (l2 = l - MDate.currentTime()) > 0L) {
                long l3 = l2 / 1000L;
                long l4 = l3 / 3600L;
                long l5 = l3 / 60L % 60L;
                long l6 = l4 / 24L;
                String string3 = UI._("Time To: {0} day(s), {1} hour(s), {2} minute(s)", l6, l4 - l6 * 24L, l5);
                hTMLBuilder.beginTag("tr");
                hTMLBuilder.doubleTag("td", HTMLBuilder.escape(string3), "colspan", 2);
                hTMLBuilder.endTag("tr");
            }
        }
        if (!this.category.isEmpty()) {
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", UI._("Category: {0}", HTMLBuilder.escape(this.category), "colspan", 2), new Object[0]);
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.endTag("table");
        return hTMLBuilder.toString();
    }

    public String getToolTipText() {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        hTMLBuilder.beginDoc();
        hTMLBuilder.setIndentLevel(0);
        hTMLBuilder.appendLine(this.getToolTipTable(true));
        hTMLBuilder.endDoc();
        return hTMLBuilder.toString();
    }

    public int hashCode() {
        int n = MObject.hashCode(new Object[]{this.priority, this.category, this.summary, this.dateTime, this.startDateTime, this.completeDateTime});
        n = 31 * n + this.complete;
        return n;
    }

    public boolean isDone() {
        return this.complete == 100;
    }

    @Deprecated
    public boolean matches(String string, boolean bl) {
        if (TK.isEmpty(string)) {
            return true;
        }
        if (bl ? this.getSummary().contains(string) || this.getCategory().contains(string) : TK.containsIgnoreCase(this.getSummary(), string) || TK.containsIgnoreCase(this.getCategory(), string)) {
            return true;
        }
        MDate mDate = this.getDateTime();
        MDate mDate2 = this.getCompleteDateTime();
        MDate mDate3 = this.getStartDateTime();
        if (bl) {
            return mDate.isValid() && Task.formatDate(mDate, TaskState.UNKNOWN).contains(string) || mDate2.isValid() && Task.formatDate(mDate2, TaskState.UNKNOWN).contains(string) || mDate3.isValid() && Task.formatDate(mDate3, TaskState.UNKNOWN).contains(string);
        }
        return mDate.isValid() && TK.containsIgnoreCase(Task.formatDate(mDate, TaskState.UNKNOWN), string) || mDate2.isValid() && TK.containsIgnoreCase(Task.formatDate(mDate2, TaskState.UNKNOWN), string) || mDate3.isValid() && TK.containsIgnoreCase(Task.formatDate(mDate3, TaskState.UNKNOWN), string);
    }

    public static long parseDateTime(String string) {
        if (TK.isEmpty(string)) {
            return 0L;
        }
        if (string.contains("T")) {
            MDate mDate = MDate.parseRFC3339(string);
            return mDate == null ? 0L : mDate.getTime();
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        String string = n < 1 ? "%s\t%s\t%s%s%s\n" : "%-" + n + "s\t%s\t%s%s%s\n";
        return String.format(string, new Object[]{this.summary, this.priority, this.formatComplete(), this.dateTime.isValid() ? '\t' + this.formatDate(TaskState.UNKNOWN) : "", !this.category.isEmpty() ? '\t' + this.category : ""});
    }

    public VCalendarTodo toVCalendarTodo(PIMData<?> pIMData) {
        VCalendarTodo vCalendarTodo = pIMData instanceof ICalendar ? new ICalendarTodo() : new VCalendarTodo();
        int n = this.summary.indexOf(10);
        if (n != -1) {
            vCalendarTodo.setTextValue("SUMMARY", this.summary.substring(0, n));
            vCalendarTodo.setTextValue("DESCRIPTION", this.summary);
        } else {
            vCalendarTodo.setTextValue("SUMMARY", this.summary);
        }
        if (this.dateTime.isValid()) {
            vCalendarTodo.setDateValue("DUE", this.dateTime);
        }
        vCalendarTodo.setDateValue("LAST-MODIFIED", MDate.now());
        vCalendarTodo.setValue("PRIORITY", this.priorityMapping(this.getPriority()));
        vCalendarTodo.setValue("STATUS", this.isDone() ? "COMPLETED" : "NEEDS ACTION");
        return vCalendarTodo;
    }

    public Object clone() {
        try {
            Task task = (Task)super.clone();
            task.completeDateTime = (MDate)this.completeDateTime.clone();
            task.dateTime = (MDate)this.dateTime.clone();
            task.startDateTime = (MDate)this.startDateTime.clone();
            return task;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WTFError(cloneNotSupportedException);
        }
    }

    @Override
    public boolean matches(String string, EnumSet<Searchable.Matches> enumSet) {
        return this.matches(string, enumSet.contains((Object)Searchable.Matches.CASE_SENSITIVE));
    }

    private static TaskState getTaskState(MDate mDate, MDate mDate2) {
        switch (mDate.compareDateTime(mDate2, true)) {
            case BEFORE: {
                return TaskState.OVERDUE;
            }
            case TODAY: {
                return TaskState.TODAY;
            }
            case AFTER: {
                return TaskState.LATER;
            }
            case TOMORROW: {
                return TaskState.TOMORROW;
            }
        }
        return TaskState.UNKNOWN;
    }

    private int priorityMapping(Priority priority) {
        switch (priority) {
            case VERY_LOW: {
                return 9;
            }
            case LOW: {
                return 7;
            }
            case NORMAL: {
                return 0;
            }
            case HIGH: {
                return 3;
            }
            case VERY_HIGH: {
                return 1;
            }
        }
        throw new WTFError(priority);
    }
}

