/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.FS;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTextLabel;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.plugins.PluginClassLoader;
import org.makagiga.plugins.PluginPermission;

public final class Armor
extends Policy {
    private final AccessMap savedAccess;
    private final AccessMap temporaryAccess = new AccessMap(null);
    private static boolean initDone;
    private final Semaphore securityDialogSemaphore = new Semaphore(1, true);
    private final Set<String> awtPermissionAllow;
    private final Set<String> extJars = new HashSet<String>();
    private final Set<String> propertyPermissionAllowRead;
    private final Set<String> propertyPermissionAllowWrite;
    private final Set<String> runtimePermissionAllow;
    private static String baseLocation;
    private final String pluginsDir;
    private final String searchFSDir;
    private final String templatesDir;
    private final String tmpDir;
    private final String widgetsDir;
    private final String FIND_FILES_PLUGIN = "{4105008a-8906-4730-9241-86d8946e5c73}";
    private final String TEMPLATES_PLUGIN = "{8c5f441b-adbf-4de0-84f7-eb0a9f874dad}";

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        String string = Armor.toAbsolutePath(codeSource);
        if (string == null) {
            Armor.log("WARNING: \"null\" location for \"%s\" %s", protectionDomain.getCodeSource(), permission);
            return false;
        }
        Access access = this.doImplies(string, protectionDomain, permission);
        switch (access) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return this.askUser(string, protectionDomain, permission);
            }
        }
        throw new WTFError(access);
    }

    public static synchronized void init() {
        if (initDone) {
            throw new IllegalStateException("Armor alread initialized");
        }
        initDone = true;
        try {
            Armor.log("INFO: Initializing...", new Object[0]);
            CodeSource codeSource = Armor.class.getProtectionDomain().getCodeSource();
            baseLocation = Armor.toAbsolutePath(codeSource);
            Armor.log("INFO: Base location: %s", baseLocation);
            Policy.setPolicy(new Armor());
            System.setSecurityManager(new SecurityManager());
            try {
                UI.invokeAndWait(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        UI.setLookAndFeel(UI.getPreferredLookAndFeelClassName());
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    private Armor() throws IOException {
        String string = System.getProperty("java.ext.dirs");
        for (String string2 : TK.fastSplit(string, File.pathSeparatorChar)) {
            Armor.log("INFO: Found extension directory: %s", string2);
            for (File file : FS.listFiles(new File(string2), new FS.FileExtensionFilter("jar"))) {
                Armor.log("\tAdd extension: %s", file);
                this.extJars.add(file.getPath());
            }
        }
        this.savedAccess = new AccessMap(new File(FS.makeConfigPath("policy.xml")));
        this.savedAccess.load();
        this.awtPermissionAllow = TK.newHashSet("accessEventQueue", "showWindowWithoutWarningBanner");
        this.propertyPermissionAllowRead = TK.newHashSet("file.separator", "java.version", "java.vm.specification.vendor", "line.separator", "os.name", "os.version", "path.separator", "user.timezone", "com.sun.xml.internal.bind.v2.bytecode.ClassTailor.noOptimize", "com.sun.xml.internal.bind.v2.runtime.Coordinator.debugTableNPE", "com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl.fastBoot", "elementAttributeLimit", "entityExpansionLimit", "maxOccurLimit", "org.joda.time.DateTimeZone.NameProvider", "org.joda.time.DateTimeZone.Provider", "org.joda.time.tz.CachedDateTimeZone.size", "lipstikLF.menuBar", "lipstikLF.menuFont", "lipstikLF.theme");
        this.propertyPermissionAllowWrite = TK.newHashSet("lipstikLF.menuBar", "lipstikLF.menuFont", "lipstikLF.theme");
        this.runtimePermissionAllow = TK.newHashSet("accessClassInPackage.sun.swing", "accessClassInPackage.com.sun.xml.internal.bind.v2", "accessClassInPackage.com.sun.xml.internal.bind.v2.runtime.reflect");
        this.pluginsDir = FS.makeConfigPath("plugins");
        this.searchFSDir = FS.makeConfigPath(FS.makePath("vfs", "search"));
        this.templatesDir = FS.makeConfigPath("templates");
        this.tmpDir = System.getProperty("java.io.tmpdir");
        this.widgetsDir = FS.makeConfigPath("desktop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean askUser(final String string, final ProtectionDomain protectionDomain, final Permission permission) {
        final PermissionKey permissionKey = new PermissionKey(string, permission);
        Access access = (Access)((Object)this.savedAccess.get(permissionKey));
        if (access == Access.ALLOW) {
            this.logALLOW(protectionDomain, permission, "User/Saved");
            return true;
        }
        if (access == Access.DENY) {
            this.logDENY(protectionDomain, permission, "User/Saved");
            return false;
        }
        access = (Access)((Object)this.temporaryAccess.get(permissionKey));
        if (access == Access.ALLOW) {
            this.logALLOW(protectionDomain, permission, "User/Temporary");
            return true;
        }
        Armor.log("ASK USER:\n\t\tlocation=\"%s\"\n\t\tpermission=\"%s\"\n\t\tdomain class loader=\"%s\"\n\t\tcurrent thread=\"%s\"", string, permission, protectionDomain.getClassLoader(), Thread.currentThread());
        MLogger.trace();
        this.securityDialogSemaphore.acquireUninterruptibly();
        try {
            boolean bl = UI.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SecurityDialog securityDialog = new SecurityDialog(string, protectionDomain, permission);
                    boolean bl = securityDialog.exec();
                    if (securityDialog.doNotAskAgain.isSelected()) {
                        Armor.this.temporaryAccess.put(permissionKey, bl ? Access.ALLOW : Access.DENY);
                        Armor.this.savedAccess.put(permissionKey, bl ? Access.ALLOW : Access.DENY);
                        Armor.this.savedAccess.save();
                    } else if (bl) {
                        Armor.this.temporaryAccess.put(permissionKey, Access.ALLOW);
                    }
                    return bl;
                }
            });
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.securityDialogSemaphore.release();
        }
    }

    private boolean canAccessAllFiles(String string, String string2) {
        PermissionKey permissionKey = new PermissionKey(string, new FilePermission("<<ALL FILES>>", string2));
        return this.savedAccess.get(permissionKey) == Access.ALLOW || this.temporaryAccess.get(permissionKey) == Access.ALLOW;
    }

    private Access doImplies(String string, ProtectionDomain protectionDomain, Permission permission) {
        if (permission instanceof PluginPermission && "addToSystemClassPath".equals(permission.getActions())) {
            return Access.DENY;
        }
        if (this.isFileInDir(string, baseLocation)) {
            return Access.ALLOW;
        }
        if (this.extJars.contains(string)) {
            return this.logALLOW(protectionDomain, permission, "Java Extension Jar");
        }
        ClassLoader classLoader = protectionDomain.getClassLoader();
        PluginClassLoader pluginClassLoader = classLoader instanceof PluginClassLoader ? (PluginClassLoader)classLoader : null;
        String string2 = permission.getName();
        if (permission instanceof AWTPermission) {
            if (this.awtPermissionAllow.contains(string2)) {
                return this.logALLOW(protectionDomain, permission, "AWT White List");
            }
            if ("accessClipboard".equals(string2) && this.isCallFromMethod(protectionDomain, "javax.swing.text.DefaultCaret.getSystemSelection", false)) {
                return this.logALLOW(protectionDomain, permission, "AWT White List: sun.awt.X11.XToolkit.getSystemSelection");
            }
        } else if (permission instanceof FilePermission) {
            String string3 = permission.getActions();
            if ("delete".equals(string3)) {
                if (!TK.isEmpty(this.tmpDir) && this.isFileInDir(string2, this.tmpDir)) {
                    return this.logALLOW(protectionDomain, permission, "Temporary Directory");
                }
                if (pluginClassLoader != null) {
                    if (this.isPluginConfigDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory");
                    }
                    if (this.isFileInTemplatesDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory (Templates)");
                    }
                }
            } else if ("read".equals(string3)) {
                if (!string2.equals("<<ALL FILES>>") && this.canAccessAllFiles(string, string3 + ",write")) {
                    return this.logALLOW(protectionDomain, permission, "Can Read <<ALL FILES>>");
                }
                if (string2.endsWith(File.separator + "META-INF" + File.separator + "trident-plugin.properties")) {
                    return Access.ALLOW;
                }
                if (pluginClassLoader != null) {
                    String string4 = FS.makePath(this.pluginsDir, pluginClassLoader.getID());
                    if (this.isFileInDir(string2, string4)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Install Directory");
                    }
                    if (this.isPluginConfigDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory");
                    }
                    if (this.isFileInSearchFSDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory (Find Files)");
                    }
                    if (this.isFileInTemplatesDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory (Templates)");
                    }
                }
            } else if ("write".equals(string3)) {
                if (!string2.equals("<<ALL FILES>>") && this.canAccessAllFiles(string, "read," + string3)) {
                    return this.logALLOW(protectionDomain, permission, "Can Write <<ALL FILES>>");
                }
                if (!TK.isEmpty(this.tmpDir) && this.isFileInDir(string2, this.tmpDir)) {
                    return this.logALLOW(protectionDomain, permission, "Temporary Directory");
                }
                if (pluginClassLoader != null) {
                    if (this.isPluginConfigDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory");
                    }
                    String string5 = FS.makePath(this.widgetsDir, pluginClassLoader.getID());
                    if (string2.startsWith(string5)) {
                        return this.logALLOW(protectionDomain, permission, "Widget Settings Directory");
                    }
                    if (this.isFileInSearchFSDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory (Find Files)");
                    }
                    if (this.isFileInTemplatesDir(pluginClassLoader, string2)) {
                        return this.logALLOW(protectionDomain, permission, "Plugin Config Directory (Templates)");
                    }
                }
            }
        } else if (permission instanceof PropertyPermission) {
            String string6 = permission.getActions();
            if ("read".equals(string6)) {
                if (this.propertyPermissionAllowRead.contains(string2)) {
                    return this.logALLOW(protectionDomain, permission, "Property White List");
                }
                if (string2.equals("user.home") && this.canAccessAllFiles(string, "read,write")) {
                    return this.logALLOW(protectionDomain, permission, "Can Read/Write <<ALL FILES>>");
                }
            } else if ("write".equals(string6) && this.propertyPermissionAllowWrite.contains(string2)) {
                return this.logALLOW(protectionDomain, permission, "Property White List");
            }
        } else if (permission instanceof RuntimePermission) {
            if (this.runtimePermissionAllow.contains(string2)) {
                return this.logALLOW(protectionDomain, permission, "Runtime White List");
            }
            if ("modifyThreadGroup".equals(string2) && this.isCallFromMethod(protectionDomain, "sun.awt.image.ImageFetcher.createFetchers", false)) {
                return this.logALLOW(protectionDomain, permission, "Runtime White List: sun.awt.image.ImageFetcher.createFetchers");
            }
        } else if (permission instanceof MGuardedObject.Permission && pluginClassLoader != null) {
            MGuardedObject.Permission permission2 = (MGuardedObject.Permission)permission;
            if ("{4105008a-8906-4730-9241-86d8946e5c73}".equals(pluginClassLoader.getID()) && permission2.getName().equals("org.makagiga.search.Index")) {
                return this.logALLOW(protectionDomain, permission, "Find Files Plugin");
            }
        }
        if (pluginClassLoader != null && pluginClassLoader.isVerified()) {
            return this.logALLOW(protectionDomain, permission, "Plugin verified using Public Key");
        }
        if (classLoader != null && classLoader == ClassLoader.getSystemClassLoader()) {
            return this.logALLOW(protectionDomain, permission, "System Class Loader");
        }
        return Access.DENY;
    }

    private String formatCodeSource(CodeSource codeSource) {
        if (codeSource == null) {
            return "<NULL CODE SOURCE>";
        }
        URL uRL = codeSource.getLocation();
        if (uRL == null) {
            return "<NULL CODE LOCATION>";
        }
        return uRL.toString();
    }

    private boolean isCallFromMethod(ProtectionDomain protectionDomain, String string, boolean bl) {
        StackTraceElement[] stackTraceElementArray;
        Thread thread = Thread.currentThread();
        if (bl && ((stackTraceElementArray = protectionDomain.getClassLoader()) == null || stackTraceElementArray != thread.getContextClassLoader())) {
            return false;
        }
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            if (!(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName()).equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileInDir(String string, String string2) {
        return (string + File.separator).startsWith(string2 + File.separator);
    }

    private boolean isFileInSearchFSDir(PluginClassLoader pluginClassLoader, String string) {
        return "{4105008a-8906-4730-9241-86d8946e5c73}".equals(pluginClassLoader.getID()) && this.isFileInDir(string, this.searchFSDir);
    }

    private boolean isFileInTemplatesDir(PluginClassLoader pluginClassLoader, String string) {
        return "{8c5f441b-adbf-4de0-84f7-eb0a9f874dad}".equals(pluginClassLoader.getID()) && this.isFileInDir(string, this.templatesDir);
    }

    private boolean isPluginConfigDir(PluginClassLoader pluginClassLoader, String string) {
        String string2 = FS.makeConfigPath(pluginClassLoader.getID());
        return this.isFileInDir(string, string2);
    }

    private static void log(String string, Object ... objectArray) {
        System.err.printf("\tMAKAGIGA ARMOR: " + string + "\n", objectArray);
    }

    private Access logALLOW(ProtectionDomain protectionDomain, Permission permission, String string) {
        Armor.log("ALLOW [%s]: %s %s", string, this.formatCodeSource(protectionDomain.getCodeSource()), permission);
        return Access.ALLOW;
    }

    private Access logDENY(ProtectionDomain protectionDomain, Permission permission, String string) {
        Armor.log("DENY [%s]: %s %s", string, this.formatCodeSource(protectionDomain.getCodeSource()), permission);
        return Access.DENY;
    }

    private static String toAbsolutePath(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        try {
            File file = new File(codeSource.getLocation().toURI()).getAbsoluteFile();
            return file.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            Armor.log("ERROR: Invalid location URI: %s (%s)", codeSource.getLocation(), uRISyntaxException.getMessage());
            return null;
        }
    }

    private static final class TestPermission
    extends BasicPermission {
        private TestPermission() {
            super("test");
        }
    }

    private static final class SecurityDialog
    extends MDialog {
        private final MCheckBox doNotAskAgain;

        private SecurityDialog(String string, ProtectionDomain protectionDomain, Permission permission) {
            super(null, UI._("Security Manager"), "ui/locked", 4103);
            String string2;
            Object object;
            Object object2;
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Allow"));
            this.changeButton((AbstractButton)this.getCancelButton(), UI._("Deny"));
            this.doNotAskAgain = new MCheckBox("Do not ask again");
            MPanel mPanel = this.getMainPanel();
            mPanel.setVBoxLayout();
            ClassLoader classLoader = protectionDomain.getClassLoader();
            if (classLoader instanceof PluginClassLoader) {
                mPanel.addHeader("Plugin");
                object2 = (PluginClassLoader)classLoader;
                mPanel.add(new MLabel(((PluginClassLoader)object2).getPluginName(), ((PluginClassLoader)object2).getPluginIcon()));
                mPanel.add(new MLabel(((PluginClassLoader)object2).getPluginDescription()));
            }
            object2 = null;
            PermissionInfo.ThreatLevel threatLevel = PermissionInfo.ThreatLevel.UNKNOWN;
            if (permission instanceof PermissionInfo) {
                object = (PermissionInfo)((Object)permission);
                string2 = object.getPermissionDescription();
                threatLevel = object.getThreatLevel();
            } else if (permission instanceof AWTPermission) {
                if ("accessClipboard".equals(permission.getName())) {
                    string2 = "Clipboard";
                    object2 = MIcon.stock("ui/cut");
                    threatLevel = PermissionInfo.ThreatLevel.MEDIUM;
                } else {
                    string2 = "User Interface";
                    threatLevel = PermissionInfo.ThreatLevel.HIGH;
                }
            } else if (permission instanceof FilePermission) {
                string2 = UI._("File System");
                object2 = MIcon.stock("ui/folder");
                threatLevel = PermissionInfo.ThreatLevel.HIGH;
            } else if (permission instanceof PropertyPermission || permission instanceof RuntimePermission) {
                string2 = UI._("System");
                threatLevel = PermissionInfo.ThreatLevel.HIGH;
            } else if (permission instanceof SocketPermission) {
                string2 = UI._("Internet/Network");
                object2 = MIcon.stock("ui/internet");
                threatLevel = PermissionInfo.ThreatLevel.MEDIUM;
            } else {
                string2 = permission.getClass().getName();
                object2 = MIcon.stock("ui/question");
            }
            if (object2 == null) {
                object2 = MIcon.stock("ui/misc");
            }
            mPanel.addHeader(string2).setIcon((Icon)object2);
            if (threatLevel == PermissionInfo.ThreatLevel.MEDIUM || threatLevel == PermissionInfo.ThreatLevel.HIGH) {
                mPanel.addHeader("Threat Level");
                mPanel.add(new MLabel(threatLevel.toString(), threatLevel.getIconName()));
            }
            mPanel.addHeader("Details");
            object = new MTextLabel(permission.getName());
            mPanel.add(MPanel.createHLabelPanel((JComponent)object, "Name:"));
            MTextLabel mTextLabel = new MTextLabel(permission.getActions());
            mPanel.add(MPanel.createHLabelPanel(mTextLabel, "Actions:"));
            mPanel.add(MPanel.createHLabelPanel(new MTextLabel(string), "Location:"));
            mPanel.addContentGap();
            mPanel.add(this.doNotAskAgain);
            this.packFixed(UI.WindowSize.MEDIUM);
            mPanel.alignLabels();
        }
    }

    private static final class PermissionKey {
        private final int hash;
        private final String actions;
        private final String name;
        private final String location;
        private final String permissionClassName;

        public boolean equals(Object object) {
            switch (MObject.maybeEquals(this, object)) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            PermissionKey permissionKey = (PermissionKey)object;
            return MObject.safeEquals(this.location, permissionKey.location) && MObject.safeEquals(this.actions, permissionKey.actions) && MObject.safeEquals(this.name, permissionKey.name) && MObject.safeEquals(this.permissionClassName, permissionKey.permissionClassName);
        }

        public int hashCode() {
            return this.hash;
        }

        private PermissionKey(String string, String string2, String string3, String string4) {
            this.location = TK.checkNull(string);
            this.permissionClassName = TK.checkNull(string2);
            this.name = TK.checkNull(string3);
            this.actions = string4 == null ? "" : string4;
            this.hash = MObject.hashCode(string, string4, string3, string2);
        }

        private PermissionKey(String string, Permission permission) {
            this(string, permission.getClass().getName(), permission.getName(), permission.getActions());
        }
    }

    private static final class AccessMap
    extends Hashtable<PermissionKey, Access> {
        private final File configFile;

        private AccessMap(File file) {
            this.configFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() throws IOException {
            SimpleXMLReader simpleXMLReader = null;
            try {
                simpleXMLReader = new SimpleXMLReader(){
                    private boolean inPolicy;

                    @Override
                    protected void onStart(String string) {
                        if (!this.inPolicy && "policy".equals(string)) {
                            this.inPolicy = true;
                        } else if (this.inPolicy) {
                            Access access;
                            if ("allow".equals(string)) {
                                access = Access.ALLOW;
                            } else if ("deny".equals(string)) {
                                access = Access.DENY;
                            } else {
                                Armor.log("WARNING: Unknown access name: %s", new Object[]{string});
                                return;
                            }
                            AccessMap.this.put(new PermissionKey(this.getStringAttribute("code"), this.getStringAttribute("permission"), this.getStringAttribute("name"), this.getStringAttribute("actions")), access);
                        }
                    }
                };
                simpleXMLReader.read(this.configFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Armor.log("INFO: No policy properties found: %s", new Object[]{this.configFile});
                }
                catch (Throwable throwable) {
                    FS.close(simpleXMLReader);
                    throw throwable;
                }
                FS.close(simpleXMLReader);
            }
            FS.close(simpleXMLReader);
        }

        private void save() throws IOException {
            final XMLBuilder xMLBuilder = new XMLBuilder();
            xMLBuilder.beginTag("policy", "version", 1);
            for (Map.Entry entry : this.entrySet()) {
                PermissionKey permissionKey = (PermissionKey)entry.getKey();
                String string = entry.getValue() == Access.ALLOW ? "allow" : "deny";
                xMLBuilder.singleTag(string, "code", TK.escapeXML(permissionKey.location), "permission", TK.escapeXML(permissionKey.permissionClassName), "name", TK.escapeXML(permissionKey.name), "actions", TK.escapeXML(permissionKey.actions));
            }
            xMLBuilder.endTag("policy");
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        xMLBuilder.save(AccessMap.this.configFile.getPath());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof IOException) {
                    throw (IOException)privilegedActionException.getCause();
                }
                privilegedActionException.printStackTrace();
            }
        }
    }

    private static enum Access {
        ALLOW,
        DENY;

    }
}

