/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import org.makagiga.Vars;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.OS;
import org.makagiga.commons.UI;

public final class GeneralSettings
extends MSettingsPage {
    private MTextField browserField;

    public GeneralSettings() {
        super(UI._("General"));
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.browserField = null;
    }

    @Override
    protected void onInit() {
        this.bind(MApplication.confirmExit, UI._("Confirm Exit"));
        this.addSeparator(UI._("System Tray"));
        this.bind(UI.systemTray, UI._("Show System Tray Icon"));
        this.bind(UI.hideMainWindowInTray, UI._("Hide Main Window in Tray"));
        this.bind(UI.systemTray, "selected", UI.hideMainWindowInTray, "enabled");
        if (!OS.isWindows()) {
            this.addContentGap();
            MPanel mPanel = (MPanel)this.bind(OS.openCommand, UI._("Open Links/Files With:"));
            this.browserField = (MTextField)GeneralSettings.getWrappedView(mPanel);
            this.browserField.setAutoCompletion("browser");
            UI.setHTMLHelp(this.browserField, UI._("Enter a command used to open external files<br>and web addresses.<br>Leave this field empty to use default command."));
            MURLButton mURLButton = new MURLButton(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onClick() {
                    String string = OS.openCommand.get();
                    try {
                        String string2 = GeneralSettings.this.browserField.getText();
                        OS.openCommand.set(string2);
                        super.onClick();
                    }
                    finally {
                        OS.openCommand.set(string);
                    }
                }
            };
            mURLButton.setText(UI._("Test"));
            mURLButton.setURL(MApplication.getHomePage());
            mPanel.addEast(mURLButton);
        }
    }

    @Override
    protected void onOK() {
        if (this.browserField != null) {
            this.browserField.saveAutoCompletion();
        }
    }

    public static final class Advanced
    extends MSettingsPage {
        public Advanced() {
            super(UI._("General"));
            this.bindInteger(Vars.autosaveTimeout, UI._("Autosave every (minutes):"), 1, Integer.MAX_VALUE);
        }

        @Override
        protected void onOK() {
        }
    }
}

