/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.event.DocumentEvent;
import org.makagiga.MainWindow;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MList;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoList;
import org.makagiga.tree.Tree;

public final class QuickOpenDialog
extends MDialog {
    private final MetaInfoList list;
    private final MSearchPanel filter;

    public QuickOpenDialog(Window window) {
        super(window, UI._("Quick Open"), MActionInfo.OPEN.getIconName());
        this.changeButton((AbstractButton)this.getOKButton(), UI._("Open"));
        this.setSize(UI.WindowSize.MEDIUM);
        this.filter = new MSearchPanel(false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                QuickOpenDialog.this.updateList();
            }
        };
        this.filter.setHintText(UI._("Search for name, content, comment, ..."));
        this.filter.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (TK.isKeyStroke(keyEvent, 38)) {
                    QuickOpenDialog.this.list.selectRelativeIndex(-1, true);
                } else if (TK.isKeyStroke(keyEvent, 40)) {
                    QuickOpenDialog.this.list.selectRelativeIndex(1, true);
                }
            }
        });
        this.addNorth(this.filter);
        this.list = new MetaInfoList(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.TRIGGER) {
                    QuickOpenDialog.this.getOKButton().doClick();
                }
            }
        };
        this.addCenter(MPanel.createVLabelPanel(this.list, UI._("Matching Items:")));
        this.updateList();
    }

    public MTextFieldPanel getFilter() {
        return this.filter;
    }

    public MList<MetaInfo> getList() {
        return this.list;
    }

    private void updateList() {
        this.list.refresh(this.filter.getText());
        if (this.filter.getText().isEmpty()) {
            this.filter.setState(MTextFieldPanel.State.NORMAL);
        } else if (this.list.isEmpty()) {
            this.filter.setState(MTextFieldPanel.State.ERROR);
            this.list.setText(UI._("No item found: \"{0}\"", this.filter.getText()));
        } else {
            this.filter.setState(MTextFieldPanel.State.OK);
            this.list.setText(null);
        }
    }

    public static final class Action
    extends MApplication.OpenAction {
        public Action() {
            this.setHTMLHelp(UI._("Search for name, content, comment, ..."));
            this.setName(UI._("Quick Open..."));
        }

        @Override
        public void onAction() {
            MetaInfo metaInfo;
            QuickOpenDialog quickOpenDialog = new QuickOpenDialog((Window)MainWindow.getInstance());
            if (quickOpenDialog.exec(quickOpenDialog.getFilter().getTextField()) && (metaInfo = quickOpenDialog.getList().getSelectedItem()) != null) {
                Tree.getInstance().open(metaInfo);
            }
        }
    }
}

