/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.stats;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JToolTip;
import org.makagiga.MainWindow;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MToolBar;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorStats;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.tools.stats.StatsPanel;

public final class StatsPlugin
extends AbstractPlugin<Object>
implements PluginMenu {
    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("TOOLS_MENU")) {
            mMenu.add(this.getDefaultAction());
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        Editor<?> editor;
        if (string.equals("EDITOR_TOOL_BAR") && (editor = Editor.getCurrentEditor()) instanceof EditorStats && !"org.makagiga.fs.feeds.FeedViewer".equals(editor.getClass().getName())) {
            ToolBarButton toolBarButton = new ToolBarButton(this.getDefaultAction());
            mToolBar.addButton(toolBarButton);
            toolBarButton.setToolTipText("");
        }
    }

    @Override
    protected void onDefaultAction(PluginAction pluginAction) {
        String string = this.getName();
        StatsPanel.showDialog((Window)MainWindow.getInstance(), string, (Icon)MIcon.stock("ui/chart"), 36, new StatsPanel(string));
    }

    private static final class ToolBarButton
    extends MButton {
        @Override
        public JToolTip createToolTip() {
            ChartPainter chartPainter;
            JToolTip jToolTip = super.createToolTip();
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor instanceof EditorStats && (chartPainter = ((EditorStats)EditorStats.class.cast(editor)).getStatsChart()) != null) {
                int n = 150 + (Integer)chartPainter.outlineSize.get() * 2;
                jToolTip.setLayout(new BorderLayout());
                chartPainter.chartSize.set(n);
                chartPainter.shadowVisible.no();
                chartPainter.textVisible.no();
                MLabel mLabel = new MLabel(chartPainter.toBufferedImage(n += 100, n, null));
                jToolTip.add(mLabel);
                jToolTip.setPreferredSize(mLabel.getPreferredSize());
            }
            return jToolTip;
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(0, this.getHeight() + 5);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return "";
        }

        private ToolBarButton(PluginAction pluginAction) {
            super(pluginAction);
        }
    }
}

