/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.summary;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import org.makagiga.Vars;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.ItemStatus;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTree;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryListRenderer;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.Painter;
import org.makagiga.commons.print.PrintDialog;
import org.makagiga.commons.print.TextPrintInfo;
import org.makagiga.editors.todo.TodoEditorPlugin;
import org.makagiga.fs.MetaInfo;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskState;
import org.makagiga.tools.summary.SummaryData;

public final class SummaryTree
extends MTree<SummaryData.Node, SummaryData> {
    private final ActionGroup actionGroup;
    boolean autoExpandMode;

    public ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    @Override
    protected void onAction(InputEvent inputEvent, int n) {
        SummaryData.Node node = (SummaryData.Node)this.getItemAtRow(n);
        if (node != null && node.getTask() != null) {
            MetaInfo metaInfo = ((SummaryData.Node)SummaryData.Node.class.cast(node.getParentItem())).getMetaInfo();
            TodoEditorPlugin.showTask(metaInfo, node.getTask());
        } else {
            super.onAction(inputEvent, n);
        }
    }

    private boolean canPrint(SummaryData.Node node, boolean bl) {
        return !(bl ? !this.isExpanded(node) || node.isEmpty(MV.VIEW) : node.isEmpty(MV.MODEL));
    }

    private void print(Window window, boolean bl) {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        hTMLBuilder.beginStyle();
        hTMLBuilder.beginRule("body");
        hTMLBuilder.addAttr("background-color", Color.WHITE);
        hTMLBuilder.addAttr("color", Color.BLACK);
        hTMLBuilder.endRule();
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        boolean bl2 = !bl;
        boolean bl3 = (Boolean)Vars.summaryPrintDateTime.get();
        for (SummaryData.Node object2 : ((SummaryData)this.getModel()).getTaskStateMap().values()) {
            if (!this.canPrint(object2, bl2)) continue;
            boolean textPrintInfo = false;
            for (SummaryData.Node node : object2.list(MV.VIEW)) {
                if (!this.canPrint(node, bl2)) continue;
                if (!textPrintInfo) {
                    textPrintInfo = true;
                    hTMLBuilder.addHeader(1, HTMLBuilder.escape(object2.toString()));
                }
                hTMLBuilder.addHeader(2, HTMLBuilder.escape(node.toString()));
                hTMLBuilder.beginTag("ul");
                for (SummaryData.Node node2 : node.list(MV.VIEW)) {
                    Task task = node2.getTask();
                    String string = bl3 ? (task.getDateTime().isValid() ? " <i>[" + HTMLBuilder.escape(task.formatDate(TaskState.UNKNOWN)) + "]</i>" : "") : "";
                    Priority priority = task.getPriority();
                    String string2 = (priority == Priority.NORMAL ? "" : "<i>[" + HTMLBuilder.escape(priority.toString()) + "]</i> ") + HTMLBuilder.escape(task.getSummary()) + string;
                    String string3 = task.isDone() ? "text-decoration: line-through" : "";
                    hTMLBuilder.doubleTag("li", string2, "style", string3);
                }
                hTMLBuilder.endTag("ul");
            }
        }
        hTMLBuilder.endDoc();
        String string = UI._("Task Summary");
        String string4 = TextPrintInfo.getCurrentDateTime();
        TextPrintInfo textPrintInfo = TextPrintInfo.html(string, hTMLBuilder, string, string4);
        PrintDialog printDialog = new PrintDialog(window, textPrintInfo);
        printDialog.exec();
    }

    SummaryTree() {
        super(SummaryData.getInstance());
        this.setCellRenderer(new Renderer());
        this.setRootVisible(false);
        this.setRowHeight(-1);
        this.setShowsRootHandles(false);
        this.setSingleSelectionMode();
        this.actionGroup = new ActionGroup();
        this.actionGroup.add("print", new PrintAction(false, UI._("Print Visible (expanded) Items...")));
        this.actionGroup.add("print-all", new PrintAction(true, UI._("Print All Items...")));
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                this.block(treeExpansionEvent, TriBoolean.TRUE, TriBoolean.FALSE);
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                this.block(treeExpansionEvent, TriBoolean.FALSE, TriBoolean.TRUE);
            }

            private void block(TreeExpansionEvent treeExpansionEvent, TriBoolean triBoolean, TriBoolean triBoolean2) throws ExpandVetoException {
                SummaryData.Node node = (SummaryData.Node)treeExpansionEvent.getPath().getLastPathComponent();
                if (SummaryTree.this.autoExpandMode && node.userExpanded == triBoolean) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
                if (!SummaryTree.this.autoExpandMode) {
                    node.userExpanded = triBoolean2;
                }
            }
        });
    }

    private final class PrintAction
    extends MDataAction<Boolean> {
        @Override
        public void onAction() {
            boolean bl = (Boolean)this.getData();
            SummaryTree.this.print(this.getSourceWindow(), bl);
        }

        private PrintAction(boolean bl, String string) {
            super(Boolean.valueOf(bl), string, MActionInfo.PRINT.getIconName());
        }
    }

    public static final class Renderer
    extends MRenderer<SummaryData.Node> {
        private CategoryListRenderer.View category;
        private final EnumMap<TaskState, GlassPainter> painterCache = new EnumMap(TaskState.class);
        private Font italicFont;
        private Font normalFont;
        private ItemStatus count;
        private MLabel complete;
        private MLabel dateTime;
        private MLabel priorityLabel;
        private MLabel summary;

        @Override
        public JComponent createView() {
            this.category = new CategoryListRenderer.View();
            this.category.setOpaque(false);
            this.complete = new MLabel();
            this.complete.setStyle("font-weight: bold");
            this.dateTime = new MLabel();
            this.priorityLabel = new MLabel();
            this.summary = new MLabel();
            this.normalFont = UI.getFont(this.summary);
            UI.setHTMLEnabled(this.summary, false);
            this.count = new ItemStatus(this.normalFont);
            MRenderer.OptimizedPanel optimizedPanel = new MRenderer.OptimizedPanel(true);
            MLayout mLayout = optimizedPanel.getGroupLayout();
            mLayout.beginRows().beginColumns().addComponent((Component)this.priorityLabel, true).addComponent((Component)this.complete, true).addComponent((Component)this.summary, true).addComponent((Component)this.count, true).end().addComponent(this.dateTime).addComponent(this.category).end();
            return optimizedPanel;
        }

        @Override
        protected void onRender(SummaryData.Node node) {
            this.category.setForeground(null);
            this.complete.setForeground(null);
            this.dateTime.setForeground(null);
            this.priorityLabel.setForeground(null);
            this.summary.setForeground(null);
            this.category.setVisible(false);
            this.complete.setVisible(false);
            this.count.setVisible(false);
            this.dateTime.setVisible(false);
            this.priorityLabel.setVisible(false);
            this.summary.setFont(this.normalFont);
            this.summary.setIcon(null);
            this.summary.setStrikeThrough(false);
            Painter painter = null;
            Task task = node.getTask();
            if (task != null) {
                Object object;
                String string = task.getCategory();
                if (!string.isEmpty()) {
                    object = new CategoryList(CategoryManager.getSharedInstance(), string);
                    this.category.setCategoryList((CategoryList)object);
                    this.category.setVisible(true);
                }
                if (!this.isSelected()) {
                    object = (SummaryData.Node)node.getParent();
                    int n = -1;
                    if (object != null) {
                        n = ((MTreeItem)object).getIndex(node, MV.VIEW);
                    }
                    if (n == -1) {
                        n = this.getRow();
                    }
                    Color color = this.getTree().getBackground();
                    Color color2 = UI.getLookAndFeelType().hasAlternateTreeRowColor() || UI.isGTK() ? color : Renderer.getRowColor(n, color);
                    this.getView().setBackground(color2);
                    this.getView().setOpaque(!MObject.safeEquals(color2, color));
                }
                if (((String)(object = task.getSummary())).isEmpty()) {
                    if (this.italicFont == null) {
                        this.italicFont = this.normalFont.deriveFont(2);
                    }
                    this.summary.setFont(this.italicFont);
                    this.summary.setText(UI._("No Summary"));
                } else {
                    this.summary.setText(TK.rightSqueeze((String)object, 128));
                }
                this.summary.setStrikeThrough(task.isDone());
                Priority priority = task.getPriority();
                if (priority != Priority.NORMAL) {
                    this.priorityLabel.setIcon(priority.getSmallColorIcon());
                    this.priorityLabel.setVisible(true);
                }
                if (task.getComplete() > 0) {
                    this.complete.setText(task.formatComplete());
                    this.complete.setVisible(true);
                }
                this.dateTime.setText(task.formatDate());
                this.dateTime.setVisible(true);
            } else if (node.getMetaInfo() != null) {
                this.summary.setIcon(node.getIcon());
                this.summary.setText(node.getText());
                TreeNode treeNode = node.getParent();
                Color color = treeNode instanceof SummaryData.Node ? ((SummaryData.Node)SummaryData.Node.class.cast(treeNode)).getColor() : null;
                this.count.setText(node.getCount(), color);
                this.count.setVisible(true);
            } else if (node.getUserObject() instanceof TaskState) {
                painter = this.painterCache.get((Object)((TaskState)((Object)node.getUserObject())));
                if (this.isSelected()) {
                    this.summary.setForeground(Color.BLACK);
                }
                this.summary.setIcon(node.getIcon());
                this.summary.setText(node.getText());
                this.count.setText(node.getCount(), node.getColor());
                this.count.setVisible(true);
            } else {
                Color color = node.getColor();
                if (!this.isSelected() && color != null) {
                    this.getView().setBackground(color);
                    this.getView().setForeground(UI.getXorColor(color));
                    this.getView().setOpaque(true);
                }
                this.summary.setIcon(node.getIcon());
                this.summary.setText(node.getText());
            }
            ((MPanel)MPanel.class.cast(this.getView())).setPainter(painter);
        }

        private Renderer() {
            super(2);
            for (TaskState taskState : TaskState.values()) {
                this.painterCache.put(taskState, new GlassPainter(taskState.getColorForPaint(), GlassPainter.RoundType.ALL));
            }
        }
    }
}

