/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.io.File;
import java.util.List;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.FSException;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MountManager;
import org.makagiga.fs.MountPanel;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;
import org.makagiga.tree.version.VersionInfo;

public final class AdvancedProperties
extends MPanel
implements Lockable,
MDisposable {
    private static final boolean DEFAULT_DEFAULT = true;
    private static final boolean DEFAULT_READ = false;
    private static final boolean DEFAULT_WRITE = false;
    private boolean locked;
    private int oldPermissionsIndex;
    private MComboBox<Permission> permissions;
    private MountPanel mountPanel;

    public AdvancedProperties(MetaInfo metaInfo, MetaInfo metaInfo2) {
        super(1);
        this.mountPanel = new MountPanel(metaInfo, metaInfo2);
        if (this.mountPanel.isAvailable()) {
            this.add(this.mountPanel);
            this.addStretch();
        }
        MLabel mLabel = this.addHeader(UI._("Permissions For Other Users:"));
        this.permissions = new MComboBox();
        this.permissions.addAllItems((Permission[])Permission.values());
        if (metaInfo2 != null) {
            Permission permission = AdvancedProperties.readPermission(metaInfo2);
            this.permissions.setSelectedItem((Object)permission);
        }
        mLabel.setLabelFor(this.permissions);
        this.oldPermissionsIndex = this.permissions.getSelectedIndex();
        this.add(this.permissions);
        this.addStretch();
    }

    public void apply(MetaInfo metaInfo) {
        this.mountPanel.saveAutoCompletion();
        AdvancedProperties.applyPermissionsToFolder(metaInfo, this.permissions.getSelectedItem());
    }

    public static void applyPermissions(MetaInfo metaInfo, boolean bl) {
        MetaInfo metaInfo2 = metaInfo.getParentFolder();
        if (metaInfo.isDynamicFolder()) {
            AdvancedProperties.applyPermissionsFromParent(metaInfo2, metaInfo.getFilePath());
        } else if (metaInfo.isFile()) {
            AdvancedProperties.applyPermissionsFromParent(metaInfo2, metaInfo.getFilePath());
            AdvancedProperties.applyPermissionsFromParent(metaInfo2, metaInfo.getFilePath() + ".properties");
            try {
                List<VersionInfo> list = VersionControl.getAllVersions(metaInfo);
                for (VersionInfo versionInfo : list) {
                    AdvancedProperties.applyPermissionsFromParent(metaInfo2, versionInfo.getPath());
                }
            }
            catch (VersionException versionException) {
                MLogger.exception(versionException);
            }
        } else if (metaInfo.isFolder()) {
            if (bl) {
                AdvancedProperties.applyPermissionsToFolder(metaInfo, AdvancedProperties.readPermission(metaInfo2));
            }
            AdvancedProperties.recursiveApplyPermissions(metaInfo);
        }
    }

    public static void applyPermissionsFromProperties(MetaInfo metaInfo) {
        Permission permission = AdvancedProperties.readPermission(metaInfo);
        String string = metaInfo.getFilePath();
        AdvancedProperties.applyPermissionsToPath(string, permission);
        AdvancedProperties.applyPermissionsToPath(FS.makePath(string, ".properties"), permission);
    }

    public String getMount() {
        return this.mountPanel.isMountExternalFolder() ? this.mountPanel.getExternalFolder() : null;
    }

    public boolean isMountModified() {
        return this.mountPanel.isModified();
    }

    public boolean isPermissionModified() {
        return this.permissions.getSelectedIndex() != this.oldPermissionsIndex;
    }

    public void validateMount() throws FSException {
        if (this.mountPanel.isMountExternalFolder()) {
            MountManager.validate(this.mountPanel.getExternalFolder());
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        if (this.locked == bl) {
            return;
        }
        this.locked = bl;
        this.permissions.setEnabled(!this.locked);
        this.mountPanel.setLocked(bl);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.permissions = null;
        this.mountPanel = TK.dispose(this.mountPanel);
        return null;
    }

    private static void applyPermissionsFromParent(MetaInfo metaInfo, String string) {
        AdvancedProperties.applyPermissionsToPath(string, AdvancedProperties.readPermission(metaInfo));
    }

    private static void applyPermissionsToFolder(MetaInfo metaInfo, Permission permission) {
        AdvancedProperties.applyPermissionsToPath(metaInfo.getFilePath(), permission);
        AdvancedProperties.applyPermissionsToPath(FS.makePath(metaInfo.getFilePath(), ".properties"), permission);
        AdvancedProperties.writePermission(metaInfo, permission);
        metaInfo.sync();
        if (metaInfo.isMount()) {
            AdvancedProperties.applyPermissionsToPath(metaInfo.getMount(), permission);
            AdvancedProperties.applyPermissionsToPath(FS.makePath(metaInfo.getMount(), ".properties"), permission);
        }
    }

    private static void applyPermissionsToPath(String string, Permission permission) {
        MLogger.debug("vfs", "%s, permission = %s", string, permission == null ? null : permission.name());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        File file = new File(string);
        if (permission == Permission.DEFAULT) {
            File file2 = file.getParentFile();
            if (file2 == null) {
                return;
            }
            bl = file2.canRead();
            bl2 = file2.canWrite();
            bl3 = true;
        } else if (permission == Permission.FORBIDDEN) {
            bl = false;
            bl2 = false;
        } else if (permission == Permission.READ) {
            bl = true;
            bl2 = false;
        } else if (permission == Permission.READ_WRITE) {
            bl = true;
            bl2 = true;
        }
        if (file.isDirectory()) {
            file.setExecutable(false, false);
            file.setExecutable(true, !bl);
        }
        file.setReadable(false, false);
        file.setReadable(true, !bl);
        file.setWritable(false, false);
        file.setWritable(true, !bl2 || bl3);
    }

    private static Permission readPermission(MetaInfo metaInfo) {
        if (metaInfo.isFSRoot()) {
            return Permission.DEFAULT;
        }
        if (!metaInfo.isFolder()) {
            MLogger.warning("fs", "Folder expected: %s", metaInfo);
            return Permission.DEFAULT;
        }
        Config config = metaInfo.getConfig();
        if (config.read("permission.default", true)) {
            return Permission.DEFAULT;
        }
        boolean bl = config.read("permission.read", false);
        boolean bl2 = config.read("permission.write", false);
        if (bl && bl2) {
            return Permission.READ_WRITE;
        }
        if (bl) {
            return Permission.READ;
        }
        return Permission.FORBIDDEN;
    }

    private static void recursiveApplyPermissions(MetaInfo metaInfo) {
        for (MetaInfo metaInfo2 : metaInfo.list(MV.MODEL)) {
            AdvancedProperties.applyPermissions(metaInfo2, true);
        }
    }

    private static void writePermission(MetaInfo metaInfo, Permission permission) {
        if (metaInfo.isFSRoot()) {
            return;
        }
        if (!metaInfo.isFolder()) {
            MLogger.warning("fs", "Folder expected: %s", metaInfo);
            return;
        }
        Config config = metaInfo.getConfig();
        switch (permission) {
            case DEFAULT: {
                config.write("permission.default", true);
                config.removeBoolean("permission.read");
                config.removeBoolean("permission.write");
                break;
            }
            case FORBIDDEN: {
                config.write("permission.default", false);
                config.write("permission.read", false);
                config.write("permission.write", false);
                break;
            }
            case READ: {
                config.write("permission.default", false);
                config.write("permission.read", true);
                config.write("permission.write", false);
                break;
            }
            case READ_WRITE: {
                config.write("permission.default", false);
                config.write("permission.read", true);
                config.write("permission.write", true);
            }
        }
    }

    public static enum Permission {
        DEFAULT(UI._("Use default system settings")),
        FORBIDDEN(UI._("View or write is forbidden")),
        READ(UI._("Can view content of this folder/subfolders")),
        READ_WRITE(UI._("Can view or MODIFY content of this folder/subfolders"));

        private String text;

        public String toString() {
            return this.text;
        }

        private Permission(String string2) {
            this.text = string2;
        }
    }
}

