/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBException;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDownloadDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MV;
import org.makagiga.commons.Net;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.Property;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorExport;
import org.makagiga.editors.EditorExportV2;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.link.Link;
import org.makagiga.form.Default;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.AdvancedProperties;
import org.makagiga.tree.Tree;
import org.makagiga.tree.TreePanel;
import org.makagiga.tree.formats.Incollector;
import org.makagiga.tree.formats.IncollectorExport;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;

public final class ImportExport {
    public static MetaInfo createLinkFile(MetaInfo metaInfo, String string, String string2, String string3) throws FSException, IOException {
        MetaInfo metaInfo2 = metaInfo.getFS().createUniqueFile(metaInfo, string, "mglink");
        if (metaInfo2 != null) {
            ImportExport.createLinkFile(metaInfo2.getFilePath(), string2, string3);
            AdvancedProperties.applyPermissions(metaInfo2, true);
        }
        return metaInfo2;
    }

    public static void createLinkFile(String string, String string2, String string3) throws IOException {
        Link link = new Link(string3, string2);
        try {
            XMLHelper.marshal((Object)link, string);
        }
        catch (JAXBException jAXBException) {
            throw new IOException(jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(EditorPlugin.FileType fileType) {
        Object object;
        Object object2;
        File file;
        MCheckBox mCheckBox;
        Editor editor;
        block20: {
            editor = (Editor)Tabs.getInstance().getSelectedTab();
            if (!(editor instanceof EditorExport)) {
                return;
            }
            Object object3 = null;
            if (editor instanceof EditorExportV2) {
                try {
                    object3 = ((EditorExportV2)EditorExportV2.class.cast(editor)).configureExport(MainWindow.getInstance(), fileType);
                    if (EditorExportV2.CANCEL_EXPORT.equals(object3)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    MMessage.error(MainWindow.getInstance(), exception, UI._("Export failed"));
                }
            }
            Config config = Config.getDefault();
            mCheckBox = new MCheckBox(UI._("Export file properties"));
            mCheckBox.setSelected(config.read("Export.propertiesFile", false));
            MFileChooser mFileChooser = ImportExport.createFileChooser(true, editor, new MArrayList<EditorPlugin.FileType>(fileType));
            MPanel mPanel = (MPanel)mFileChooser.getAccessory();
            mPanel.addSeparator(UI._("Export"));
            mPanel.add(mCheckBox);
            if (!mFileChooser.saveDialog()) {
                return;
            }
            config.write("Export.propertiesFile", mCheckBox.isSelected());
            config.sync();
            file = mFileChooser.getSelectedFile();
            UI.setWaitCursor(true);
            try {
                editor.setExportMode(true);
                if (fileType.isInternal() && fileType.is("png")) {
                    ImageIO.write((RenderedImage)UI.createCompatibleImage(editor.getCore(), null), "png", file);
                    break block20;
                }
                object2 = null;
                object = null;
                try {
                    object = new FS.BufferedFileOutput(file);
                    ((EditorExport)EditorExport.class.cast(editor)).exportFile(fileType, (OutputStream)object);
                    if (editor instanceof EditorExportV2) {
                        object2 = ((EditorExportV2)EditorExportV2.class.cast(editor)).exportFile(fileType, file, (OutputStream)object, object3);
                    }
                }
                catch (Throwable throwable) {
                    FS.close(object);
                    throw throwable;
                }
                FS.close((Closeable)object);
                if (object2 == EditorExportV2.ExportResult.PREVIEW) {
                    MainWindow.openURI(file.toURI());
                }
            }
            catch (Exception exception) {
                MMessage.error(null, exception, UI._("Export failed"));
            }
            finally {
                editor.setExportMode(false);
                UI.setWaitCursor(false);
            }
        }
        TagsUtils.addTag(editor.getMetaInfo(), TagsUtils.AutoTag.EXPORTED);
        if (mCheckBox.isSelected()) {
            editor.getMetaInfo().sync();
            object2 = editor.getMetaInfo().getFilePath() + ".properties";
            object = file.getPath() + ".properties";
            if (FS.exists((String)object) && !MMessage.confirmFileOverwrite(null, (String)object)) {
                return;
            }
            try {
                FS.copyFile(object2, (String)object);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
            }
        }
    }

    public static void importClipboard() {
        Clipboard clipboard = MClipboard.getDefault();
        DataFlavor[] dataFlavorArray = clipboard.getAvailableDataFlavors();
        TreeFS treeFS = TreeFS.getInstance();
        MetaInfo metaInfo = treeFS.getCurrentFolder(false);
        if (!metaInfo.canModify()) {
            metaInfo = treeFS.getRoot();
        }
        ImportExport.importTransferable(clipboard, dataFlavorArray, metaInfo, false);
    }

    public static void importTransferable(Object object, DataFlavor[] dataFlavorArray, MetaInfo metaInfo, boolean bl) {
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        Object object4;
        if (TK.isEmpty(dataFlavorArray)) {
            MStatusBar.error(UI._("Import failed"));
            return;
        }
        Map<DataFlavor, Object> map = TK.newHashMap();
        try {
            object4 = MDataTransfer.getString(object);
            if (object4 != null) {
                map.put(DataFlavor.stringFlavor, object4);
                if (!((String)object4).contains("\n")) {
                    try {
                        serializable2 = new URL(((String)object4).trim());
                        map.put(MDataTransfer.URL_DATA_FLAVOR, serializable2);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        object4 = Config.getDefault();
        serializable2 = MDataTransfer.findBestHTMLFlavor(dataFlavorArray, bl);
        DataFlavor dataFlavor = MDataTransfer.findBestImageFlavor(dataFlavorArray, "image/png");
        if (dataFlavor != null) {
            serializable2 = null;
        }
        DataFlavor dataFlavor2 = null;
        EditorPlugin editorPlugin = null;
        PluginInfo pluginInfo = null;
        String string = null;
        Object object5 = null;
        MArrayList<DataFlavor> mArrayList = new MArrayList<DataFlavor>(dataFlavorArray.length);
        for (DataFlavor object32 : dataFlavorArray) {
            if (serializable2 == null && "text/html".equals(MDataTransfer.getSimpleMimeType(object32)) || dataFlavor == null && "image".equals(object32.getPrimaryType()) || ((object2 = object32.getSubType()) == null || !((String)object2).contains("makagiga")) && !object32.getRepresentationClass().equals(InputStream.class) && !object32.getRepresentationClass().equals(Reader.class)) continue;
            mArrayList.add(object32);
        }
        mArrayList.sort(new Comparator<DataFlavor>(){

            @Override
            public int compare(DataFlavor dataFlavor, DataFlavor dataFlavor2) {
                int n = dataFlavor.getRepresentationClass().getName().compareTo(dataFlavor2.getRepresentationClass().getName()) * -1;
                return n == 0 ? dataFlavor.getMimeType().compareTo(dataFlavor2.getMimeType()) : n;
            }
        });
        if (dataFlavor != null) {
            mArrayList.add(0, dataFlavor);
        }
        if (serializable2 != null) {
            mArrayList.add(0, (DataFlavor)serializable2);
        }
        mArrayList.add(DataFlavor.stringFlavor);
        Object object6 = mArrayList.iterator();
        while (object6.hasNext()) {
            DataFlavor dataFlavor3;
            dataFlavor2 = dataFlavor3 = (DataFlavor)object6.next();
            pluginInfo = EditorPlugin.findPluginForDataFlavor(object, dataFlavor3, map);
            if (pluginInfo == null) continue;
            editorPlugin = (EditorPlugin)pluginInfo.getPlugin();
            break;
        }
        if (pluginInfo == null) {
            object6 = mArrayList.iterator();
            while (object6.hasNext()) {
                DataFlavor dataFlavor4;
                dataFlavor2 = dataFlavor4 = (DataFlavor)object6.next();
                String string2 = MDataTransfer.getSimpleMimeType(dataFlavor4);
                if ("text/plain".equals(string2) || (pluginInfo = EditorPlugin.findPluginForMime(string2)) == null) continue;
                break;
            }
        }
        if (pluginInfo == null) {
            dataFlavor2 = DataFlavor.stringFlavor;
        }
        object6 = new PasteForm();
        String string3 = (String)map.get(DataFlavor.stringFlavor);
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (!TK.isEmpty(string3)) {
            ((PasteForm)object6).name = TK.rightSqueeze(string3, 64);
        }
        if (TK.isEmpty(((PasteForm)object6).name)) {
            ((PasteForm)object6).name = UI._("New File");
        }
        if (bl) {
            ((PasteForm)object6).asHTML = serializable2 != null;
        } else {
            ((PasteForm)object6).asHTML = serializable2 == null ? false : ((Config)object4).read("Import.pasteAsHTML", true);
        }
        Tags tags = new Tags();
        TagsUtils.AutoTag autoTag = TagsUtils.AutoTag.PASTED;
        if (autoTag.isEnabled()) {
            tags.add(autoTag.getTag());
        }
        if (!bl) {
            object2 = new FormPanel<Object>(object6);
            ((FormPanel)object2).setLabel("name", UI._("Name:"));
            ((FormPanel)object2).setLabel("asHTML", UI._("Paste As HTML"));
            ((FormPanel)object2).setEnabled("asHTML", serializable2 != null);
            serializable = ((FormPanel)object2).createDialog((Window)MainWindow.getInstance(), TreePanel.getInstance().quickPasteActionInfo);
            ((MDialog)serializable).changeButton(((MDialog)serializable).getOKButton(), MActionInfo.PASTE);
            ((MDialog)serializable).packFixed(UI.WindowSize.MEDIUM);
            if (!((MDialog)serializable).exec()) {
                return;
            }
            ((Config)object4).write("Import.pasteAsHTML", ((PasteForm)object6).asHTML);
            ((Config)object4).sync();
        }
        if (serializable2 != null && !((PasteForm)object6).asHTML) {
            pluginInfo = null;
            dataFlavor2 = null;
        }
        MLogger.debug("makagiga", "Use import data: %s", editorPlugin);
        MLogger.debug("makagiga", "Use flavor 1: %s", dataFlavor2);
        MLogger.debug("makagiga", "Use plugin 1: %s", pluginInfo);
        if (dataFlavor2 == null) {
            dataFlavor2 = DataFlavor.stringFlavor;
        }
        if (pluginInfo == null && (object2 = (URL)map.get(MDataTransfer.URL_DATA_FLAVOR)) != null && MDataTransfer.isImage((URL)object2) && !TK.isEmpty(string = FS.getExtension(((URL)object2).getPath())) && (pluginInfo = EditorPlugin.findPluginForExtension(string)) != null) {
            object5 = object2;
        }
        if (pluginInfo == null) {
            pluginInfo = EditorPlugin.findPluginForMime("text/plain");
        }
        if (pluginInfo == null) {
            MStatusBar.error(UI._("Import failed"));
            return;
        }
        MLogger.debug("makagiga", "Use flavor 2: %s", dataFlavor2);
        MLogger.debug("makagiga", "Use plugin 2: %s", pluginInfo);
        MainWindow.showTree(null);
        object2 = TK.isEmpty(string) ? ((EditorPlugin)EditorPlugin.class.cast(pluginInfo.getPluggable())).getDefaultExtension().toString() : string;
        ((PasteForm)object6).name = FSHelper.getUniqueName(metaInfo.getTargetPath(), ((PasteForm)object6).name, (String)object2);
        serializable = new File(FS.makePath(metaInfo.getTargetPath(), TK.escapeURL(((PasteForm)object6).name, 1)));
        try {
            Object exception;
            MLogger.info("makagiga", "Quick paste: \"%s\"", dataFlavor2);
            if (((PasteForm)object6).asHTML) {
                exception = MDataTransfer.getHTML(object, dataFlavor2);
                FS.write((File)serializable, (String)exception);
            } else if (object5 != null) {
                exception = new Net.DownloadInfo((URL)object5, null, 2);
                ((Net.DownloadInfo)exception).setDestinationFile((File)serializable);
                MDownloadDialog.download(null, (Net.DownloadInfo)exception);
            } else if (editorPlugin != null) {
                editorPlugin.importData(object, dataFlavor2, map, (File)serializable);
            } else if (!ImportExport.pasteText(object, dataFlavor2, map, (File)serializable)) {
                ImportExport.pasteStream(object, dataFlavor2, (File)serializable);
            }
            exception = MetaInfo.createFile((AbstractFS)TreeFS.getInstance(), ((File)serializable).getPath(), pluginInfo);
            ((MetaInfo)exception).setTags(tags);
            Tree tree = Tree.getInstance();
            tree.addItem(metaInfo, (MetaInfo)exception);
            AdvancedProperties.applyPermissions((MetaInfo)exception, true);
            tree.selectItem(exception, true);
            tree.open((MetaInfo)exception);
        }
        catch (Exception exception) {
            MMessage.error(null, exception, serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFile(EditorPlugin editorPlugin, List<EditorPlugin.FileType> list) {
        MFileChooser mFileChooser = ImportExport.createFileChooser(false, null, list);
        if (!mFileChooser.openDialog()) {
            return;
        }
        File[] fileArray = mFileChooser.getSelectedFiles();
        MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(false);
        for (File file : fileArray) {
            try {
                UI.setWaitCursor(true);
                String string = FS.getExtension(file.getName());
                if (string == null || !editorPlugin.hasExtension(string)) {
                    string = editorPlugin.getDefaultExtension().toString();
                }
                MetaInfo metaInfo2 = ImportExport.importFile(metaInfo, editorPlugin, string, file);
                if (fileArray.length != 1) continue;
                Tabs.getInstance().openEditor(metaInfo2);
            }
            catch (Exception exception) {
                MMessage.error(null, exception, file);
                break;
            }
            finally {
                UI.setWaitCursor(false);
            }
        }
    }

    public static MetaInfo importFile(MetaInfo metaInfo, EditorPlugin editorPlugin, String string, File file) throws Exception {
        Object object;
        boolean bl;
        Tree tree = Tree.getInstance();
        String string2 = file.getPath();
        String string3 = TK.escapeURL(file.getName(), 1);
        String string4 = FS.makePath(metaInfo.getTargetPath(), string3);
        if (!string.equals(FS.getExtension(string4))) {
            string4 = string4 + "." + string;
        }
        if (bl = FS.exists(string4)) {
            object = null;
            for (Serializable serializable : Query.all(SortMethod.UNSORTED)) {
                MetaInfo metaInfo2 = (MetaInfo)((Property)serializable).get();
                if (metaInfo2.getParentFolder() != metaInfo || !metaInfo2.isFile() || !string4.equals(metaInfo2.getFilePath())) continue;
                object = metaInfo2;
                break;
            }
            if (object != null) {
                if (!MMessage.confirmFileOverwrite(null, ((MetaInfo)object).getNicePath(), new File(string4), file)) {
                    throw new PassiveException(UI._("Import cancelled"));
                }
                try {
                    VersionControl.create((MetaInfo)object, null, 0);
                }
                catch (VersionException versionException) {
                    MLogger.exception(versionException);
                }
            }
        }
        FS.copyFile(string2, string4);
        string2 = string2 + ".properties";
        if (FS.exists(string2)) {
            try {
                FS.copyFile(string2, string4 + ".properties");
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                MLogger.exception(exception);
            }
        }
        if (bl) {
            for (MetaInfo metaInfo3 : metaInfo.list(MV.MODEL)) {
                Serializable serializable;
                if (!metaInfo3.getFilePath().equals(string4)) continue;
                serializable = Tabs.getInstance();
                ((Tabs)serializable).closeEditorAt(((Tabs)serializable).findEditor(string4), 1);
                tree.deleteItem(metaInfo3);
                break;
            }
        }
        object = MetaInfo.createFile(metaInfo.getFS(), string4, string);
        tree.addItem(metaInfo, (MetaInfo)object);
        AdvancedProperties.applyPermissions((MetaInfo)object, true);
        tree.selectItem(object, true);
        TagsUtils.addTag((MetaInfo)object, TagsUtils.AutoTag.IMPORTED);
        return object;
    }

    public static void importIncollector() {
        String string;
        MFileChooser mFileChooser = MFileChooser.createFileChooser(null);
        mFileChooser.addFilter("Incollector Database", "inr", "ied");
        mFileChooser.setApproveText(MActionInfo.IMPORT.getText());
        mFileChooser.setConfigKey("incollector");
        mFileChooser.setSelectedPath(FS.makePath(FS.getUserDir(), FS.makePath(".incollector", "data.inr")));
        mFileChooser.setTitle(UI._("Import"));
        if (mFileChooser.openDialog() && (string = mFileChooser.getSelectedPath()) != null) {
            ImportExport.importIncollector(string);
        }
    }

    @Deprecated
    public static void importKeyNote() {
        throw new UnsupportedOperationException();
    }

    private ImportExport() {
    }

    private static MFileChooser createFileChooser(boolean bl, Editor<?> editor, List<EditorPlugin.FileType> list) {
        Object object;
        MFileChooser mFileChooser = MFileChooser.createFileChooser(null);
        for (EditorPlugin.FileType object2 : list) {
            mFileChooser.addFilter(object2.getDescription(), object2.getExtensions());
        }
        if (list.size() > 1) {
            object = new StringList();
            for (EditorPlugin.FileType fileType : list) {
                for (String string : fileType.getExtensions()) {
                    ((ArrayList)object).add(string);
                }
            }
            mFileChooser.addFilter(UI._("All Supported Types"), ((StringList)object).toArray());
        }
        mFileChooser.setConfigKey((bl ? "export." : "import.") + TK.toString(list, "-"));
        if (editor != null) {
            if (bl) {
                object = editor.getMetaInfo() + "." + list.get(0);
                object = FS.replaceUnsafeCharacters((String)object);
                mFileChooser.setSelectedPath((String)object);
            } else {
                mFileChooser.setSelectedPath("");
            }
        }
        if (bl) {
            mFileChooser.setApproveText(UI._("Export"));
            mFileChooser.setTitle(UI._("Export"));
        } else {
            mFileChooser.setMultiSelectionEnabled(true);
            mFileChooser.setApproveText(MActionInfo.IMPORT.getText());
            mFileChooser.setTitle(UI._("Import"));
        }
        return mFileChooser;
    }

    private static void createFileForEntry(MetaInfo metaInfo, Incollector.Entry entry) throws FSException, IOException {
        MetaInfo metaInfo2;
        String string;
        String string2;
        Incollector.Entry.Type type = entry.getType();
        switch (type) {
            case CONVERSATION: {
                string2 = "txt";
                string = entry.getConversation().getTitle();
                break;
            }
            case NOTE: {
                string2 = "txt";
                string = entry.getNote().getTitle();
                break;
            }
            case QUOTE: {
                string2 = "txt";
                string = entry.getQuote().getAuthor();
                break;
            }
            case SERIAL: {
                string2 = "txt";
                string = entry.getSerial().getApplication();
                break;
            }
            case SOURCE_CODE: {
                string2 = "txt";
                string = entry.getSourceCode().getLanguage();
                break;
            }
            case WORD: {
                string2 = "txt";
                string = entry.getWord().getLanguage() + " - " + entry.getWord().getWord() + " - " + entry.getWord().getText();
                break;
            }
            case WEB_ADDRESS: {
                string2 = "mglink";
                string = entry.toString();
                break;
            }
            default: {
                string2 = "txt";
                string = null;
            }
        }
        if (TK.isEmpty(string)) {
            String string3 = string = entry.getData() == null ? null : entry.getData().toString();
            if (TK.isEmpty(string)) {
                string = type.toString();
            }
        }
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        string = string.replace("  ", " ");
        string = (string = string.trim()).isEmpty() ? UI._("New File") : TK.rightSqueeze(string, 64);
        if (type == Incollector.Entry.Type.WEB_ADDRESS) {
            metaInfo2 = ImportExport.createLinkFile(metaInfo, string, entry.getWebAddress().getName(), entry.getWebAddress().getText());
        } else {
            metaInfo2 = metaInfo.getFS().createUniqueFile(metaInfo, string, string2);
            FS.write(metaInfo2.getFilePath(), entry.toString());
        }
        metaInfo2.setComment(entry.getComment());
        metaInfo2.setCreatedTime(entry.toMakagigaDate());
        metaInfo2.setRating(entry.toMakagigaRating());
        metaInfo2.setTags(entry.toMakagigaTags());
        TagsUtils.addTag(metaInfo2, TagsUtils.AutoTag.IMPORTED);
        metaInfo2.sync();
    }

    private static void importIncollector(String string) {
        try {
            List<Incollector.Entry> list;
            Object object;
            if ("ied".equals(FS.getExtension(string))) {
                object = XMLHelper.unmarshal(IncollectorExport.class, string);
                list = ((IncollectorExport)object).getEntries();
            } else {
                object = Incollector.load(string);
                list = ((Incollector)object).getEntries();
            }
            if (TK.isEmpty(list)) {
                MStatusBar.warning(UI._("Nothing to import (the database is empty)"));
            } else {
                Collections.sort(list, new Comparator<Incollector.Entry>(){

                    @Override
                    public int compare(Incollector.Entry entry, Incollector.Entry entry2) {
                        return entry.getType().compareTo(entry2.getType());
                    }
                });
                object = Tree.getInstance();
                Incollector.Entry.Type type = null;
                MetaInfo metaInfo = ((Tree)object).getCurrentFolder(false);
                MetaInfo metaInfo2 = null;
                for (Incollector.Entry entry : list) {
                    if (entry.getType() != type) {
                        type = entry.getType();
                        metaInfo2 = metaInfo.getFS().createUniqueFolder(metaInfo, type.toString());
                    }
                    ImportExport.createFileForEntry(metaInfo2, entry);
                }
            }
        }
        catch (Exception exception) {
            MMessage.error(null, exception, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pasteStream(Object object, DataFlavor dataFlavor, File file) throws Exception {
        if (!dataFlavor.getRepresentationClass().equals(InputStream.class)) {
            return;
        }
        InputStream inputStream = null;
        FS.BufferedFileOutput bufferedFileOutput = null;
        try {
            inputStream = (InputStream)MDataTransfer.getData(object, dataFlavor);
            bufferedFileOutput = new FS.BufferedFileOutput(file);
            FS.copyStream(inputStream, bufferedFileOutput);
        }
        catch (Throwable throwable) {
            FS.close(inputStream);
            FS.close(bufferedFileOutput);
            throw throwable;
        }
        FS.close(inputStream);
        FS.close(bufferedFileOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pasteText(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map, File file) throws Exception {
        if (dataFlavor.getRepresentationClass().equals(Reader.class)) {
            boolean bl;
            FS.TextReader textReader = null;
            FS.TextWriter textWriter = null;
            try {
                textReader = new FS.TextReader((Reader)MDataTransfer.getData(object, dataFlavor));
                textWriter = FS.getUTF8Writer(file);
                FS.copyChars(textReader, textWriter);
                bl = true;
            }
            catch (Throwable throwable) {
                FS.close(textReader);
                FS.close(textWriter);
                throw throwable;
            }
            FS.close(textReader);
            FS.close(textWriter);
            return bl;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            FS.write(file, (String)map.get(DataFlavor.stringFlavor));
            return true;
        }
        return false;
    }

    @Form(order={"name", "asHTML"}, pack=480)
    private static final class PasteForm {
        @Default
        @Field(autoCompletion="rename", validators={FSHelper.NameValidator.class})
        private String name;
        @Field
        private boolean asHTML;

        private PasteForm() {
        }
    }

    public static abstract class AbstractImportExportAction
    extends MAction {
        MArrayList<EditorPlugin.FileType> typeList;

        public AbstractImportExportAction(String string, List<EditorPlugin.FileType> list) {
            super(string);
            this.typeList = new MArrayList<EditorPlugin.FileType>((Collection<EditorPlugin.FileType>)list);
            this.setHTMLHelp(UI._("File Types: {0}", this.typeList.toString(", ")));
        }
    }

    public static final class ImportAction
    extends AbstractImportExportAction {
        private final EditorPlugin plugin;

        public ImportAction(EditorPlugin editorPlugin, String string, List<EditorPlugin.FileType> list) {
            super(string, list);
            this.plugin = editorPlugin;
        }

        @Override
        public void onAction() {
            ImportExport.importFile(this.plugin, this.typeList);
        }
    }

    public static final class ExportAction
    extends AbstractImportExportAction {
        public ExportAction(EditorPlugin.FileType fileType) {
            super(fileType.getDescription(), new MArrayList<EditorPlugin.FileType>(fileType));
        }

        @Override
        public void onAction() {
            ImportExport.exportFile((EditorPlugin.FileType)this.typeList.getFirst());
        }
    }
}

