/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.MainWindow;
import org.makagiga.Vars;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRating;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.help.HelpContext;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.preview.PreviewPanel;
import org.makagiga.commons.validator.NotEmptyValidator;
import org.makagiga.editors.EditorCrypto;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.FSProperties;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MountManager;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsEditor;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.AdvancedProperties;
import org.makagiga.tree.PropertiesBar;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.version.VersionPanel;

public final class PropertiesPanel
extends MTabbedPane<MPanel> {
    private AdvancedProperties advancedProperties;
    private boolean passwordSupported;
    private boolean singleSelection;
    private Color originalColor;
    private float originalRating;
    private MetaInfo singleItem;
    private MetaInfo[] selection;
    private MButton passwordButton;
    private MEditorPane commentField;
    private MRating rating;
    private MSmallColorChooser color;
    private MTextField name;
    private PropertiesBar.IconButton iconButton;
    private PropertiesBar.LockButton lockButton = new PropertiesBar.LockButton(false){

        @Override
        protected void onClick() {
            super.onClick();
            PropertiesPanel.this.updateState();
        }
    };
    private TagsEditor tagsEditor;
    private final TriBoolean hasLockedAndUnlocked;
    private VersionPanel versionPanel;

    public PropertiesPanel(MetaInfo ... metaInfoArray) {
        this((Window)null, metaInfoArray);
    }

    public PropertiesPanel(Window window, MetaInfo ... metaInfoArray) {
        this.lockButton.setSelection(metaInfoArray);
        this.selection = TK.copyOf(metaInfoArray);
        boolean bl = this.singleSelection = metaInfoArray.length == 1;
        if (this.singleSelection) {
            this.singleItem = metaInfoArray[0];
        }
        if (!this.singleSelection) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (MetaInfo metaInfo : metaInfoArray) {
                if (metaInfo.isLocked()) {
                    bl2 = true;
                    continue;
                }
                bl3 = true;
            }
            this.hasLockedAndUnlocked = TriBoolean.from(bl2 && bl3);
        } else {
            this.hasLockedAndUnlocked = TriBoolean.UNDEFINED;
        }
        if (this.hasLockedAndUnlocked.isTrue()) {
            this.lockButton.setVisible(false);
        }
        this.addTab(UI._("General"), this.createGeneralPanel(window));
        if (this.singleSelection) {
            this.createEmptyPanel(UI._("Information"), 1, true);
            if (this.singleItem.isFolder()) {
                this.advancedProperties = new AdvancedProperties(this.singleItem.getParentFolder(), this.singleItem);
                this.advancedProperties.setContentMargin();
                this.addTab(UI._("Advanced"), this.advancedProperties);
            } else {
                this.addTab(UI._("Advanced"), MPanel.createVBoxPanel());
                this.setEnabledAt(2, false);
            }
            this.createEmptyPanel(UI._("Preview"), 3, this.singleItem.isFile());
            this.createEmptyPanel(UI._("Versions"), 4, this.singleItem.isFile());
        } else {
            this.createEmptyPanel(UI._("Information"), 1, false);
            this.addTab(UI._("Advanced"), MPanel.createVBoxPanel());
            this.setEnabledAt(2, false);
            this.createEmptyPanel(UI._("Preview"), 3, false);
        }
        if (this.singleSelection && this.singleItem.getFS() instanceof FSProperties) {
            ((FSProperties)FSProperties.class.cast(this.singleItem.getFS())).initProperties(this, metaInfoArray);
        }
        this.updateState();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertiesPanel.this.initOnDemand();
            }
        });
    }

    public void apply() {
        Object object;
        this.name.saveAutoCompletion();
        this.tagsEditor.saveAutoCompletion();
        Color color = this.color.getColor();
        if (TK.isChange(this.originalColor, color)) {
            PropertiesPanel.setProperty(1, color, this.selection);
        }
        if (this.rating.getValue() != this.originalRating) {
            PropertiesPanel.setProperty(4, Float.valueOf(this.rating.getValue()), this.selection);
        }
        if (this.tagsEditor.isModified()) {
            PropertiesPanel.setProperty(8, this.tagsEditor.getTags(), this.selection);
        }
        if (this.singleSelection) {
            PropertiesPanel.setProperty(16, this.commentField.getText(), this.selection);
        }
        this.doRename();
        if (!this.hasLockedAndUnlocked.isTrue()) {
            this.lockButton.apply(this.selection);
        }
        if (this.singleSelection && this.singleItem.isFolder()) {
            object = this.singleItem;
            MountManager.unmount((MetaInfo)object);
            try {
                if (this.advancedProperties.isMountModified()) {
                    this.advancedProperties.validateMount();
                    ((MetaInfo)object).setMount(this.advancedProperties.getMount());
                    ((MetaInfo)object).setWriteable(new File(((MetaInfo)object).getTargetPath()).canWrite());
                    ((MetaInfo)object).sync();
                    Tree.getInstance().removeAllChildren((MetaInfo)object);
                }
                this.advancedProperties.apply((MetaInfo)object);
                if (this.advancedProperties.isMountModified()) {
                    ((MetaInfo)object).getFS().scan((MetaInfo)object, ((MetaInfo)object).getTargetPath());
                    ((MetaInfo)object).getParentFolder().reload();
                }
                if (this.advancedProperties.isPermissionModified()) {
                    AdvancedProperties.applyPermissions((MetaInfo)object, false);
                }
            }
            catch (FSException fSException) {
                MMessage.error(null, fSException);
            }
        }
        if (this.singleSelection && this.singleItem.getFS() instanceof FSProperties) {
            object = (FSProperties)((Object)this.singleItem.getFS());
            object.applyProperties(this.selection);
            object.freeProperties();
        }
        for (MetaInfo metaInfo : this.selection) {
            metaInfo.sync();
        }
        MainWindow.getInstance().updateComponents(this.selection);
    }

    @Deprecated
    public static String createTitleForSelection(MetaInfo ... metaInfoArray) {
        switch (metaInfoArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return UI._("Properties for {0}", TK.centerSqueeze(metaInfoArray[0].toString()));
            }
        }
        return UI._("{0} selected items", metaInfoArray.length);
    }

    @Deprecated
    public void free() {
        if (this.singleSelection && this.singleItem.getFS() instanceof FSProperties) {
            FSProperties fSProperties = (FSProperties)((Object)this.singleItem.getFS());
            fSProperties.freeProperties();
        }
    }

    @Deprecated
    public void postInit() {
        if (this.canRename()) {
            this.name.makeDefault();
        } else if (this.lockButton.isEnabled() && this.lockButton.isSelected() && this.lockButton.isVisible()) {
            this.lockButton.requestFocusInWindow();
        } else {
            this.tagsEditor.getTextField().requestFocusInWindow();
        }
    }

    public static void setProperty(int n, Object object, MetaInfo ... metaInfoArray) {
        for (MetaInfo metaInfo : metaInfoArray) {
            Flags flags;
            FSProperties fSProperties;
            switch (n) {
                case 32: {
                    if (object instanceof CategoryList) {
                        metaInfo.setCategories(((CategoryList)CategoryList.class.cast(object)).toString());
                        break;
                    }
                    metaInfo.setCategories((String)object);
                    break;
                }
                case 1: {
                    metaInfo.setColor((Color)object);
                    break;
                }
                case 16: {
                    metaInfo.setComment((String)object);
                    break;
                }
                case 2: {
                    if (object instanceof MIcon) {
                        metaInfo.setIcon((MIcon)object);
                    } else if (object instanceof String) {
                        metaInfo.setIconName((String)object);
                    } else if (metaInfo.isFile()) {
                        metaInfo.setIcon(EditorPlugin.findIconForExtension(metaInfo.getExtension()));
                    } else {
                        metaInfo.setIcon(null);
                    }
                    Tracker.add(metaInfo, TrackerEvent.ID.ITEM_ICON_CHANGED);
                    break;
                }
                case 4: {
                    metaInfo.setRating(((Float)object).floatValue());
                    break;
                }
                case 8: {
                    if (object instanceof Tags) {
                        Tags tags = TagsUtils.removeDuplicates(metaInfo.getTags());
                        Tags tags2 = (Tags)object;
                        metaInfo.setTags(tags2);
                        if (tags2.equals(tags)) break;
                        Tags.clearAll();
                        break;
                    }
                    metaInfo.setTags((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property key: " + n);
                }
            }
            if (metaInfo.getFS() instanceof FSProperties) {
                fSProperties = (FSProperties)((Object)metaInfo.getFS());
                flags = fSProperties.getMetaInfoCapabilities(metaInfo);
            } else {
                fSProperties = null;
                flags = null;
            }
            if (flags != null && flags.isSet(n)) {
                fSProperties.setMetaInfoProperty(metaInfo, n, object);
            }
            metaInfo.sync();
        }
        MainWindow.getInstance().updateComponents(metaInfoArray);
    }

    public static boolean showDialog(Window window, MetaInfo ... metaInfoArray) {
        MDialog mDialog = new MDialog(window, PropertiesPanel.createTitleForSelection(metaInfoArray), MActionInfo.PROPERTIES.getIconName(), 263);
        PropertiesPanel propertiesPanel = new PropertiesPanel(mDialog, metaInfoArray);
        mDialog.getValidatorSupport().add(new NotEmptyValidator(propertiesPanel.name));
        mDialog.setHelpContext(new HelpContext("makagiga", "http://makagiga.blogspot.com/2009/05/password-protection-and-encryption.html", HelpContext.Type.URI));
        mDialog.addCenter(propertiesPanel);
        mDialog.packFixed(UI.WindowSize.MEDIUM);
        propertiesPanel.postInit();
        Config config = Config.getDefault();
        int n = config.readInt("Properties.lastTab", -1, propertiesPanel);
        if (n != -1 && propertiesPanel.isEnabledAt(n)) {
            propertiesPanel.setSelectedIndex(n);
        }
        if (mDialog.exec()) {
            propertiesPanel.apply();
            config.write("Properties.lastTab", propertiesPanel.getSelectedIndex());
            config.sync();
            propertiesPanel.advancedProperties = TK.dispose(propertiesPanel.advancedProperties);
            return true;
        }
        propertiesPanel.free();
        propertiesPanel.advancedProperties = TK.dispose(propertiesPanel.advancedProperties);
        return false;
    }

    private boolean canRename() {
        return this.singleSelection && this.singleItem.isPermission(FSAction.RENAME);
    }

    private MPanel createCommentPanel() {
        this.commentField = MEditorPane.newPlainText(this.singleItem.getComment(), true);
        MScrollPane mScrollPane = new MScrollPane(this.commentField){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 100);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 100);
            }
        };
        return MPanel.createVLabelPanel(mScrollPane, UI._("Comment:"));
    }

    private void createEmptyPanel(String string, int n, boolean bl) {
        this.addTab(string, (MPanel)null);
        if (!bl) {
            this.setEnabledAt(n, bl);
        }
    }

    private MPanel createGeneralPanel(Window window) {
        Object object;
        Serializable serializable;
        MPanel mPanel = MPanel.createVBoxPanel();
        mPanel.setContentMargin();
        this.iconButton = new PropertiesBar.IconButton(true);
        this.iconButton.setSelection(this.selection);
        this.name = new MTextField(this.singleSelection ? this.singleItem.toString() : TK.toString(this.selection));
        this.name.setAutoCompletion("rename");
        this.name.setEditable(this.canRename());
        PropertiesBar.sync();
        this.tagsEditor = new TagsEditor(TagsUtils.merge(this.selection));
        this.tagsEditor.setPainter(null);
        this.tagsEditor.getTip().setRoundType(GlassPainter.RoundType.NONE);
        float f = this.singleSelection ? this.singleItem.getRating() : 0.0f;
        this.rating = new MRating(f);
        this.rating.setClearButtonVisible(true);
        this.rating.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertiesPanel.this.originalRating = Float.MAX_VALUE;
            }
        });
        this.originalRating = f;
        this.color = new MSmallColorChooser();
        this.color.getClearButton().setVisible(true);
        if (this.singleSelection) {
            this.color.setColor(this.singleItem.getColor());
        }
        this.originalColor = this.color.getColor();
        MPanel mPanel2 = new MPanel(false);
        mPanel2.getGroupLayout().beginRows().addComponent(this.iconButton).addContentGap().addComponent(this.color).end().addGap(mPanel.getContentMargin() * 2).beginRows().addComponent((Component)this.name, UI._("Name:")).addContentGap().addComponent(this.tagsEditor).addContentGap().addComponent(this.rating).end();
        mPanel.add(mPanel2);
        if (this.singleSelection) {
            mPanel.addContentGap();
            mPanel.add(this.createCommentPanel());
        }
        this.passwordButton = new MButton(UI._("Set Password...")){

            @Override
            protected void onClick() {
                if (EditorCrypto.setPasswordDialog(this.getWindowAncestor(), PropertiesPanel.this.singleItem) && PropertiesPanel.this.versionPanel != null) {
                    PropertiesPanel.this.versionPanel.updateComponents();
                }
            }
        };
        this.passwordButton.setIconNameUI("ui/password");
        if (this.singleSelection && this.singleItem.isFile() && this.singleItem.isWriteable() && ((Boolean)Vars.passwordEnabled.get()).booleanValue() && (serializable = this.singleItem.getPluginInfo()) != null && (object = ((PluginInfo)serializable).getPluggable()) instanceof EditorPlugin) {
            EditorPlugin editorPlugin = (EditorPlugin)object;
            boolean bl = this.passwordSupported = editorPlugin.getEncryption() != EditorPlugin.Encryption.NOT_SUPPORTED;
        }
        if (window instanceof MDialog) {
            serializable = (MDialog)window;
            object = ((MDialog)serializable).getButtonsPanel();
            ((MPanel)object).addContentGap();
            ((MPanel)object).add(this.passwordButton);
            ((MPanel)object).addContentGap();
            ((MPanel)object).add(this.lockButton);
        } else {
            mPanel.addGap();
            mPanel.add(this.passwordButton);
            mPanel.addContentGap();
            mPanel.add(this.lockButton);
        }
        return mPanel;
    }

    private MPanel createInformationPanel() {
        MPanel mPanel = MPanel.createBorderPanel();
        int n = 14;
        MHTMLViewer mHTMLViewer = new MHTMLViewer();
        mHTMLViewer.setHTML(this.singleItem.getToolTipText(n));
        mHTMLViewer.setStyle("cursor: text");
        mPanel.addCenter(mHTMLViewer, 2);
        return mPanel;
    }

    private PreviewPanel createPreviewPanel() {
        PreviewPanel previewPanel = new PreviewPanel(400);
        previewPanel.update(this.singleItem.getFile());
        return previewPanel;
    }

    private void doRename() {
        String string;
        if (!this.canRename()) {
            return;
        }
        String string2 = this.singleItem.toString();
        if (TK.isChange(string2, string = this.name.getText())) {
            FSHelper.renameUI(1, this.singleItem, string);
        }
    }

    private void initOnDemand() {
        int n = this.getSelectedIndex();
        if (n == 1 && this.getComponentAt(n) == null) {
            this.setTabAt(n, this.createInformationPanel());
        } else if (n == 3 && this.getComponentAt(n) == null) {
            MPanel mPanel = MPanel.createBorderPanel();
            mPanel.addCenter(this.createPreviewPanel(), 2);
            this.setTabAt(n, mPanel);
        } else if (n == 4 && this.versionPanel == null) {
            this.versionPanel = new VersionPanel(this.singleItem);
            this.versionPanel.setContentMargin();
            this.setTabAt(n, this.versionPanel);
            this.updateState();
        }
    }

    private void updateState() {
        boolean bl = this.hasLockedAndUnlocked.isTrue() || this.lockButton.isLocked();
        this.lockButton.setLocked(bl);
        Window window = this.lockButton.getWindowAncestor();
        if (window instanceof MDialog) {
            ((MDialog)MDialog.class.cast(window)).updateMnemonic(this.lockButton);
        }
        this.iconButton.setEnabled(!bl);
        this.tagsEditor.setEditable(!bl);
        this.rating.setEnabled(!bl);
        this.color.setEnabled(!bl);
        if (this.singleSelection) {
            this.commentField.setEditable(!bl);
            this.passwordButton.setEnabled(this.passwordSupported && !bl);
            if (this.advancedProperties != null) {
                this.advancedProperties.setLocked(bl || (Boolean)Vars.treeReadOnly.get() != false || !this.singleItem.isWriteable());
            }
            if (this.singleItem.getFS() instanceof FSProperties) {
                FSProperties fSProperties = (FSProperties)((Object)this.singleItem.getFS());
                fSProperties.lockProperties(bl);
            }
        } else {
            this.name.setEditable(false);
            this.passwordButton.setEnabled(false);
        }
    }
}

