/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web.xmlrpc;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import org.makagiga.commons.Base64;
import org.makagiga.commons.FS;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.commons.XMLHelper;
import org.makagiga.web.WebException;
import org.makagiga.web.xmlrpc.XMLRPCResponse;

public class XMLRPCClient
implements Serializable {
    private URL url;

    public XMLRPCClient(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public XMLRPCClient(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("Null \"url\"");
        }
        this.url = uRL;
    }

    public XMLRPCResponse execute(String string, Object ... objectArray) throws WebException {
        HttpURLConnection httpURLConnection;
        FS.TextWriter textWriter;
        FS.TextReader textReader;
        block7: {
            XMLRPCResponse xMLRPCResponse;
            block8: {
                String string2 = XMLRPCClient.toXML(string, objectArray);
                textReader = null;
                textWriter = null;
                httpURLConnection = null;
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                Net.setupConnection(httpURLConnection, 0);
                Net.setupOutputProperties(httpURLConnection, "text/xml", string2.length());
                textWriter = FS.getUTF8Writer(httpURLConnection.getOutputStream());
                textWriter.write(string2);
                textWriter.flush();
                if (httpURLConnection.getResponseCode() != 200) break block7;
                textReader = FS.getUTF8Reader(httpURLConnection.getInputStream());
                xMLRPCResponse = XMLHelper.unmarshal(XMLRPCResponse.class, textReader);
                if (httpURLConnection == null) break block8;
                httpURLConnection.disconnect();
            }
            FS.close(textReader);
            FS.close(textWriter);
            return xMLRPCResponse;
        }
        try {
            try {
                throw new WebException(httpURLConnection.getResponseMessage(), this.url);
            }
            catch (IOException iOException) {
                throw new WebException(iOException, this.url);
            }
            catch (JAXBException jAXBException) {
                throw new WebException(jAXBException, this.url);
            }
        }
        catch (Throwable throwable) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            FS.close(textReader);
            FS.close(textWriter);
            throw throwable;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public static String toXML(String string, Object ... objectArray) {
        TK.checkNullOrEmpty(string, "methodName");
        XMLBuilder xMLBuilder = new XMLBuilder(true);
        xMLBuilder.setEOL("\r\n");
        xMLBuilder.appendHeader(null);
        xMLBuilder.beginTag("methodCall");
        xMLBuilder.doubleTag("methodName", XMLBuilder.escape(string), new Object[0]);
        xMLBuilder.beginTag("params");
        if (objectArray != null) {
            for (Object object : objectArray) {
                xMLBuilder.doubleTag("param", XMLRPCClient.toXMLValue(object), new Object[0]);
            }
        }
        xMLBuilder.endTag("params");
        xMLBuilder.endTag("methodCall");
        return xMLBuilder.toString();
    }

    public static String toXMLValue(Object object) {
        if (object instanceof Boolean) {
            return "<boolean>" + ((Boolean)object != false ? "1" : "0") + "</boolean>";
        }
        if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss", Locale.US);
            return "<dateTime.iso8601>" + XMLBuilder.escape(simpleDateFormat.format((Date)object)) + "</dateTime.iso8601>";
        }
        if (object instanceof Double || object instanceof Float) {
            return "<double>" + XMLBuilder.escape(object.toString()) + "</double>";
        }
        if (object instanceof Integer) {
            return "<int>" + XMLBuilder.escape(object.toString()) + "</int>";
        }
        if (object instanceof String) {
            return "<string>" + XMLBuilder.escape(object.toString()) + "</string>";
        }
        if (object != null && object.getClass().getName().equals("[B")) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = Base64.encodeToByte(byArray, true);
            try {
                return "<base64>" + XMLBuilder.escape(new String(byArray2, "UTF8")) + "</base64>";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new WTFError(unsupportedEncodingException);
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + (object == null ? "null" : object.getClass().getName()));
    }
}

