/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.interpolator;

import org.pushingpixels.trident.ease.TimelineEase;
import org.pushingpixels.trident.interpolator.KeyInterpolators;
import org.pushingpixels.trident.interpolator.KeyTimes;
import org.pushingpixels.trident.interpolator.KeyValues;

public class KeyFrames<T> {
    private KeyValues<T> keyValues;
    private KeyTimes keyTimes;
    private KeyInterpolators interpolators;

    public KeyFrames(KeyValues<T> keyValues) {
        this.init(keyValues, null, new TimelineEase[]{null});
    }

    public KeyFrames(KeyValues<T> keyValues, KeyTimes keyTimes) {
        this.init(keyValues, keyTimes, new TimelineEase[]{null});
    }

    public KeyFrames(KeyValues<T> keyValues, KeyTimes keyTimes, TimelineEase ... timelineEaseArray) {
        this.init(keyValues, keyTimes, timelineEaseArray);
    }

    public KeyFrames(KeyValues<T> keyValues, TimelineEase ... timelineEaseArray) {
        this.init(keyValues, null, timelineEaseArray);
    }

    private void init(KeyValues<T> keyValues, KeyTimes keyTimes, TimelineEase ... timelineEaseArray) {
        int n = keyValues.getSize();
        if (keyTimes == null) {
            float f;
            float[] fArray = new float[n];
            fArray[0] = f = 0.0f;
            for (int i = 1; i < n - 1; ++i) {
                fArray[i] = f += 1.0f / (float)(n - 1);
            }
            fArray[n - 1] = 1.0f;
            this.keyTimes = new KeyTimes(fArray);
        } else {
            this.keyTimes = keyTimes;
        }
        this.keyValues = keyValues;
        if (n != this.keyTimes.getSize()) {
            throw new IllegalArgumentException("keyValues and keyTimes must be of equal size");
        }
        if (timelineEaseArray != null && timelineEaseArray.length != n - 1 && timelineEaseArray.length != 1) {
            throw new IllegalArgumentException("interpolators must be either null (implying interpolation for all intervals), a single interpolator (which will be used for all intervals), or a number of interpolators equal to one less than the number of times.");
        }
        this.interpolators = new KeyInterpolators(n - 1, timelineEaseArray);
    }

    public Class getType() {
        return this.keyValues.getType();
    }

    KeyValues getKeyValues() {
        return this.keyValues;
    }

    KeyTimes getKeyTimes() {
        return this.keyTimes;
    }

    public int getInterval(float f) {
        return this.keyTimes.getInterval(f);
    }

    public Object getValue(float f) {
        float f2;
        float f3;
        float f4;
        int n = this.getInterval(f);
        float f5 = this.interpolators.interpolate(n, f4 = (f - (f3 = this.keyTimes.getTime(n))) / ((f2 = this.keyTimes.getTime(n + 1)) - f3));
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        return this.keyValues.getValue(n, n + 1, f5);
    }
}

