#!/bin/bash

INSTALL_PREFIX=/usr/local
OUT_FILE=

if [ -n "${1}" ]; then
	INSTALL_PREFIX="${1}"
fi

function mg_install
{
	BASE_NAME=`basename "${1}"`
	OUT_FILE="${INSTALL_PREFIX}/${2}/${BASE_NAME}"
	echo "Installing '${OUT_FILE}'..."
	echo "if [ -d \"${INSTALL_PREFIX}/${2}\" ]; then rmdir -p --ignore-fail-on-non-empty \"${INSTALL_PREFIX}/${2}\"; fi" >> "${UNINSTALLER}.tmp"
	echo "rm -f \"${OUT_FILE}\"" >> "${UNINSTALLER}.tmp"
	mkdir -p "${INSTALL_PREFIX}/${2}"
	cp "${1}" "${INSTALL_PREFIX}/${2}"
}

mkdir -p "${INSTALL_PREFIX}/share/makagiga"
if [ ! -w "${INSTALL_PREFIX}" ]; then
	echo
	echo "ERROR: No permissions to write to '${INSTALL_PREFIX}'!"
	echo "       Possible solutions:"
	echo "       - Run the installer as the 'root' user (e.g. sudo ./install.sh)."
	echo "       - Change the installation directory (prefix) (e.g. ./install.sh ~/MyApps)."
	exit 1
fi

INSTALL_PREFIX=`readlink -f "$INSTALL_PREFIX"`
UNINSTALLER="${INSTALL_PREFIX}/share/makagiga/uninstall.sh"

echo > "${UNINSTALLER}.tmp"

# launchers
mg_install "makagiga" "bin"
mg_install "makagiga.desktop" "share/applications"

# icon and splash
mg_install "makagiga.png" "share/icons/hicolor/32x32/apps"
mg_install "xdg-email" "share/makagiga"
mg_install "xdg-open" "share/makagiga"

# core
mg_install "LICENSE.txt" "share/makagiga"
mg_install "README.html" "share/makagiga"
mg_install "README_fr.html" "share/makagiga"
mg_install "i18n.jar" "share/makagiga"
mg_install "images.jar" "share/makagiga"
mg_install "makagiga.jar" "share/makagiga"

TEMPLATE_PREFIX="$INSTALL_PREFIX"
if [ -n "$MAKAGIGA_FAKE_PREFIX" ]; then
	TEMPLATE_PREFIX="$MAKAGIGA_FAKE_PREFIX"
fi

# setup makagiga launcher
sed -i "s?\@@INSTALL_PREFIX@@?${TEMPLATE_PREFIX}?g" "${INSTALL_PREFIX}/bin/makagiga"
chmod +x "${INSTALL_PREFIX}/bin/makagiga"

# setup makagiga.desktop launcher
sed -i "s?\@@INSTALL_PREFIX@@?${TEMPLATE_PREFIX}?g" "${INSTALL_PREFIX}/share/applications/makagiga.desktop"

# setup installer
echo "#!/bin/bash" > "${UNINSTALLER}"
echo "rm -f \"${UNINSTALLER}\"" >> "${UNINSTALLER}"
# first remove files, then dirs
cat "${UNINSTALLER}.tmp" | sort -r | uniq >> "${UNINSTALLER}"
echo "echo \":-(\"" >> "${UNINSTALLER}"
rm "${UNINSTALLER}.tmp"
chmod +x "${INSTALL_PREFIX}/share/makagiga/uninstall.sh"

echo
echo "Thank you for using Makagiga!"
echo
MAKAGIGA_LAUNCHER=`which makagiga 2>/dev/null`
if [ -z "${MAKAGIGA_LAUNCHER}" ]; then
	echo "- Type '${INSTALL_PREFIX}/bin/makagiga' to run Makagiga."
else
	echo "- Type 'makagiga' to run Makagiga."
fi
echo "- Run '${UNINSTALLER}' to uninstall Makagiga."
echo "- Make sure you have installed Java SE 6"
echo "  You can download Java from 'http://java.com/'."
echo
